/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core.history;

import java.io.Serializable;
import org.eclipse.mylyn.internal.bugzilla.core.history.AssignmentEvent;
import org.eclipse.mylyn.internal.bugzilla.core.history.AttachmentEvent;
import org.eclipse.mylyn.internal.bugzilla.core.history.ResolutionEvent;
import org.eclipse.mylyn.internal.bugzilla.core.history.ResolutionType;
import org.eclipse.mylyn.internal.bugzilla.core.history.StatusEvent;
import org.eclipse.mylyn.internal.bugzilla.core.history.StatusType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskRevision
implements Comparable<TaskRevision>,
Serializable {
    private static final long serialVersionUID = 7739060501945994522L;
    protected static final String STATUS = "Status";
    protected static final String RESOLUTION = "Resolution";
    protected static final String ASSIGNMENT = "AssignedTo";
    protected static final String ATTACHMENT = "Attachment";
    protected String name;
    protected String date;
    protected String what;
    protected String removed;
    protected String added = "";

    protected TaskRevision() {
    }

    public static TaskRevision createEvent(String type, String change) {
        TaskRevision event = new TaskRevision();
        event.setWhat(type);
        if (STATUS.equals(type)) {
            event = new StatusEvent(StatusType.convert(change));
        }
        if (RESOLUTION.equals(type)) {
            event = new ResolutionEvent(ResolutionType.convert(change));
        }
        if (ASSIGNMENT.equals(type)) {
            event = new AssignmentEvent(change);
        }
        if (type.contains(ATTACHMENT) && type.contains("Flag")) {
            event = new AttachmentEvent(AttachmentEvent.parseId(type), AttachmentEvent.parseFlags(change));
        }
        event.setAdded(change);
        return event;
    }

    private void setAdded(String added) {
        this.added = added;
    }

    public void setRemoved(String removed) {
        this.removed = removed;
    }

    private void setWhat(String what) {
        this.what = what;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAdded() {
        return this.added;
    }

    public String getRemoved() {
        return this.removed;
    }

    public String getWhat() {
        return this.what;
    }

    public String getDate() {
        return this.date;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.name) + " | " + this.date + " | " + this.what + " | " + this.removed + " | " + this.added;
    }

    @Override
    public int compareTo(TaskRevision o) {
        return this.date.compareTo(o.getDate());
    }
}

