/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages;

import java.util.List;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.Language;

public final class ASTToken
extends ASTItem {
    private String identifier;
    private int type;
    private String toString;

    public static ASTToken create(Language language, int type, String identifier, int offset, int length, List<? extends ASTItem> children) {
        return new ASTToken(language, type, identifier, offset, length, children);
    }

    public static ASTToken create(Language language, String typeName, String identifier, int offset, int length, List<? extends ASTItem> children) {
        int typeID = ((org.netbeans.modules.languages.Language)language).getTokenID(typeName);
        return new ASTToken(language, typeID, identifier, offset, length, children);
    }

    public static ASTToken create(Language language, int type, String identifier, int offset) {
        return new ASTToken(language, type, identifier, offset, identifier == null ? 0 : identifier.length(), null);
    }

    private ASTToken(Language language, int type, String identifier, int offset, int length, List<? extends ASTItem> children) {
        super(language, offset, length, children);
        this.identifier = identifier;
        this.type = type;
    }

    public int getTypeID() {
        return this.type;
    }

    public String getTypeName() {
        org.netbeans.modules.languages.Language l = (org.netbeans.modules.languages.Language)this.getLanguage();
        if (l == null) {
            return null;
        }
        return l.getTokenType(this.type);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuffer sb = new StringBuffer();
            sb.append('<').append(this.getTypeName());
            if (this.identifier != null) {
                sb.append(",'").append(ASTToken.e(this.identifier)).append("'");
            }
            sb.append('>');
            this.toString = sb.toString();
        }
        return this.toString;
    }

    private static String e(CharSequence t) {
        StringBuilder sb = new StringBuilder();
        int k = t.length();
        for (int i = 0; i < k; ++i) {
            if (t.charAt(i) == '\t') {
                sb.append("\\t");
                continue;
            }
            if (t.charAt(i) == '\r') {
                sb.append("\\r");
                continue;
            }
            if (t.charAt(i) == '\n') {
                sb.append("\\n");
                continue;
            }
            sb.append(t.charAt(i));
        }
        return sb.toString();
    }
}

