/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.api.gsf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.completion.CompletionItem;

public abstract class HtmlExtension {
    private static final Map<String, Collection<HtmlExtension>> EXTENSIONS = new HashMap<String, Collection<HtmlExtension>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String mimeType, HtmlExtension extension) {
        Map<String, Collection<HtmlExtension>> map = EXTENSIONS;
        synchronized (map) {
            Collection<HtmlExtension> existing = EXTENSIONS.get(mimeType);
            if (existing == null) {
                existing = new ArrayList<HtmlExtension>();
                EXTENSIONS.put(mimeType, existing);
            }
            existing.add(extension);
        }
    }

    public static Collection<HtmlExtension> getRegisteredExtensions(String mimeType) {
        Collection<HtmlExtension> exts = EXTENSIONS.get(mimeType);
        return exts != null ? exts : Collections.emptyList();
    }

    public abstract Map<OffsetRange, Set<ColoringAttributes>> getHighlights(HtmlParserResult var1, SchedulerEvent var2);

    public abstract List<CompletionItem> completeOpenTags(CompletionContext var1);

    public abstract List<CompletionItem> completeAttributes(CompletionContext var1);

    public abstract List<CompletionItem> completeAttributeValue(CompletionContext var1);

    public abstract OffsetRange getReferenceSpan(Document var1, int var2);

    public abstract DeclarationFinder.DeclarationLocation findDeclaration(ParserResult var1, int var2);

    public abstract void computeErrors(HintsProvider.HintsManager var1, RuleContext var2, List<Hint> var3, List<Error> var4);

    public abstract void computeSelectionHints(HintsProvider.HintsManager var1, RuleContext var2, List<Hint> var3, int var4, int var5);

    public static class CompletionContext {
        private HtmlParserResult result;
        private int originalOffset;
        private int ccItemStartOffset;
        private int astoffset;
        private String preText;
        private String itemText;
        private AstNode currentNode;
        private String attributeName;
        private boolean valueQuoted;

        public CompletionContext(HtmlParserResult result, int originalOffset, int astoffset, int ccItemStartOffset, String preText, String itemText) {
            this(result, originalOffset, astoffset, ccItemStartOffset, preText, itemText, null);
        }

        public CompletionContext(HtmlParserResult result, int originalOffset, int astoffset, int ccItemStartOffset, String preText, String itemText, AstNode currentNode) {
            this(result, originalOffset, astoffset, ccItemStartOffset, preText, itemText, currentNode, null, false);
        }

        public CompletionContext(HtmlParserResult result, int originalOffset, int astoffset, int ccItemStartOffset, String preText, String itemText, AstNode currentNode, String attributeName, boolean valueQuoted) {
            this.result = result;
            this.originalOffset = originalOffset;
            this.astoffset = astoffset;
            this.preText = preText;
            this.ccItemStartOffset = ccItemStartOffset;
            this.currentNode = currentNode;
            this.itemText = itemText;
            this.attributeName = attributeName;
            this.valueQuoted = valueQuoted;
        }

        public String getPrefix() {
            return this.preText;
        }

        public String getItemText() {
            return this.itemText;
        }

        public int getAstoffset() {
            return this.astoffset;
        }

        public int getOriginalOffset() {
            return this.originalOffset;
        }

        public int getCCItemStartOffset() {
            return this.ccItemStartOffset;
        }

        public HtmlParserResult getResult() {
            return this.result;
        }

        public AstNode getCurrentNode() {
            return this.currentNode;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public boolean isValueQuoted() {
            return this.valueQuoted;
        }
    }
}

