/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mobility.project.ui.customizer.NewConfigurationPanel;
import org.netbeans.spi.mobility.cfgfactory.ProjectConfigurationFactory;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.TreeTableView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class ConfigurationsSelectionPanelGUI
extends JPanel
implements ExplorerManager.Provider {
    private final ExplorerManager manager = new ExplorerManager();
    private final TreeTableView treeView;
    private final Set<String> bannedNames;
    private Set<ProjectConfigurationFactory.ConfigurationTemplateDescriptor> selection = new HashSet<ProjectConfigurationFactory.ConfigurationTemplateDescriptor>();
    private final ChangeSupport change = new ChangeSupport((Object)this);
    private JLabel jLabel1;
    private JPanel templatesPanel;

    public ConfigurationsSelectionPanelGUI() {
        this(Collections.EMPTY_SET);
    }

    public ConfigurationsSelectionPanelGUI(Set<String> bannedNames) {
        this.bannedNames = bannedNames;
        this.initComponents();
        this.treeView = new TreeTableView();
        this.jLabel1.setLabelFor((Component)this.treeView);
        this.treeView.setPopupAllowed(false);
        this.treeView.setRootVisible(false);
        this.treeView.setDefaultActionAllowed(false);
        this.treeView.setSelectionMode(1);
        this.treeView.setProperties(new Node.Property[]{new SelectedProp(null, null)});
        this.templatesPanel.add((Component)this.treeView, "Center");
        AbstractNode root = new AbstractNode(Children.create((ChildFactory)new RootChildren(), (boolean)true));
        root.setName(NbBundle.getMessage(ConfigurationsSelectionPanelGUI.class, (String)"LBL_CfgSelectionPanel_Templates"));
        this.manager.setRootContext((Node)root);
        this.treeView.setPreferredSize(new Dimension(480, 350));
        this.treeView.setTreePreferredWidth(420);
        this.treeView.setTableColumnPreferredWidth(0, 60);
    }

    private void fireChange() {
        this.change.fireChange();
    }

    public void addChangeListener(ChangeListener l) {
        this.change.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.change.removeChangeListener(l);
    }

    public boolean valid() {
        HashSet<String> names = new HashSet<String>(this.bannedNames);
        for (ProjectConfigurationFactory.ConfigurationTemplateDescriptor cfg : this.selection) {
            if (names.add(cfg.getCfgName())) continue;
            return false;
        }
        return true;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void setSelectedTemplates(Set<ProjectConfigurationFactory.ConfigurationTemplateDescriptor> selected) {
        this.selection = selected;
    }

    public Set<ProjectConfigurationFactory.ConfigurationTemplateDescriptor> getSelectedTemplates() {
        return this.selection;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.templatesPanel = new JPanel();
        this.setName(NbBundle.getMessage(ConfigurationsSelectionPanelGUI.class, (String)"TITLE_ConfigurationsSelection"));
        this.setPreferredSize(new Dimension(560, 350));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.templatesPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ConfigurationsSelectionPanelGUI.class, (String)"LBL_ConfigurationsSelection"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.templatesPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.templatesPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.templatesPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigurationsSelectionPanelGUI.class, (String)"ACSN_CfgSelectionPanel_Selection"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigurationsSelectionPanelGUI.class, (String)"ACSD_CfgSelectionPanel_Selection"));
    }

    private final class SelectedProp
    extends PropertySupport.ReadWrite<Boolean> {
        private final ProjectConfigurationFactory.ConfigurationTemplateDescriptor cfgTmp;
        private Set<ProjectConfigurationFactory.ConfigurationTemplateDescriptor> selection;

        private SelectedProp(ProjectConfigurationFactory.ConfigurationTemplateDescriptor cfgTmp, Set<ProjectConfigurationFactory.ConfigurationTemplateDescriptor> selection) {
            this(cfgTmp, selection, NbBundle.getMessage(ConfigurationsSelectionPanelGUI.class, (String)"LBL_CfgSelectionPanel_Selection"));
        }

        private SelectedProp(ProjectConfigurationFactory.ConfigurationTemplateDescriptor cfgTmp, Set<ProjectConfigurationFactory.ConfigurationTemplateDescriptor> selection, String name) {
            super("selection", Boolean.class, name, name);
            this.selection = selection;
            this.cfgTmp = cfgTmp;
        }

        public Boolean getValue() throws IllegalAccessException, InvocationTargetException {
            return this.selection == null ? Boolean.TRUE.booleanValue() : this.selection.contains(this.cfgTmp);
        }

        public void setValue(Boolean val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val.booleanValue()) {
                this.selection.add(this.cfgTmp);
            } else {
                this.selection.remove(this.cfgTmp);
            }
            ConfigurationsSelectionPanelGUI.this.fireChange();
        }
    }

    private final class TemplateNode
    extends AbstractNode {
        private ProjectConfigurationFactory.ConfigurationTemplateDescriptor cfgTmp;

        public TemplateNode(ProjectConfigurationFactory.ConfigurationTemplateDescriptor cfgTmp) {
            super(Children.LEAF);
            this.cfgTmp = cfgTmp;
            this.setDisplayName(cfgTmp.getDisplayName().equals(cfgTmp.getCfgName()) ? cfgTmp.getDisplayName() : NbBundle.getMessage(ConfigurationsSelectionPanelGUI.class, (String)"LBL_CfgSlePanel_TemplateNodePattern", (Object)cfgTmp.getDisplayName(), (Object)cfgTmp.getCfgName()));
        }

        protected Sheet createSheet() {
            Sheet s = Sheet.createDefault();
            Sheet.Set ss = s.get("properties");
            ss.put((Node.Property)new SelectedProp(this.cfgTmp, ConfigurationsSelectionPanelGUI.this.selection));
            return s;
        }
    }

    private final class CategoryChildren
    extends ChildFactory<ProjectConfigurationFactory.Descriptor> {
        private final ProjectConfigurationFactory.CategoryDescriptor cat;

        CategoryChildren(ProjectConfigurationFactory.CategoryDescriptor cat) {
            this.cat = cat;
        }

        protected Node createNodeForKey(ProjectConfigurationFactory.Descriptor key) {
            ProjectConfigurationFactory.ConfigurationTemplateDescriptor desc;
            if (key instanceof ProjectConfigurationFactory.CategoryDescriptor) {
                return new CategoryNode((ProjectConfigurationFactory.CategoryDescriptor)key);
            }
            if (key instanceof ProjectConfigurationFactory.ConfigurationTemplateDescriptor && Utilities.isJavaIdentifier((String)(desc = (ProjectConfigurationFactory.ConfigurationTemplateDescriptor)key).getCfgName())) {
                return new TemplateNode(desc);
            }
            return null;
        }

        protected boolean createKeys(List<ProjectConfigurationFactory.Descriptor> toPopulate) {
            toPopulate.addAll(this.cat.getChildren());
            return true;
        }
    }

    private final class CategoryNode
    extends AbstractNode {
        public CategoryNode(ProjectConfigurationFactory.CategoryDescriptor cat) {
            super(Children.create((ChildFactory)new CategoryChildren(cat), (boolean)true));
            this.setDisplayName(cat.getDisplayName());
        }

        public Image getIcon(int type) {
            return NewConfigurationPanel.CLOSED_ICON == null ? super.getIcon(type) : NewConfigurationPanel.CLOSED_ICON;
        }

        public Image getOpenedIcon(int type) {
            return NewConfigurationPanel.OPENED_ICON == null ? super.getOpenedIcon(type) : NewConfigurationPanel.OPENED_ICON;
        }
    }

    private final class RootChildren
    extends ChildFactory<ProjectConfigurationFactory> {
        private RootChildren() {
        }

        protected Node createNodeForKey(ProjectConfigurationFactory key) {
            ProjectConfigurationFactory.CategoryDescriptor cat = key.getRootCategory();
            return cat == null ? null : new CategoryNode(key.getRootCategory());
        }

        protected boolean createKeys(List<ProjectConfigurationFactory> toPopulate) {
            toPopulate.addAll(Lookup.getDefault().lookupAll(ProjectConfigurationFactory.class));
            return true;
        }
    }
}

