/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.modules.mobility.project.GlobalAbilitiesCache;
import org.netbeans.modules.mobility.project.ui.customizer.AddAbilityPanel;
import org.netbeans.modules.mobility.project.ui.customizer.AddAttributePanel;
import org.netbeans.spi.mobility.project.ui.customizer.CustomizerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.VisualPropertyGroup;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerAbilities
extends JPanel
implements CustomizerPanel,
VisualPropertyGroup,
ListSelectionListener {
    static final String[] PROPERTY_GROUP = new String[]{"abilities"};
    protected final JTable table;
    protected final StorableTableModel tableModel;
    private VisualPropertySupport vps;
    private ProjectProperties props;
    private JButton bAdd;
    private JButton bEdit;
    private JButton bRemove;
    private JCheckBox cDefault;
    private JLabel lTable;
    private JScrollPane scrollPane;

    public CustomizerAbilities() {
        this.initComponents();
        this.initAccessibility();
        this.tableModel = new StorableTableModel();
        this.table = new JTable(this.tableModel);
        this.scrollPane.setViewportView(this.table);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    CustomizerAbilities.this.bEditActionPerformed(null);
                }
            }
        });
        GlobalAbilitiesCache.getDefault();
    }

    private void initComponents() {
        this.cDefault = new JCheckBox();
        this.lTable = new JLabel();
        this.scrollPane = new JScrollPane();
        this.bAdd = new JButton();
        this.bEdit = new JButton();
        this.bRemove = new JButton();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.cDefault, (String)NbBundle.getMessage(CustomizerAbilities.class, (String)"LBL_Use_Default"));
        this.cDefault.setMargin(new Insets(0, 0, 0, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.cDefault, gridBagConstraints);
        this.lTable.setLabelFor(this.lTable);
        Mnemonics.setLocalizedText((JLabel)this.lTable, (String)NbBundle.getMessage(CustomizerAbilities.class, (String)"LBL_Abilities_Abilities"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 4);
        this.add((Component)this.lTable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bAdd, (String)NbBundle.getMessage(CustomizerAbilities.class, (String)"LBL_Abilities_AddAbility"));
        this.bAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerAbilities.this.bAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 11, 0);
        this.add((Component)this.bAdd, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bEdit, (String)NbBundle.getMessage(CustomizerAbilities.class, (String)"LBL_Abilities_EditAbility"));
        this.bEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerAbilities.this.bEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 11, 0);
        this.add((Component)this.bEdit, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bRemove, (String)NbBundle.getMessage(CustomizerAbilities.class, (String)"LBL_Abilities_RemoveAbility"));
        this.bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerAbilities.this.bRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.bRemove, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerAbilities.class, (String)"ACSN_CustAbilities"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerAbilities.class, (String)"ACSD_CustAbilities"));
    }

    @Override
    public void initValues(ProjectProperties props, String configuration) {
        this.props = props;
        this.vps = VisualPropertySupport.getDefault(props);
        this.vps.register(this.cDefault, configuration, this);
    }

    @Override
    public String[] getGroupPropertyNames() {
        return PROPERTY_GROUP;
    }

    @Override
    public void initGroupValues(boolean useDefault) {
        this.vps.register(this.tableModel, new String[]{"abilities"}, useDefault);
        boolean notUseDefault = useDefault ^ true;
        this.bAdd.setEnabled(notUseDefault);
        this.bEdit.setEnabled(notUseDefault);
        this.bRemove.setEnabled(notUseDefault);
        this.table.setEnabled(notUseDefault);
        this.lTable.setEnabled(notUseDefault);
        this.table.setBackground(UIManager.getDefaults().getColor(useDefault ? "Panel.background" : "Table.background"));
        this.valueChanged(null);
    }

    private Set<String> getUsedIdentifiers() {
        HashSet<String> uI = new HashSet<String>(this.tableModel.getKeys());
        ProjectConfiguration[] cfg = this.props.getConfigurations();
        for (int i = 0; i < cfg.length; ++i) {
            uI.add(cfg[i].getDisplayName());
        }
        return uI;
    }

    private void bAddActionPerformed(ActionEvent evt) {
        final AddAbilityPanel add = new AddAbilityPanel();
        Set<String> usedIdentifiers = this.getUsedIdentifiers();
        Vector<String> proposedAbilities = new Vector<String>(GlobalAbilitiesCache.getDefault().getAllAbilities());
        proposedAbilities.removeAll(usedIdentifiers);
        add.init(false, proposedAbilities, usedIdentifiers, null, null);
        DialogDescriptor dd = new DialogDescriptor((Object)add, NbBundle.getMessage(CustomizerAbilities.class, (String)"TITLE_AddAbility"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx(AddAttributePanel.class), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NotifyDescriptor.OK_OPTION.equals(e.getSource())) {
                    String key = add.getKey();
                    GlobalAbilitiesCache.getDefault().addAbility(key);
                    int row = CustomizerAbilities.this.tableModel.addRow(key, add.getValue());
                    CustomizerAbilities.this.table.getSelectionModel().setSelectionInterval(row, row);
                }
            }
        });
        add.setDialogDescriptor(dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
    }

    private void bEditActionPerformed(ActionEvent evt) {
        final int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        final String key = this.tableModel.getValueAt(row, 0);
        String value = this.tableModel.getValueAt(row, 1);
        final AddAbilityPanel add = new AddAbilityPanel();
        Set<String> usedIdentifiers = this.getUsedIdentifiers();
        Vector<String> proposedAbilities = new Vector<String>(GlobalAbilitiesCache.getDefault().getAllAbilities());
        proposedAbilities.removeAll(usedIdentifiers);
        if (key != null) {
            proposedAbilities.add(key);
        }
        add.init(true, proposedAbilities, usedIdentifiers, key, value);
        DialogDescriptor dd = new DialogDescriptor((Object)add, NbBundle.getMessage(CustomizerAbilities.class, (String)"TITLE_EditAbility"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx(AddAttributePanel.class), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NotifyDescriptor.OK_OPTION.equals(e.getSource())) {
                    String newkey = add.getKey();
                    GlobalAbilitiesCache.getDefault().addAbility(newkey);
                    if (key == null || !key.equals(newkey)) {
                        if (key != null) {
                            CustomizerAbilities.this.tableModel.removeRow(row);
                        }
                        int newrow = CustomizerAbilities.this.tableModel.addRow(newkey, add.getValue());
                        CustomizerAbilities.this.table.getSelectionModel().setSelectionInterval(newrow, newrow);
                    } else {
                        CustomizerAbilities.this.tableModel.editRow(newkey, add.getValue());
                        CustomizerAbilities.this.table.getSelectionModel().setSelectionInterval(row, row);
                    }
                }
            }
        });
        add.setDialogDescriptor(dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
    }

    private void bRemoveActionPerformed(ActionEvent evt) {
        int i = this.table.getSelectedRow();
        if (i < 0) {
            return;
        }
        this.tableModel.removeRow(i);
        int max = this.tableModel.getRowCount();
        if (max <= 0) {
            this.table.getSelectionModel().clearSelection();
        } else if (i < max) {
            this.table.getSelectionModel().setSelectionInterval(i, i);
        } else {
            this.table.getSelectionModel().setSelectionInterval(max - 1, max - 1);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int row = this.table.getSelectedRow();
        boolean enabled = this.table.isEnabled() && row >= 0;
        this.bEdit.setEnabled(enabled);
        this.bRemove.setEnabled(enabled);
    }

    public static class StorableTableModel
    extends AbstractTableModel
    implements VisualPropertySupport.StorableTableModel {
        private ArrayList<Map.Entry<String, String>> entries = new ArrayList();
        private HashMap<String, String> map = new HashMap();
        private static final long serialVersionUID = -2195421895353167171L;

        @Override
        public int getRowCount() {
            return this.entries.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Set<String> getKeys() {
            return this.map.keySet();
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return NbBundle.getMessage(CustomizerAbilities.class, (String)"LBL_Abilities_Column_Ability");
                }
                case 1: {
                    return NbBundle.getMessage(CustomizerAbilities.class, (String)"LBL_Abilities_Column_Value");
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public synchronized Object[] getDataDelegates() {
            return new Object[]{this.map};
        }

        @Override
        public String getValueAt(int rowIndex, int columnIndex) {
            assert (rowIndex < this.entries.size());
            Map.Entry<String, String> e = this.entries.get(rowIndex);
            return columnIndex == 0 ? e.getKey() : (e.getValue() == null ? "" : e.getValue());
        }

        @Override
        public synchronized void setDataDelegates(Object[] data) {
            assert (data != null);
            this.map = data[0] == null ? new HashMap() : (HashMap)data[0];
            this.entries = new ArrayList<Map.Entry<String, String>>(this.map.entrySet());
            Collections.sort(this.entries, new AbilitiesComparator());
            this.fireTableDataChanged();
        }

        public int addRow(String key, String value) {
            Map.Entry<String, String> e;
            if (this.map.containsKey(key)) {
                return -1;
            }
            this.map.put(key, value);
            Iterator<Map.Entry<String, String>> it = this.map.entrySet().iterator();
            while (!key.equals((e = it.next()).getKey())) {
            }
            int row = this.entries.size();
            this.entries.add(e);
            this.fireTableRowsInserted(row, row);
            return row;
        }

        public void editRow(String key, String value) {
            this.map.put(key, value);
            for (int i = 0; i < this.entries.size(); ++i) {
                if (!this.entries.get(i).getKey().equals(key)) continue;
                this.fireTableRowsUpdated(i, i);
                return;
            }
        }

        public void removeRow(int row) {
            assert (row < this.entries.size());
            Map.Entry<String, String> e = this.entries.remove(row);
            this.map.entrySet().remove(e);
            this.fireTableRowsDeleted(row, this.entries.size() + 1);
        }

        private static class AbilitiesComparator
        implements Comparator<Map.Entry<String, String>> {
            private AbilitiesComparator() {
            }

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareToIgnoreCase(o2.getKey());
            }

            @Override
            public boolean equals(Object obj) {
                return this.equals(obj);
            }
        }
    }
}

