/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.actions;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

public final class SelectConfigurationAction
extends AbstractAction
implements ContextAwareAction,
Presenter.Popup {
    private final Lookup context;

    private SelectConfigurationAction() {
        this(Utilities.actionsGlobalContext());
        this.putValue("Name", NbBundle.getMessage(SelectConfigurationAction.class, (String)"LBL_SelConfigurationAction"));
    }

    private SelectConfigurationAction(Lookup context) {
        this.context = context;
    }

    public static Action getStaticInstance() {
        return new SelectConfigurationAction();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        throw new UnsupportedOperationException("Should never be called");
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new SelectConfigurationAction(actionContext);
    }

    @Override
    public boolean isEnabled() {
        return this.context.lookupItem(new Lookup.Template(J2MEProject.class)) != null;
    }

    public JMenuItem getPopupPresenter() {
        J2MEProject project = (J2MEProject)this.context.lookup(J2MEProject.class);
        assert (project != null);
        ProjectConfigurationsHelper helper = project.getConfigurationHelper();
        JMenu result = new JMenu(NbBundle.getMessage(SelectConfigurationAction.class, (String)"LBL_SelConfigurationAction"));
        ProjectConfiguration active = helper.getActiveConfiguration();
        for (ProjectConfiguration c : helper.getConfigurations()) {
            OneConfigurationAction cfgAction = new OneConfigurationAction(c);
            JMenuItem item = new JMenuItem(cfgAction);
            if (active.equals(c)) {
                Font f = item.getFont();
                f = f.deriveFont(1);
                item.setFont(f);
            }
            result.add(item);
        }
        return result;
    }

    private final class OneConfigurationAction
    extends AbstractAction {
        private final ProjectConfiguration config;

        OneConfigurationAction(ProjectConfiguration config) {
            this.putValue("Name", config.getDisplayName());
            this.config = config;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            J2MEProject project = (J2MEProject)SelectConfigurationAction.this.context.lookup(J2MEProject.class);
            assert (project != null);
            try {
                project.getConfigurationHelper().setActiveConfiguration(this.config);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

