/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui;

import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Action;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.ui.AbilitiesPanel;
import org.netbeans.modules.mobility.project.ui.DecoratedNode;
import org.netbeans.modules.mobility.project.ui.ResourcesNode;
import org.netbeans.modules.mobility.project.ui.actions.BuildConfigurationAction;
import org.netbeans.modules.mobility.project.ui.actions.CleanAndBuildConfigurationAction;
import org.netbeans.modules.mobility.project.ui.actions.CleanConfigurationAction;
import org.netbeans.modules.mobility.project.ui.actions.DebugConfigurationAction;
import org.netbeans.modules.mobility.project.ui.actions.DeployConfigurationAction;
import org.netbeans.modules.mobility.project.ui.actions.RemoveConfigurationAction;
import org.netbeans.modules.mobility.project.ui.actions.RunConfigurationAction;
import org.netbeans.modules.mobility.project.ui.actions.SetConfigurationAction;
import org.netbeans.modules.mobility.project.ui.customizer.CloneConfigurationPanel;
import org.netbeans.modules.mobility.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.VisualConfigSupport;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

final class OneConfigurationNode
extends DecoratedNode
implements PropertyChangeListener,
AntProjectListener {
    private final ProjectConfiguration config;
    private static final String KEY_RESOURCES = "Resources";
    final Map<J2MEProject, HashSet<Node>> map = new WeakHashMap<J2MEProject, HashSet<Node>>();
    private PasteType pType;

    OneConfigurationNode(J2MEProject project, ProjectConfiguration config) {
        super(Children.create((ChildFactory)new ConfigurationChildren(project, config), (boolean)false), Lookups.fixed((Object[])new Object[]{project, config, AbilitiesPanel.hintInstance}));
        this.config = config;
        this.setIconBaseWithExtension("org/netbeans/modules/mobility/project/ui/resources/config.gif");
        String name = config.getDisplayName();
        this.setDisplayName(name);
        this.setName(name);
        ProjectConfiguration currConfig = project.getConfigurationHelper().getActiveConfiguration();
        this.setValue("bold", currConfig != null && name.equals(currConfig.getDisplayName()));
        ProjectConfigurationsHelper helper = project.getConfigurationHelper();
        helper.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)helper));
        JavaPlatformManager mgr = JavaPlatformManager.getDefault();
        mgr.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)mgr));
        LibraryManager lmgr = LibraryManager.getDefault();
        lmgr.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)lmgr));
        AntProjectHelper antHelper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        antHelper.addAntProjectListener((AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this, (Object)antHelper));
        this.checkBroken();
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        this.checkBroken();
    }

    public void propertiesChanged(AntProjectEvent ev) {
        this.checkBroken();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("activeConfiguration".equals(evt.getPropertyName())) {
            ProjectConfiguration active = (ProjectConfiguration)evt.getNewValue();
            boolean isActive = active != null && this.getName().equals(active.getDisplayName());
            this.setValue("bold", isActive);
        } else {
            this.checkBroken();
        }
    }

    @Override
    protected boolean isBroken() {
        J2MEProject project = (J2MEProject)this.getLookup().lookup(J2MEProject.class);
        boolean broken = project.isConfigBroken(this.config);
        return broken;
    }

    public Action[] getActions(boolean ignored) {
        J2MEProject prj = (J2MEProject)this.getLookup().lookup(J2MEProject.class);
        ProjectConfigurationsHelper cfgHelper = prj.getConfigurationHelper();
        ProjectConfiguration defCfg = cfgHelper.getDefaultConfiguration();
        boolean isDefault = defCfg.equals(this.config);
        return new Action[]{RunConfigurationAction.getStaticInstance(), DebugConfigurationAction.getStaticInstance(), BuildConfigurationAction.getStaticInstance(), CleanAndBuildConfigurationAction.getStaticInstance(), CleanConfigurationAction.getStaticInstance(), DeployConfigurationAction.getStaticInstance(), null, SystemAction.get(CopyAction.class), null, SetConfigurationAction.getStaticInstance(), isDefault ? null : RemoveConfigurationAction.getStaticInstance()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PasteType getPasteType(Transferable tr, DataFlavor[] flavors) {
        String PRIMARY_TYPE = "application";
        String DND_TYPE = "x-java-openide-nodednd";
        String MULTI_TYPE = "x-java-openide-multinode";
        OneConfigurationNode oneConfigurationNode = this;
        synchronized (oneConfigurationNode) {
            if (this.pType == null) {
                class CfgPasteType
                extends PasteType {
                    CfgPasteType() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Transferable paste() throws IOException {
                        final J2MEProject projectDrop = (J2MEProject)OneConfigurationNode.this.getLookup().lookup(J2MEProject.class);
                        if (projectDrop == null) {
                            return null;
                        }
                        final J2MEProjectProperties dropProperties = new J2MEProjectProperties(projectDrop, (AntProjectHelper)projectDrop.getLookup().lookup(AntProjectHelper.class), (ReferenceHelper)projectDrop.getLookup().lookup(ReferenceHelper.class), projectDrop.getConfigurationHelper());
                        ArrayList<ProjectConfiguration> allNames = new ArrayList<ProjectConfiguration>(Arrays.asList(dropProperties.getConfigurations()));
                        int size = allNames.size();
                        ProjectConfiguration oldCfg = null;
                        ProjectConfiguration newCfg = null;
                        for (J2MEProject project : OneConfigurationNode.this.map.keySet()) {
                            if (project == null) continue;
                            HashSet<Node> set = OneConfigurationNode.this.map.get(project);
                            ArrayList<String> allStrNames = new ArrayList<String>(allNames.size() + set.size());
                            J2MEProjectProperties j2meProperties = new J2MEProjectProperties(project, (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class), (ReferenceHelper)project.getLookup().lookup(ReferenceHelper.class), project.getConfigurationHelper());
                            for (ProjectConfiguration name : allNames) {
                                allStrNames.add(name.getDisplayName());
                            }
                            for (Node node : set) {
                                newCfg = oldCfg = (ProjectConfiguration)node.getLookup().lookup(ProjectConfiguration.class);
                                ProjectConfiguration exst = projectDrop.getConfigurationHelper().getConfigurationByName(oldCfg.getDisplayName());
                                if (exst != null) {
                                    CloneConfigurationPanel ccp = new CloneConfigurationPanel(allStrNames);
                                    DialogDescriptor dd = new DialogDescriptor((Object)ccp, NbBundle.getMessage(VisualConfigSupport.class, (String)"LBL_VCS_DuplConfiguration", (Object)oldCfg.getDisplayName()), true, 2, NotifyDescriptor.OK_OPTION, null);
                                    ccp.setDialogDescriptor(dd);
                                    final String newName = NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dd)) ? ccp.getName() : null;
                                    if (newName == null) continue;
                                    newCfg = new ProjectConfiguration(){

                                        public String getDisplayName() {
                                            return newName;
                                        }
                                    };
                                    allStrNames.add(newName);
                                }
                                String[] keys = j2meProperties.keySet().toArray(new String[j2meProperties.size()]);
                                String prefix = "configs." + oldCfg.getDisplayName();
                                for (int i = 0; i < keys.length; ++i) {
                                    if (!keys[i].startsWith(prefix)) continue;
                                    dropProperties.put("configs." + newCfg.getDisplayName() + keys[i].substring(prefix.length()), j2meProperties.get(keys[i]));
                                }
                                allNames.add(newCfg);
                            }
                        }
                        OneConfigurationNode.this.map.clear();
                        Object i$ = this;
                        synchronized (i$) {
                            OneConfigurationNode.this.pType = null;
                        }
                        if (allNames.size() == size) {
                            return null;
                        }
                        dropProperties.setConfigurations(allNames.toArray(new ProjectConfiguration[allNames.size()]));
                        final ProjectConfiguration lcfg = newCfg;
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                assert (lcfg != null);
                                try {
                                    Children.MUTEX.writeAccess(new Runnable(){

                                        @Override
                                        public void run() {
                                            dropProperties.store();
                                        }
                                    });
                                    projectDrop.getConfigurationHelper().setActiveConfiguration(lcfg);
                                }
                                catch (IllegalArgumentException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                        });
                        return null;
                    }
                }
                this.pType = new CfgPasteType();
            }
        }
        for (DataFlavor flavor : flavors) {
            J2MEProject project;
            if (!"application".equals(flavor.getPrimaryType())) continue;
            if ("x-java-openide-multinode".equals(flavor.getSubType())) {
                Node[] nodes = NodeTransfer.nodes((Transferable)tr, (int)3);
                if (nodes == null) {
                    return null;
                }
                for (Node node : nodes) {
                    J2MEProject project2;
                    if (!(node instanceof OneConfigurationNode) || (project2 = (J2MEProject)node.getLookup().lookup(J2MEProject.class)) == null) continue;
                    HashSet<Object> set = this.map.get(project2);
                    if (set == null) {
                        set = new HashSet();
                        this.map.put(project2, set);
                    }
                    set.add(node);
                }
                if (this.map.size() != 0) {
                    return this.pType;
                }
            }
            if (!"x-java-openide-nodednd".equals(flavor.getSubType())) continue;
            Node node = NodeTransfer.node((Transferable)tr, (int)3);
            if (node instanceof OneConfigurationNode && (project = (J2MEProject)node.getLookup().lookup(J2MEProject.class)) != null) {
                HashSet<Object> set = this.map.get(project);
                if (set == null) {
                    set = new HashSet();
                    this.map.put(project, set);
                }
                set.add(node);
            }
            if (this.map.size() == 0) continue;
            return this.pType;
        }
        return null;
    }

    public PasteType getDropType(Transferable tr, int action, int index) {
        DataFlavor[] fr = tr.getTransferDataFlavors();
        PasteType type = this.getPasteType(tr, fr);
        return type;
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        PasteType pt = this.getDropType(t, 0, 0);
        if (pt != null) {
            s.add(pt);
        }
    }

    private static final class ConfigurationChildren
    extends ChildFactory<String> {
        private final J2MEProject project;
        private final ProjectConfiguration config;

        ConfigurationChildren(J2MEProject project, ProjectConfiguration config) {
            this.config = config;
            this.project = project;
        }

        protected boolean createKeys(List<String> toPopulate) {
            toPopulate.add(OneConfigurationNode.KEY_RESOURCES);
            return true;
        }

        protected Node createNodeForKey(String key) {
            assert (OneConfigurationNode.KEY_RESOURCES.equals(key));
            return new ResourcesNode(this.project, this.config);
        }
    }
}

