/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.ui.customizer.VisualClassPathItem;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.mobility.project.support.DefaultPropertyParsers;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;

public class J2MEProjectClassPathExtender
implements ProjectClassPathExtender {
    private static final Map<String, String> CONDITIONS = new HashMap<String, String>();
    protected Project project;
    protected AntProjectHelper helper;
    protected ReferenceHelper refHelper;
    protected ProjectConfigurationsHelper confHelper;

    public J2MEProjectClassPathExtender(Project project, AntProjectHelper helper, ReferenceHelper refHelper, ProjectConfigurationsHelper confHelper) {
        this.project = project;
        this.helper = helper;
        this.refHelper = refHelper;
        this.confHelper = confHelper;
    }

    public boolean addLibrary(Library library) throws IOException {
        if (library == null) {
            return false;
        }
        boolean modified = false;
        if ("swing-layout".equals(library.getName())) {
            modified = this.addLibrary(LibraryManager.getDefault().getLibrary("cdc-agui-swing-layout")) | this.addLibrary(LibraryManager.getDefault().getLibrary("cdc-pp-awt-layout"));
        }
        return this.addCPItemToAllCfg(VisualClassPathItem.create(library), CONDITIONS.get(library.getName())) | modified;
    }

    public boolean addArchiveFile(FileObject archiveFile) throws IOException {
        assert (archiveFile != null) : "Parameter cannot be null";
        File f = FileUtil.toFile((FileObject)archiveFile);
        if (f == null) {
            throw new IllegalArgumentException("The file must exist on disk");
        }
        return this.addCPItemToAllCfg(VisualClassPathItem.create(f), null);
    }

    public boolean addAntArtifact(AntArtifact artifact, URI artifactElement) throws IOException {
        assert (artifact != null) : "Parameter cannot be null";
        return this.addCPItemToAllCfg(VisualClassPathItem.create(artifact, artifactElement), null);
    }

    private boolean addCPItemToAllCfg(final VisualClassPathItem item, final String condition) throws IOException {
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws Exception {
                    List resources;
                    EditableProperties props = J2MEProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                    boolean modified = false;
                    boolean defaultFits = J2MEProjectClassPathExtender.this.checkCondition(props, null, condition);
                    String defaultRaw = props.getProperty("libs.classpath");
                    if (defaultFits && !(resources = (List)DefaultPropertyParsers.PATH_PARSER.decode(defaultRaw, J2MEProjectClassPathExtender.this.helper, J2MEProjectClassPathExtender.this.refHelper)).contains(item)) {
                        resources.add(item);
                        String itemRefs = DefaultPropertyParsers.PATH_PARSER.encode(resources, J2MEProjectClassPathExtender.this.helper, J2MEProjectClassPathExtender.this.refHelper);
                        props.setProperty("libs.classpath", itemRefs);
                        modified = true;
                    }
                    for (ProjectConfiguration cfg : J2MEProjectClassPathExtender.this.confHelper.getConfigurations().toArray(new ProjectConfiguration[0])) {
                        List resources2;
                        if (J2MEProjectClassPathExtender.this.confHelper.getDefaultConfiguration().equals(cfg)) continue;
                        String propName = VisualPropertySupport.prefixPropertyName(cfg.getDisplayName(), "libs.classpath");
                        boolean fits = J2MEProjectClassPathExtender.this.checkCondition(props, cfg, condition);
                        String raw = props.getProperty(propName);
                        if (raw == null && fits != defaultFits) {
                            raw = defaultRaw;
                            props.put(propName, raw);
                        }
                        if (!fits || raw == null || (resources2 = (List)DefaultPropertyParsers.PATH_PARSER.decode(raw, J2MEProjectClassPathExtender.this.helper, J2MEProjectClassPathExtender.this.refHelper)).contains(item)) continue;
                        resources2.add(item);
                        String itemRefs = DefaultPropertyParsers.PATH_PARSER.encode(resources2, J2MEProjectClassPathExtender.this.helper, J2MEProjectClassPathExtender.this.refHelper);
                        props.setProperty(propName, itemRefs);
                        modified = true;
                    }
                    if (modified) {
                        J2MEProjectClassPathExtender.this.helper.putProperties("nbproject/project.properties", props);
                        ProjectManager.getDefault().saveProject(J2MEProjectClassPathExtender.this.project);
                    }
                    return modified;
                }
            });
        }
        catch (Exception e) {
            IOException t = new IOException();
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)t, (Throwable)e);
        }
    }

    protected boolean checkCondition(EditableProperties props, ProjectConfiguration cfg, String condition) {
        if (condition == null) {
            return true;
        }
        String platformName = props.getProperty(cfg == null ? "platform.active" : VisualPropertySupport.prefixPropertyName(cfg.getDisplayName(), "platform.active"));
        if (platformName == null) {
            platformName = props.getProperty("platform.active");
        }
        if (platformName == null) {
            return false;
        }
        for (JavaPlatform platform : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            String antName = (String)platform.getProperties().get("platform.ant.name");
            if (antName == null || !antName.equals(platformName)) continue;
            ClassPath cp = platform.getBootstrapLibraries();
            boolean ret = true;
            for (String s : condition.split(",")) {
                if (s.startsWith("-")) {
                    ret &= platform.getBootstrapLibraries().findResource(s.substring(1)) == null;
                    continue;
                }
                ret &= platform.getBootstrapLibraries().findResource(s) != null;
            }
            return ret;
        }
        return true;
    }

    static {
        CONDITIONS.put("swing-layout", "javax/swing/AbstractCellEditor.class");
        CONDITIONS.put("cdc-agui-swing-layout", "javax/swing/JComponent.class,-javax/swing/AbstractCellEditor.class");
        CONDITIONS.put("cdc-pp-awt-layout", "java/awt/Component.class,-javax/swing/JComponent.class");
        CONDITIONS.put("NetBeans MIDP Components", "javax/microedition/lcdui/Screen.class");
        CONDITIONS.put("nb_svg_midp_components", "javax/microedition/m2g/SVGImage.class");
        CONDITIONS.put("J2MEUnit", "javax/microedition/midlet/MIDlet.class");
        CONDITIONS.put("JMUnit4CLDC10", "javax/microedition/midlet/MIDlet.class");
        CONDITIONS.put("JMUnit4CLDC11", "javax/microedition/midlet/MIDlet.class,java/lang/Double.class");
    }
}

