/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.dd.impl;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import org.netbeans.modules.j2ee.sun.dd.impl.transform.ModAttribute;
import org.netbeans.modules.j2ee.sun.dd.impl.transform.ModElement;
import org.netbeans.modules.j2ee.sun.dd.impl.transform.SubElement;
import org.netbeans.modules.j2ee.sun.dd.impl.transform.Transform;
import org.netbeans.modules.j2ee.sun.dd.impl.transform.Xmltype;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DDTreeWalker {
    Document document;
    String downgradeVersion;
    String currentVersion;
    Transform transInfo;
    String DATAFILE = "org/netbeans/modules/j2ee/sun/dd/impl/transform/transform.xml";

    public DDTreeWalker(Document document, String version, String currVersion) {
        this.document = document;
        this.downgradeVersion = version;
        this.currentVersion = currVersion;
    }

    public void downgradeSunWebAppDocument() {
        this.transInfo = this.getTransformInfo();
        if (this.transInfo != null) {
            Vector<ModElement> modElementsList = new Vector<ModElement>();
            Xmltype type = null;
            if (this.currentVersion.equals("2.50")) {
                type = this.getXmlType(this.transInfo, "sunWebApp41");
                modElementsList = this.updateModElementsList(modElementsList, type);
            }
            if (this.downgradeVersion.equals("2.40") || this.downgradeVersion.equals("2.30")) {
                type = this.getXmlType(this.transInfo, "sunWebApp40");
                modElementsList = this.updateModElementsList(modElementsList, type);
            }
            if (this.downgradeVersion.equals("2.30")) {
                type = this.getXmlType(this.transInfo, "sunWebApp30");
                modElementsList = this.updateModElementsList(modElementsList, type);
            }
            this.processDocument(modElementsList);
        }
    }

    public void downgradeSunEjbJarDocument() {
        this.transInfo = this.getTransformInfo();
        if (this.transInfo != null) {
            Vector<ModElement> modElementsList = new Vector<ModElement>();
            Xmltype type = null;
            if (this.currentVersion.equals("3.01")) {
                type = this.getXmlType(this.transInfo, "sunEjb300");
                modElementsList = this.updateModElementsList(modElementsList, type);
            }
            if (this.downgradeVersion.equals("3.00") || this.downgradeVersion.equals("2.10") || this.downgradeVersion.equals("2.00")) {
                type = this.getXmlType(this.transInfo, "sunEjb300");
                modElementsList = this.updateModElementsList(modElementsList, type);
            }
            if (this.downgradeVersion.equals("2.10") || this.downgradeVersion.equals("2.00")) {
                type = this.getXmlType(this.transInfo, "sunEjb210");
                modElementsList = this.updateModElementsList(modElementsList, type);
            }
            if (this.downgradeVersion.equals("2.00")) {
                type = this.getXmlType(this.transInfo, "sunEjb200");
                modElementsList = this.updateModElementsList(modElementsList, type);
            }
            this.processDocument(modElementsList);
        }
    }

    public void downgradeSunClientDocument() {
        this.transInfo = this.getTransformInfo();
        if (this.transInfo != null) {
            Vector<ModElement> modElementsList = new Vector<ModElement>();
            Xmltype type = null;
            if (this.currentVersion.equals("5.00")) {
                type = this.getXmlType(this.transInfo, "sunClient41");
                modElementsList = this.updateModElementsList(modElementsList, type);
            }
            if (this.downgradeVersion.equals("1.40") || this.downgradeVersion.equals("1.30")) {
                type = this.getXmlType(this.transInfo, "sunClient40");
                modElementsList = this.updateModElementsList(modElementsList, type);
            }
            if (this.downgradeVersion.equals("1.30")) {
                type = this.getXmlType(this.transInfo, "sunClient30");
                modElementsList = this.updateModElementsList(modElementsList, type);
            }
            this.processDocument(modElementsList);
        }
    }

    public void downgradeSunCmpMappingsDocument() {
        throw new UnsupportedOperationException();
    }

    private Vector<ModElement> updateModElementsList(Vector<ModElement> modElementsList, Xmltype type) {
        if (type != null) {
            ModElement[] elementsList = type.getModElement();
            modElementsList.addAll(new HashSet<ModElement>(Arrays.asList(elementsList)));
        }
        return modElementsList;
    }

    private void processDocument(Vector<ModElement> elements) {
        Element element = this.document.getDocumentElement();
        this.visitElement(element, elements);
    }

    private void visitElement(Element element, Vector<ModElement> elements) {
        this.walkElement(element, elements);
        NodeList nodes = element.getChildNodes();
        block3: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    Element nodeElement = (Element)node;
                    String nodeElementName = nodeElement.getTagName();
                    this.walkElement(nodeElement, elements);
                    this.visitElement(nodeElement, elements);
                    continue block3;
                }
            }
        }
    }

    private void walkElement(Element element, Vector<ModElement> elements) {
        ModElement[] elementsList = elements.toArray(new ModElement[elements.size()]);
        for (int i = 0; i < elementsList.length; ++i) {
            ModElement eachElement = elementsList[i];
            if (element == null || !element.getTagName().equals(eachElement.getName())) continue;
            ModAttribute[] attrList = eachElement.getModAttribute();
            for (int j = 0; j < attrList.length; ++j) {
                this.removeAttribute(element, attrList[j].getName());
            }
            SubElement[] subelements = eachElement.getSubElement();
            for (int l = 0; l < subelements.length; ++l) {
                String removeElement = subelements[l].getName();
                this.removeElement(element, removeElement);
            }
        }
    }

    private void removeAttribute(Element element, String attrName) {
        NamedNodeMap attrs = element.getAttributes();
        for (int in = 0; in < attrs.getLength(); ++in) {
            Attr attr = (Attr)attrs.item(in);
            if (!attr.getName().equals(attrName)) continue;
            element.removeAttributeNode(attr);
        }
    }

    private void removeElement(Element element, String elementName) {
        NodeList nodes = element.getChildNodes();
        block3: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    Element nodeElement = (Element)node;
                    if (!nodeElement.getTagName().equals(elementName)) continue block3;
                    element.removeChild(node);
                }
            }
        }
    }

    public Xmltype getXmlType(Transform transformInfo, String moduleVersion) {
        Xmltype[] types = transformInfo.getXmltype();
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].getName().equals(moduleVersion)) continue;
            return types[i];
        }
        return null;
    }

    public Transform getTransformInfo() {
        try {
            InputStream in = Transform.class.getClassLoader().getResourceAsStream(this.DATAFILE);
            this.transInfo = Transform.createGraph(in);
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.transInfo;
    }
}

