/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.util;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyProc;
import org.jruby.nb.exceptions.MainExitException;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.BlockCallback;
import org.jruby.nb.runtime.CallBlock;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.SignalFacade;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class SunSignalFacade
implements SignalFacade {
    @Override
    public IRubyObject trap(final IRubyObject recv, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        SignalHandler oldHandler;
        final JRubySignalHandler handler = new JRubySignalHandler(recv.getRuntime(), arg1, arg2, arg3.toString());
        try {
            oldHandler = Signal.handle(new Signal(handler.signal), handler);
        }
        catch (Exception e) {
            throw recv.getRuntime().newArgumentError(e.getMessage());
        }
        if (oldHandler instanceof JRubySignalHandler) {
            return ((JRubySignalHandler)oldHandler).block;
        }
        return RubyProc.newProc(recv.getRuntime(), CallBlock.newCallClosure(recv, (RubyModule)recv, Arity.noArguments(), new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject[] args, Block block) {
                oldHandler.handle(new Signal(handler.signal));
                return recv.getRuntime().getNil();
            }
        }, recv.getRuntime().getCurrentContext()), Block.Type.NORMAL);
    }

    private static final class JRubySignalHandler
    implements SignalHandler {
        private final Ruby runtime;
        private final IRubyObject block;
        private final IRubyObject signal_object;
        private final String signal;

        public JRubySignalHandler(Ruby runtime, IRubyObject block, IRubyObject signal_object, String signal) {
            this.runtime = runtime;
            this.block = block;
            this.signal_object = signal_object;
            this.signal = signal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(Signal signal) {
            ThreadContext context = this.runtime.getCurrentContext();
            try {
                this.block.callMethod(context, "call");
            }
            catch (RaiseException e) {
                try {
                    this.runtime.getThread().callMethod(context, "main").callMethod(context, "raise", e.getException());
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            catch (MainExitException mee) {
                this.runtime.getThreadService().getMainThread().kill();
            }
            finally {
                Signal.handle(new Signal(this.signal), this);
            }
        }
    }
}

