/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime.callback;

import org.jruby.nb.Ruby;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.exceptions.MainExitException;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.exceptions.ThreadKill;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.callback.Callback;

public abstract class InvocationCallback
implements Callback {
    public static final Class[] EMPTY_ARGS = new Class[0];
    public static final Class[] OPTIONAL_ARGS = new Class[]{IRubyObject[].class};
    protected int arityValue;
    protected Arity arity;
    private Class[] argumentTypes = EMPTY_ARGS;
    private String javaName;
    private boolean isSingleton;

    @Override
    public IRubyObject execute(IRubyObject recv, IRubyObject[] oargs, Block block) {
        if (this.arityValue >= 0) {
            if (oargs.length != this.arityValue) {
                throw recv.getRuntime().newArgumentError("wrong number of arguments(" + oargs.length + " for " + this.arityValue + ")");
            }
        } else if (oargs.length < -(1 + this.arityValue)) {
            throw recv.getRuntime().newArgumentError("wrong number of arguments(" + oargs.length + " for " + -(1 + this.arityValue) + ")");
        }
        try {
            return this.call(recv, oargs, block);
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (JumpException e) {
            throw e;
        }
        catch (ThreadKill e) {
            throw e;
        }
        catch (MainExitException e) {
            throw e;
        }
        catch (Exception e) {
            Ruby runtime = recv.getRuntime();
            runtime.getJavaSupport().handleNativeException(e);
            return runtime.getNil();
        }
    }

    public abstract IRubyObject call(Object var1, Object[] var2, Block var3);

    public void setArity(Arity arity) {
        this.arity = arity;
        this.arityValue = arity.getValue();
    }

    @Override
    public Arity getArity() {
        return this.arity;
    }

    public void setArgumentTypes(Class[] argumentTypes) {
        this.argumentTypes = argumentTypes;
    }

    public Class[] getArgumentTypes() {
        return this.argumentTypes;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setSingleton(boolean isSingleton) {
        this.isSingleton = isSingleton;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }
}

