/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.libraries;

import java.io.IOException;
import org.jruby.nb.CompatVersion;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyObject;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.load.Library;

public class FiberLibrary
implements Library {
    @Override
    public void load(Ruby runtime, boolean wrap) throws IOException {
        Fiber.setup(runtime);
    }

    @JRubyClass(name={"Fiber"})
    public static class Fiber
    extends RubyObject {
        private final Object yieldLock = new Object();
        private Block block;
        private IRubyObject result;
        private Thread thread;
        private boolean alive = false;

        @JRubyMethod(name={"new"}, rest=true, meta=true, frame=true, compat=CompatVersion.RUBY1_9)
        public static Fiber newInstance(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
            Fiber result = new Fiber(context.getRuntime(), (RubyClass)recv);
            result.initialize(context, args, block);
            return result;
        }

        public IRubyObject initialize(ThreadContext context, IRubyObject[] args, Block block) {
            this.block = block;
            final Ruby runtime = context.getRuntime();
            this.result = runtime.getNil();
            this.thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = Fiber.this.yieldLock;
                    synchronized (object) {
                        Fiber.this.alive = true;
                        ThreadContext context = runtime.getCurrentContext();
                        context.setFiber(Fiber.this);
                        try {
                            Fiber.this.result = Fiber.this.block.yield(runtime.getCurrentContext(), Fiber.this.result, null, null, true);
                        }
                        finally {
                            Fiber.this.yieldLock.notify();
                        }
                    }
                }
            };
            this.thread.setDaemon(true);
            return this;
        }

        public Fiber(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public static void setup(Ruby runtime) {
            RubyClass cFiber = runtime.defineClass("Fiber", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
            cFiber.defineAnnotatedMethods(Fiber.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(rest=true, compat=CompatVersion.RUBY1_9)
        public IRubyObject resume(ThreadContext context, IRubyObject[] args) throws InterruptedException {
            Object object = this.yieldLock;
            synchronized (object) {
                this.result = context.getRuntime().newArrayNoCopyLight(args);
                if (!this.alive) {
                    this.thread.start();
                    this.yieldLock.wait();
                } else {
                    this.yieldLock.notify();
                    this.yieldLock.wait();
                }
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(rest=true, compat=CompatVersion.RUBY1_9)
        public IRubyObject transfer(IRubyObject[] args) throws InterruptedException {
            Object object = this.yieldLock;
            synchronized (object) {
                this.yieldLock.notify();
                this.yieldLock.wait();
            }
            return this.result;
        }

        @JRubyMethod(name={"alive?"}, compat=CompatVersion.RUBY1_9)
        public IRubyObject alive_p(ThreadContext context) {
            return context.getRuntime().newBoolean(this.alive);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(compat=CompatVersion.RUBY1_9, meta=true)
        public static IRubyObject yield(ThreadContext context, IRubyObject recv, IRubyObject value) throws InterruptedException {
            Fiber fiber = context.getFiber();
            fiber.result = value;
            Object object = fiber.yieldLock;
            synchronized (object) {
                fiber.yieldLock.notify();
                fiber.yieldLock.wait();
            }
            return context.getRuntime().getNil();
        }

        @JRubyMethod(compat=CompatVersion.RUBY1_9, meta=true)
        public static IRubyObject current(ThreadContext context, IRubyObject recv) {
            return context.getRuntime().getCurrentContext().getFiber();
        }
    }
}

