/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.lexer.yacc;

import java.io.IOException;
import org.jruby.nb.ast.StrNode;
import org.jruby.nb.lexer.yacc.LexerSource;
import org.jruby.nb.lexer.yacc.RubyYaccLexer;
import org.jruby.nb.lexer.yacc.StrTerm;
import org.jruby.nb.lexer.yacc.StringTerm;
import org.jruby.nb.lexer.yacc.SyntaxException;
import org.jruby.nb.lexer.yacc.Token;
import org.jruby.util.ByteList;

public class HeredocTerm
extends StrTerm {
    private final ByteList marker;
    private final int flags;
    private final ByteList lastLine;

    public HeredocTerm(ByteList marker, int func, ByteList lastLine) {
        this.marker = marker;
        this.flags = func;
        this.lastLine = lastLine;
    }

    @Override
    public int parseString(RubyYaccLexer lexer, LexerSource src) throws IOException {
        boolean done;
        boolean indent;
        boolean bl = indent = (this.flags & 0x20) != 0;
        if (src.peek(-1)) {
            this.syntaxError(src);
        }
        if (lexer.getPreserveSpaces() && (done = src.matchMarker(this.marker, indent, true))) {
            lexer.yaccValue = new StrNode(lexer.getPosition(), new ByteList());
            lexer.setStrTerm(new StringTerm(-1, 0, 0));
            src.setIsANewLine(true);
            return 374;
        }
        if (src.lastWasBeginOfLine() && src.matchMarker(this.marker, indent, true)) {
            if (this.lastLine != null) {
                src.unreadMany((CharSequence)this.lastLine);
            }
            lexer.yaccValue = new Token(this.marker, lexer.getPosition());
            return 374;
        }
        ByteList str = new ByteList();
        if ((this.flags & 2) == 0) {
            do {
                str.append(src.readLineBytes());
                str.append(10);
                if (!src.peek(-1)) continue;
                this.syntaxError(src);
            } while (!src.matchMarker(this.marker, indent, true));
        } else {
            int c = src.read();
            if (c == 35) {
                c = src.read();
                switch (c) {
                    case 36: 
                    case 64: {
                        if (this.processingEmbedded == 1) {
                            this.processingEmbedded = 3;
                        }
                        src.unread(c);
                        lexer.setValue(new Token("#" + c, lexer.getPosition()));
                        return 373;
                    }
                    case 123: {
                        if (this.processingEmbedded == 1) {
                            this.processingEmbedded = 2;
                        }
                        lexer.setValue(new Token("#" + c, lexer.getPosition()));
                        return 372;
                    }
                }
                str.append(35);
            }
            src.unread(c);
            do {
                StringTerm stringTerm = new StringTerm(this.flags, 0, 10);
                stringTerm.processingEmbedded = this.processingEmbedded;
                c = stringTerm.parseStringIntoBuffer(lexer, src, str);
                if (c == -1) {
                    this.syntaxError(src);
                }
                if (this.processingEmbedded == 3 || this.processingEmbedded == 2) {
                    this.processingEmbedded = 1;
                }
                if (c != 10) {
                    lexer.yaccValue = new StrNode(lexer.getPosition(), str);
                    return 312;
                }
                str.append(src.read());
                if (!src.peek(-1)) continue;
                this.syntaxError(src);
            } while (!src.matchMarker(this.marker, indent, true));
        }
        if (this.processingEmbedded == 3) {
            this.processingEmbedded = 1;
        }
        if (this.lastLine != null) {
            src.unreadMany((CharSequence)this.lastLine);
        }
        if (this.lastLine == null) {
            src.unreadMany(this.marker + "\n");
        } else {
            lexer.setStrTerm(new StringTerm(-1, 0, 0));
        }
        lexer.yaccValue = new StrNode(lexer.getPosition(), str);
        return 312;
    }

    private void syntaxError(LexerSource src) {
        throw new SyntaxException(SyntaxException.PID.STRING_MARKER_MISSING, src.getPosition(), "can't find string \"" + this.marker + "\" anywhere before EOF", this.marker);
    }

    @Override
    public boolean isSubstituting() {
        return (this.flags & 2) != 0;
    }

    @Override
    public Object getMutableState() {
        return new MutableTermState(this.processingEmbedded);
    }

    @Override
    public void setMutableState(Object o) {
        MutableTermState state = (MutableTermState)o;
        if (state != null) {
            this.processingEmbedded = state.processingEmbedded;
        }
    }

    @Override
    public void splitEmbeddedTokens() {
        if (this.processingEmbedded == 0) {
            this.processingEmbedded = 1;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeredocTerm other = (HeredocTerm)obj;
        if (!(this.marker == other.marker || this.marker != null && this.marker.equals((Object)other.marker))) {
            return false;
        }
        if (this.flags != other.flags) {
            return false;
        }
        return this.lastLine == other.lastLine || this.lastLine != null && this.lastLine.equals((Object)other.lastLine);
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this.marker != null ? this.marker.hashCode() : 0);
        hash = 83 * hash + this.flags;
        hash = 83 * hash + (this.lastLine != null ? this.lastLine.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "HeredocTerm[" + this.flags + "," + this.marker + "," + this.lastLine + "," + this.processingEmbedded + "]";
    }

    private class MutableTermState {
        private int processingEmbedded;

        private MutableTermState(int embeddedCode) {
            this.processingEmbedded = embeddedCode;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MutableTermState other = (MutableTermState)obj;
            return this.processingEmbedded == other.processingEmbedded;
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + this.processingEmbedded;
            return hash;
        }

        public String toString() {
            return "HeredocTermState[" + this.processingEmbedded + "]";
        }
    }
}

