/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.java.addons;

import java.io.IOException;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyIO;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.javasupport.JavaUtil;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.io.BadDescriptorException;
import org.jruby.nb.util.io.InvalidValueException;
import org.jruby.nb.util.io.PipeException;

public class IOJavaAddons {
    @JRubyMethod
    public static IRubyObject to_inputstream(ThreadContext context, IRubyObject self) {
        RubyIO io = (RubyIO)self;
        Ruby runtime = context.getRuntime();
        try {
            io.getOpenFile().checkReadable(context.getRuntime());
        }
        catch (PipeException pe) {
            throw runtime.newErrnoEPIPEError();
        }
        catch (IOException ex) {
            throw runtime.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime.newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw runtime.newErrnoEINVALError();
        }
        return JavaUtil.convertJavaToUsableRubyObject(context.getRuntime(), io.getInStream());
    }

    @JRubyMethod
    public static IRubyObject to_outputstream(ThreadContext context, IRubyObject self) {
        RubyIO io = (RubyIO)self;
        Ruby runtime = context.getRuntime();
        try {
            io.getOpenFile().checkWritable(context.getRuntime());
        }
        catch (PipeException pe) {
            throw runtime.newErrnoEPIPEError();
        }
        catch (IOException ex) {
            throw runtime.newIOErrorFromException(ex);
        }
        catch (BadDescriptorException ex) {
            throw runtime.newErrnoEBADFError();
        }
        catch (InvalidValueException e) {
            throw runtime.newErrnoEINVALError();
        }
        return JavaUtil.convertJavaToUsableRubyObject(context.getRuntime(), io.getOutStream());
    }

    @JRubyMethod
    public static IRubyObject to_channel(ThreadContext context, IRubyObject self) {
        RubyIO io = (RubyIO)self;
        return JavaUtil.convertJavaToUsableRubyObject(context.getRuntime(), io.getChannel());
    }
}

