/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.ffi.jna;

import com.sun.jna.Function;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.ext.ffi.Invoker;
import org.jruby.nb.ext.ffi.jna.DynamicMethodOneArg;
import org.jruby.nb.ext.ffi.jna.DynamicMethodThreeArg;
import org.jruby.nb.ext.ffi.jna.DynamicMethodTwoArg;
import org.jruby.nb.ext.ffi.jna.DynamicMethodZeroArg;
import org.jruby.nb.ext.ffi.jna.FunctionInvoker;
import org.jruby.nb.ext.ffi.jna.Invocation;
import org.jruby.nb.ext.ffi.jna.Marshaller;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.builtin.IRubyObject;

final class JNAInvoker
extends Invoker {
    private final Function function;
    private final FunctionInvoker functionInvoker;
    private final Marshaller[] marshallers;

    public JNAInvoker(Ruby runtime, Function function, FunctionInvoker functionInvoker, Marshaller[] marshallers) {
        super(runtime, marshallers.length);
        this.function = function;
        this.functionInvoker = functionInvoker;
        this.marshallers = marshallers;
    }

    @Override
    public IRubyObject invoke(Ruby runtime, IRubyObject[] rubyArgs) {
        Object[] args = new Object[rubyArgs.length];
        Invocation invocation = new Invocation();
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.marshallers[i].marshal(invocation, rubyArgs[i]);
        }
        IRubyObject retVal = this.functionInvoker.invoke(runtime, this.function, args);
        invocation.finish();
        return retVal;
    }

    @Override
    public DynamicMethod createDynamicMethod(RubyModule module) {
        if (Arity.NO_ARGUMENTS.equals(this.arity)) {
            return new DynamicMethodZeroArg(module, this.function, this.functionInvoker);
        }
        if (Arity.ONE_ARGUMENT.equals(this.arity)) {
            return new DynamicMethodOneArg(module, this.function, this.functionInvoker, this.marshallers);
        }
        if (Arity.TWO_ARGUMENTS.equals(this.arity)) {
            return new DynamicMethodTwoArg(module, this.function, this.functionInvoker, this.marshallers);
        }
        if (Arity.THREE_ARGUMENTS.equals(this.arity)) {
            return new DynamicMethodThreeArg(module, this.function, this.functionInvoker, this.marshallers);
        }
        return super.createDynamicMethod(module);
    }
}

