/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.ffi;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyObject;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.ext.ffi.FFIProvider;
import org.jruby.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"JRuby::FFI::Invoker"}, parent="Object")
public abstract class Invoker
extends RubyObject {
    static final String CLASS_NAME = "Invoker";
    protected final Arity arity;

    public static RubyClass createInvokerClass(Ruby runtime) {
        RubyModule module = FFIProvider.getModule(runtime);
        RubyClass result = module.defineClassUnder(CLASS_NAME, runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(Invoker.class);
        result.defineAnnotatedConstants(Invoker.class);
        return result;
    }

    protected Invoker(Ruby runtime, int arity) {
        super(runtime, FFIProvider.getModule(runtime).fastGetClass(CLASS_NAME));
        this.arity = Arity.fixed(arity);
    }

    @JRubyMethod(name={"attach"})
    public IRubyObject attach(ThreadContext context, IRubyObject module, IRubyObject methodName) {
        DynamicMethod m = this.createDynamicMethod((RubyModule)module);
        ((RubyModule)module).addMethod(methodName.asJavaString(), m);
        return context.getRuntime().getNil();
    }

    protected DynamicMethod createDynamicMethod(RubyModule module) {
        return new DynamicMethod(module, Visibility.PUBLIC, CallConfiguration.NO_FRAME_NO_SCOPE){

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
                Invoker.this.arity.checkArity(context.getRuntime(), args);
                return Invoker.this.invoke(context.getRuntime(), args);
            }

            @Override
            public DynamicMethod dup() {
                return this;
            }

            @Override
            public Arity getArity() {
                return Invoker.this.getArity();
            }

            @Override
            public boolean isNative() {
                return true;
            }
        };
    }

    @JRubyMethod(name={"invoke", "call"}, rest=true)
    public IRubyObject invoke(ThreadContext context, IRubyObject[] rubyArgs) {
        return this.invoke(context.getRuntime(), ((RubyArray)rubyArgs[0]).toJavaArrayMaybeUnsafe());
    }

    public abstract IRubyObject invoke(Ruby var1, IRubyObject[] var2);

    public final Arity getArity() {
        return this.arity;
    }
}

