/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.ffi;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyObject;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.ext.ffi.Invoker;
import org.jruby.nb.ext.ffi.NativeType;
import org.jruby.nb.ext.ffi.Util;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"JRuby::FFI::Provider"}, parent="Object")
public abstract class FFIProvider
extends RubyObject {
    public static final String MODULE_NAME = "JRuby::FFI";
    public static final String CLASS_NAME = "Provider";

    public static RubyClass createProviderClass(Ruby runtime) {
        RubyModule module = FFIProvider.getModule(runtime);
        RubyClass result = module.defineClassUnder(CLASS_NAME, runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.defineAnnotatedMethods(FFIProvider.class);
        result.defineAnnotatedConstants(FFIProvider.class);
        return result;
    }

    protected FFIProvider(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    protected FFIProvider(Ruby runtime) {
        super(runtime, FFIProvider.getModule(runtime).fastGetClass(CLASS_NAME));
    }

    public static RubyModule getModule(Ruby runtime) {
        return (RubyModule)runtime.fastGetModule("JRuby").fastGetConstantAt("FFI");
    }

    @JRubyMethod(name={"create_invoker", "createInvoker"}, required=5)
    public IRubyObject createInvoker(ThreadContext context, IRubyObject[] args) {
        RubyArray paramTypes = (RubyArray)args[3];
        NativeType[] nativeParamTypes = new NativeType[paramTypes.size()];
        for (int i = 0; i < paramTypes.size(); ++i) {
            nativeParamTypes[i] = NativeType.valueOf(Util.int32Value(paramTypes.entry(i)));
        }
        try {
            return this.createInvoker(context.getRuntime(), args[0].toString(), args[1].toString(), NativeType.valueOf(Util.int32Value(args[2])), nativeParamTypes, args[4].toString());
        }
        catch (UnsatisfiedLinkError ex) {
            return context.getRuntime().getNil();
        }
    }

    @JRubyMethod(name={"error", "last_error"})
    public IRubyObject getLastError(ThreadContext context) {
        return context.getRuntime().newFixnum(this.getLastError());
    }

    @JRubyMethod(name={"error=", "last_error="})
    public IRubyObject getLastError(ThreadContext context, IRubyObject error) {
        this.setLastError(Util.int32Value(error));
        return context.getRuntime().getNil();
    }

    public abstract Invoker createInvoker(Ruby var1, String var2, String var3, NativeType var4, NativeType[] var5, String var6);

    public abstract int getLastError();

    public abstract void setLastError(int var1);
}

