/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyHash;
import org.jruby.nb.common.IRubyWarnings;

public class JRubyPOSIXHandler
implements POSIXHandler {
    private final Ruby runtime;
    private final boolean isVerbose;

    public JRubyPOSIXHandler(Ruby runtime) {
        this.runtime = runtime;
        boolean verbose = false;
        try {
            verbose = Boolean.getBoolean("jruby.native.verbose");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.isVerbose = verbose;
    }

    public void error(POSIX.ERRORS error, String extraData) {
        switch (error) {
            case ENOENT: {
                throw this.runtime.newErrnoENOENTError("No such file or directory - " + extraData);
            }
        }
    }

    public void unimplementedError(String method) {
        throw this.runtime.newNotImplementedError(method + " unsupported on this platform");
    }

    public void warn(POSIXHandler.WARNING_ID id, String message, Object ... data) {
        IRubyWarnings.ID ourID = id == POSIXHandler.WARNING_ID.DUMMY_VALUE_USED ? IRubyWarnings.ID.DUMMY_VALUE_USED : IRubyWarnings.ID.MISCELLANEOUS;
        this.runtime.getWarnings().warn(ourID, message, data);
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public File getCurrentWorkingDirectory() {
        return new File(this.runtime.getCurrentDirectory());
    }

    public String[] getEnv() {
        RubyHash hash = (RubyHash)this.runtime.getObject().fastGetConstant("ENV");
        int i = 0;
        String[] env = new String[hash.size()];
        for (Map.Entry entry : hash.directEntrySet()) {
            env[i] = entry.getKey().toString() + "=" + entry.getValue().toString();
            ++i;
        }
        return env;
    }

    public PrintStream getErrorStream() {
        return this.runtime.getErrorStream();
    }

    public InputStream getInputStream() {
        return this.runtime.getInputStream();
    }

    public int getPID() {
        return this.runtime.hashCode();
    }

    public PrintStream getOutputStream() {
        return this.runtime.getOutputStream();
    }
}

