/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class ReturnNode
extends Node {
    private final Node valueNode;
    private Object target;

    public ReturnNode(ISourcePosition position, Node valueNode) {
        super(position, NodeType.RETURNNODE);
        assert (valueNode != null) : "valueNode is not null";
        this.valueNode = valueNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitReturnNode(this);
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    @Override
    public List<Node> childNodes() {
        return ReturnNode.createList(this.valueNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        throw context.returnJump(this.valueNode.interpret(runtime, context, self, aBlock));
    }
}

