/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.IArityNode;
import org.jruby.nb.ast.types.INameNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class InstVarNode
extends Node
implements IArityNode,
INameNode {
    private String name;

    public InstVarNode(ISourcePosition position, String name) {
        super(position, NodeType.INSTVARNODE);
        this.name = name;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitInstVarNode(this);
    }

    @Override
    public Arity getArity() {
        return Arity.noArguments();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject variable = self.getInstanceVariables().fastGetInstanceVariable(this.name);
        if (variable != null) {
            return variable;
        }
        runtime.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, this.getPosition(), "instance variable " + this.name + " not initialized", this.name);
        return runtime.getNil();
    }

    @Override
    public String definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return self.getInstanceVariables().fastHasInstanceVariable(this.name) ? "instance-variable" : null;
    }

    @Override
    public String toString() {
        return "InstVarnode: " + this.name;
    }
}

