/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class DefinedNode
extends Node {
    private final Node expressionNode;

    public DefinedNode(ISourcePosition position, Node expressionNode) {
        super(position, NodeType.DEFINEDNODE);
        assert (expressionNode != null) : "expressionNode is not null";
        this.expressionNode = expressionNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitDefinedNode(this);
    }

    public Node getExpressionNode() {
        return this.expressionNode;
    }

    @Override
    public List<Node> childNodes() {
        return DefinedNode.createList(this.expressionNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        try {
            context.setWithinDefined(true);
            String definition = this.expressionNode.definition(runtime, context, self, aBlock);
            IRubyObject iRubyObject = definition != null ? runtime.newString(definition) : runtime.getNil();
            return iRubyObject;
        }
        finally {
            context.setWithinDefined(false);
        }
    }
}

