/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import org.jruby.nb.Ruby;
import org.jruby.nb.ast.ArrayNode;
import org.jruby.nb.ast.AttrAssignNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class AttrAssignThreeArgNode
extends AttrAssignNode {
    private Node arg1;
    private Node arg2;
    private Node arg3;

    public AttrAssignThreeArgNode(ISourcePosition position, Node receiverNode, String name, ArrayNode argsNode) {
        super(position, receiverNode, name, argsNode);
        assert (argsNode.size() == 3) : "argsNode.size() is 3";
        this.arg1 = argsNode.get(0);
        this.arg2 = argsNode.get(1);
        this.arg3 = argsNode.get(2);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject receiver = this.receiverNode.interpret(runtime, context, self, aBlock);
        IRubyObject param1 = this.arg1.interpret(runtime, context, self, aBlock);
        IRubyObject param2 = this.arg2.interpret(runtime, context, self, aBlock);
        IRubyObject param3 = this.arg3.interpret(runtime, context, self, aBlock);
        assert (receiver.getMetaClass() != null) : receiver.getClass().getName();
        if (receiver == self) {
            this.variableCallAdapter.call(context, receiver, param1, param2, param3);
        } else {
            this.normalCallAdapter.call(context, receiver, param1, param2, param3);
        }
        return param3;
    }

    @Override
    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject value, Block aBlock, boolean checkArity) {
        IRubyObject receiver = this.receiverNode.interpret(runtime, context, self, aBlock);
        IRubyObject param1 = this.arg1.interpret(runtime, context, self, aBlock);
        IRubyObject param2 = this.arg2.interpret(runtime, context, self, aBlock);
        IRubyObject param3 = this.arg2.interpret(runtime, context, self, aBlock);
        assert (receiver.getMetaClass() != null) : receiver.getClass().getName();
        if (receiver == self) {
            this.variableCallAdapter.call(context, receiver, new IRubyObject[]{param1, param2, param3, value});
        } else {
            this.normalCallAdapter.call(context, receiver, new IRubyObject[]{param1, param2, param3, value});
        }
        return runtime.getNil();
    }
}

