/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.math.BigInteger;
import org.jruby.nb.CompatVersion;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyBignum;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyComparable;
import org.jruby.nb.RubyComplex;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyFloat;
import org.jruby.nb.RubyInteger;
import org.jruby.nb.RubyKernel;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyRational;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.Convert;
import org.jruby.nb.util.Numeric;
import org.jruby.util.ByteList;

@JRubyClass(name={"Numeric"}, include={"Comparable"})
public class RubyNumeric
extends RubyObject {
    protected static final ObjectAllocator NUMERIC_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyNumeric(runtime, klass);
        }
    };
    public static double DBL_EPSILON = 2.220446049250313E-16;

    public static RubyClass createNumericClass(Ruby runtime) {
        RubyClass numeric = runtime.defineClass("Numeric", runtime.getObject(), NUMERIC_ALLOCATOR);
        runtime.setNumeric(numeric);
        numeric.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyNumeric;
            }
        };
        numeric.includeModule(runtime.getComparable());
        numeric.defineAnnotatedMethods(RubyNumeric.class);
        return numeric;
    }

    private static IRubyObject convertToNum(double val, Ruby runtime) {
        if (val >= 9.223372036854776E18 || val < -9.223372036854776E18) {
            return RubyBignum.newBignum(runtime, val);
        }
        return RubyFixnum.newFixnum(runtime, (long)val);
    }

    public RubyNumeric(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    public RubyNumeric(Ruby runtime, RubyClass metaClass, boolean useObjectSpace) {
        super(runtime, metaClass, useObjectSpace);
    }

    public double getDoubleValue() {
        return 0.0;
    }

    public long getLongValue() {
        return 0L;
    }

    public static RubyNumeric newNumeric(Ruby runtime) {
        return new RubyNumeric(runtime, runtime.getNumeric());
    }

    public static int num2int(IRubyObject arg) {
        long num = RubyNumeric.num2long(arg);
        RubyNumeric.checkInt(arg, num);
        return (int)num;
    }

    public static void checkInt(IRubyObject arg, long num) {
        String s;
        if (num < Integer.MIN_VALUE) {
            s = "small";
        } else if (num > Integer.MAX_VALUE) {
            s = "big";
        } else {
            return;
        }
        throw arg.getRuntime().newRangeError("integer " + num + " too " + s + " to convert to `int'");
    }

    public static byte num2chr(IRubyObject arg) {
        String value;
        if (arg instanceof RubyString && (value = ((RubyString)arg).toString()) != null && value.length() > 0) {
            return (byte)value.charAt(0);
        }
        return (byte)RubyNumeric.num2int(arg);
    }

    public static long num2long(IRubyObject arg) {
        if (arg instanceof RubyFixnum) {
            return ((RubyFixnum)arg).getLongValue();
        }
        if (arg.isNil()) {
            throw arg.getRuntime().newTypeError("no implicit conversion from nil to integer");
        }
        if (arg instanceof RubyFloat) {
            double aFloat = ((RubyFloat)arg).getDoubleValue();
            if (aFloat <= 9.223372036854776E18 && aFloat >= -9.223372036854776E18) {
                return (long)aFloat;
            }
            throw arg.getRuntime().newRangeError("float " + aFloat + " out of range of integer");
        }
        if (arg instanceof RubyBignum) {
            return RubyBignum.big2long((RubyBignum)arg);
        }
        return arg.convertToInteger().getLongValue();
    }

    public static IRubyObject dbl2num(Ruby runtime, double val) {
        if (Double.isInfinite(val)) {
            throw runtime.newFloatDomainError(val < 0.0 ? "-Infinity" : "Infinity");
        }
        if (Double.isNaN(val)) {
            throw runtime.newFloatDomainError("NaN");
        }
        return RubyNumeric.convertToNum(val, runtime);
    }

    public static double num2dbl(IRubyObject arg) {
        if (arg instanceof RubyFloat) {
            return ((RubyFloat)arg).getDoubleValue();
        }
        if (arg instanceof RubyString) {
            throw arg.getRuntime().newTypeError("no implicit conversion to float from string");
        }
        if (arg == arg.getRuntime().getNil()) {
            throw arg.getRuntime().newTypeError("no implicit conversion to float from nil");
        }
        return arg.convertToFloat().getDoubleValue();
    }

    public static IRubyObject dbl_cmp(Ruby runtime, double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return runtime.getNil();
        }
        if (a > b) {
            return RubyFixnum.one(runtime);
        }
        if (a < b) {
            return RubyFixnum.minus_one(runtime);
        }
        return RubyFixnum.zero(runtime);
    }

    public static long fix2long(IRubyObject arg) {
        return ((RubyFixnum)arg).getLongValue();
    }

    public static int fix2int(IRubyObject arg) {
        long num = arg instanceof RubyFixnum ? RubyNumeric.fix2long(arg) : RubyNumeric.num2long(arg);
        RubyNumeric.checkInt(arg, num);
        return (int)num;
    }

    public static RubyInteger str2inum(Ruby runtime, RubyString str, int base) {
        return RubyNumeric.str2inum(runtime, str, base, false);
    }

    public static RubyNumeric int2fix(Ruby runtime, long val) {
        return RubyFixnum.newFixnum(runtime, val);
    }

    public static IRubyObject num2fix(IRubyObject val) {
        if (val instanceof RubyFixnum) {
            return val;
        }
        if (val instanceof RubyBignum) {
            throw val.getRuntime().newRangeError("integer " + val + " out of range of fixnum");
        }
        return RubyFixnum.newFixnum(val.getRuntime(), RubyNumeric.num2long(val));
    }

    public static RubyInteger str2inum(Ruby runtime, RubyString str, int base, boolean strict) {
        if (base != 0 && (base < 2 || base > 36)) {
            throw runtime.newArgumentError("illegal radix " + base);
        }
        ByteList bytes = str.getByteList();
        try {
            return runtime.newFixnum(Convert.byteListToLong(bytes, base, strict));
        }
        catch (InvalidIntegerException e) {
            return RubyNumeric.str2inumIIE(strict, runtime, str);
        }
        catch (NumberTooLargeException e) {
            return RubyNumeric.str2inumNTLE(strict, runtime, str, bytes, base);
        }
    }

    private static RubyInteger str2inumIIE(boolean strict, Ruby runtime, RubyString str) throws RaiseException {
        if (strict) {
            throw runtime.newArgumentError("invalid value for Integer: " + str.callMethod(runtime.getCurrentContext(), "inspect").toString());
        }
        return RubyFixnum.zero(runtime);
    }

    private static RubyInteger str2inumNTLE(boolean strict, Ruby runtime, RubyString str, ByteList bytes, int base) {
        try {
            BigInteger bi = Convert.byteListToBigInteger(bytes, base, strict);
            return new RubyBignum(runtime, bi);
        }
        catch (InvalidIntegerException e2) {
            return RubyNumeric.str2inumIIE(strict, runtime, str);
        }
    }

    public static RubyFloat str2fnum(Ruby runtime, RubyString arg) {
        return RubyNumeric.str2fnum(runtime, arg, false);
    }

    public static RubyFloat str2fnum(Ruby runtime, RubyString arg, boolean strict) {
        double ZERO = 0.0;
        try {
            return new RubyFloat(runtime, Convert.byteListToDouble(arg.getByteList(), strict));
        }
        catch (NumberFormatException e) {
            if (strict) {
                throw runtime.newArgumentError("invalid value for Float(): " + arg.callMethod(runtime.getCurrentContext(), "inspect").toString());
            }
            return new RubyFloat(runtime, 0.0);
        }
    }

    protected IRubyObject[] getCoerced(ThreadContext context, IRubyObject other, boolean error) {
        IRubyObject result;
        try {
            result = other.callMethod(context, "coerce", this);
        }
        catch (RaiseException e) {
            if (error) {
                throw this.getRuntime().newTypeError(other.getMetaClass().getName() + " can't be coerced into " + this.getMetaClass().getName());
            }
            return null;
        }
        if (!(result instanceof RubyArray) || ((RubyArray)result).getLength() != 2) {
            throw this.getRuntime().newTypeError("coerce must return [x, y]");
        }
        return ((RubyArray)result).toJavaArray();
    }

    protected IRubyObject callCoerced(ThreadContext context, String method, IRubyObject other, boolean err) {
        IRubyObject[] args = this.getCoerced(context, other, err);
        if (args == null) {
            return this.getRuntime().getNil();
        }
        return args[0].callMethod(context, method, args[1]);
    }

    protected IRubyObject callCoerced(ThreadContext context, String method, IRubyObject other) {
        IRubyObject[] args = this.getCoerced(context, other, false);
        if (args == null) {
            return this.getRuntime().getNil();
        }
        return args[0].callMethod(context, method, args[1]);
    }

    protected final IRubyObject coerceBody(ThreadContext context, IRubyObject other) {
        return other.callMethod(context, "coerce", this);
    }

    protected final RubyArray doCoerce(ThreadContext context, IRubyObject other, boolean err) {
        IRubyObject result;
        try {
            result = this.coerceBody(context, other);
        }
        catch (RaiseException e) {
            if (err) {
                throw this.getRuntime().newTypeError(other.getMetaClass().getName() + " can't be coerced into " + this.getMetaClass().getName());
            }
            return null;
        }
        if (!(result instanceof RubyArray) || ((RubyArray)result).getLength() != 2) {
            throw this.getRuntime().newTypeError("coerce must return [x, y]");
        }
        return (RubyArray)result;
    }

    protected final IRubyObject coerceBin(ThreadContext context, String method, IRubyObject other) {
        RubyArray ary = this.doCoerce(context, other, true);
        return ary.eltInternal(0).callMethod(context, method, ary.eltInternal(1));
    }

    protected final IRubyObject coerceCmp(ThreadContext context, String method, IRubyObject other) {
        RubyArray ary = this.doCoerce(context, other, false);
        if (ary == null) {
            return this.getRuntime().getNil();
        }
        return ary.eltInternal(0).callMethod(context, method, ary.eltInternal(1));
    }

    protected final IRubyObject coerceRelOp(ThreadContext context, String method, IRubyObject other) {
        RubyArray ary = this.doCoerce(context, other, false);
        if (ary == null) {
            return RubyComparable.cmperr(this, other);
        }
        return this.unwrapCoerced(context, method, other, ary);
    }

    private final IRubyObject unwrapCoerced(ThreadContext context, String method, IRubyObject other, RubyArray ary) {
        IRubyObject result = ary.eltInternal(0).callMethod(context, method, ary.eltInternal(1));
        if (result.isNil()) {
            return RubyComparable.cmperr(this, other);
        }
        return result;
    }

    public RubyNumeric asNumeric() {
        return this;
    }

    @JRubyMethod(name={"singleton_method_added"})
    public IRubyObject sadded(IRubyObject name) {
        throw this.getRuntime().newTypeError("can't define singleton method " + name + " for " + this.getType().getName());
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject arg) {
        throw this.getRuntime().newTypeError("can't copy " + this.getType().getName());
    }

    @JRubyMethod(name={"coerce"})
    public IRubyObject coerce(IRubyObject other) {
        if (this.getClass() == other.getClass()) {
            return this.getRuntime().newArray(other, this);
        }
        IRubyObject cdr = RubyKernel.new_float(this, this);
        IRubyObject car = RubyKernel.new_float(this, other);
        return this.getRuntime().newArray(car, cdr);
    }

    @JRubyMethod(name={"+@"})
    public IRubyObject op_uplus() {
        return this;
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus(ThreadContext context) {
        RubyFixnum zero = RubyFixnum.zero(this.getRuntime());
        RubyArray ary = zero.doCoerce(context, this, true);
        return ary.eltInternal(0).callMethod(context, MethodIndex.OP_MINUS, "-", ary.eltInternal(1));
    }

    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(IRubyObject other) {
        if (this == other) {
            return RubyFixnum.zero(this.getRuntime());
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        if (this.getClass() != other.getClass()) {
            return this.getRuntime().getFalse();
        }
        return RubyNumeric.equalInternal(context, this, other) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"quo"})
    public IRubyObject quo(ThreadContext context, IRubyObject other) {
        return this.callMethod(context, "/", other);
    }

    @JRubyMethod(name={"quo"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject quo_19(ThreadContext context, IRubyObject other) {
        return RubyRational.newRationalRaw(context.getRuntime(), this).callMethod(context, "/", other);
    }

    @JRubyMethod(name={"div"})
    public IRubyObject div(ThreadContext context, IRubyObject other) {
        return this.callMethod(context, "/", other).convertToFloat().floor();
    }

    @JRubyMethod(name={"divmod"})
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        return RubyArray.newArray(this.getRuntime(), this.div(context, other), this.modulo(context, other));
    }

    @JRubyMethod(name={"fdiv"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject fdiv(ThreadContext context, IRubyObject other) {
        return RuntimeHelpers.invoke(context, (IRubyObject)this.convertToFloat(), "/", other);
    }

    @JRubyMethod(name={"modulo"})
    public IRubyObject modulo(ThreadContext context, IRubyObject other) {
        return this.callMethod(context, "%", other);
    }

    @JRubyMethod(name={"remainder"})
    public IRubyObject remainder(ThreadContext context, IRubyObject dividend) {
        IRubyObject z = this.callMethod(context, "%", dividend);
        RubyNumeric x = this;
        RubyFixnum zero = RubyFixnum.zero(this.getRuntime());
        if (!RubyNumeric.equalInternal(context, z, zero) && (x.callMethod(context, MethodIndex.OP_LT, "<", zero).isTrue() && dividend.callMethod(context, MethodIndex.OP_GT, ">", zero).isTrue() || x.callMethod(context, MethodIndex.OP_GT, ">", zero).isTrue() && dividend.callMethod(context, MethodIndex.OP_LT, "<", zero).isTrue())) {
            return z.callMethod(context, MethodIndex.OP_MINUS, "-", dividend);
        }
        return z;
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject abs(ThreadContext context) {
        if (this.callMethod(context, MethodIndex.OP_LT, "<", RubyFixnum.zero(this.getRuntime())).isTrue()) {
            return this.callMethod(context, "-@");
        }
        return this;
    }

    @JRubyMethod(name={"to_int"})
    public IRubyObject to_int(ThreadContext context) {
        return RuntimeHelpers.invoke(context, this, "to_i");
    }

    @JRubyMethod(name={"scalar?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject scalar_p() {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"integer?"})
    public IRubyObject integer_p() {
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p(ThreadContext context) {
        return RubyNumeric.equalInternal(context, this, RubyFixnum.zero(this.getRuntime())) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"nonzero?"})
    public IRubyObject nonzero_p(ThreadContext context) {
        if (this.callMethod(context, "zero?").isTrue()) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    @JRubyMethod(name={"floor"})
    public IRubyObject floor() {
        return this.convertToFloat().floor();
    }

    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil() {
        return this.convertToFloat().ceil();
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round() {
        return this.convertToFloat().round();
    }

    @JRubyMethod(name={"truncate"})
    public IRubyObject truncate() {
        return this.convertToFloat().truncate();
    }

    @JRubyMethod(name={"step"}, required=1, optional=1, frame=true)
    public IRubyObject step(ThreadContext context, IRubyObject[] args, Block block) {
        switch (args.length) {
            case 0: {
                throw context.getRuntime().newArgumentError(0, 1);
            }
            case 1: {
                return this.step(context, args[0], block);
            }
            case 2: {
                return this.step(context, args[0], args[1], block);
            }
        }
        throw context.getRuntime().newArgumentError(args.length, 2);
    }

    @JRubyMethod(name={"step"}, frame=true)
    public IRubyObject step(ThreadContext context, IRubyObject arg0, Block block) {
        return this.step(context, arg0, RubyFixnum.one(context.getRuntime()), block);
    }

    @JRubyMethod(name={"step"}, frame=true)
    public IRubyObject step(ThreadContext context, IRubyObject to, IRubyObject step, Block block) {
        if (this instanceof RubyFixnum && to instanceof RubyFixnum && step instanceof RubyFixnum) {
            long value = this.getLongValue();
            long end = ((RubyFixnum)to).getLongValue();
            long diff = ((RubyFixnum)step).getLongValue();
            if (diff == 0L) {
                throw this.getRuntime().newArgumentError("step cannot be 0");
            }
            if (diff > 0L) {
                for (long i = value; i <= end; i += diff) {
                    block.yield(context, RubyFixnum.newFixnum(this.getRuntime(), i));
                }
            } else {
                for (long i = value; i >= end; i += diff) {
                    block.yield(context, RubyFixnum.newFixnum(this.getRuntime(), i));
                }
            }
        } else if (this instanceof RubyFloat || to instanceof RubyFloat || step instanceof RubyFloat) {
            double beg = RubyNumeric.num2dbl(this);
            double end = RubyNumeric.num2dbl(to);
            double unit = RubyNumeric.num2dbl(step);
            if (unit == 0.0) {
                throw this.getRuntime().newArgumentError("step cannot be 0");
            }
            double n = (end - beg) / unit;
            double err = (Math.abs(beg) + Math.abs(end) + Math.abs(end - beg)) / Math.abs(unit) * DBL_EPSILON;
            if (err > 0.5) {
                err = 0.5;
            }
            n = Math.floor(n + err) + 1.0;
            for (double i = 0.0; i < n; i += 1.0) {
                block.yield(context, RubyFloat.newFloat(this.getRuntime(), i * unit + beg));
            }
        } else {
            RubyNumeric i = this;
            int cmp = ((RubyBoolean)step.callMethod(context, MethodIndex.OP_GT, ">", RubyFixnum.zero(this.getRuntime()))).isTrue() ? MethodIndex.OP_GT : MethodIndex.OP_LT;
            String cmpString = MethodIndex.NAMES.get(cmp);
            while (!i.callMethod(context, cmp, cmpString, to).isTrue()) {
                block.yield(context, i);
                i = (RubyNumeric)i.callMethod(context, MethodIndex.OP_PLUS, "+", step);
            }
        }
        return this;
    }

    protected final IRubyObject op_num_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        return other.callMethod(context, MethodIndex.EQUALEQUAL, "==", this);
    }

    @JRubyMethod(name={"numerator"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject numerator(ThreadContext context) {
        return RubyRational.newRationalConvert(context, this).callMethod(context, "numerator");
    }

    @JRubyMethod(name={"denominator"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject denominator(ThreadContext context) {
        return RubyRational.newRationalConvert(context, this).callMethod(context, "denominator");
    }

    @JRubyMethod(name={"to_c"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_c(ThreadContext context) {
        return RubyComplex.newComplexCanonicalize(context, this);
    }

    @JRubyMethod(name={"re"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject re(ThreadContext context) {
        return RubyComplex.newComplexConvert(context, this);
    }

    @JRubyMethod(name={"im"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject im(ThreadContext context) {
        return RubyComplex.newComplexConvert(context, RubyFixnum.zero(context.getRuntime()), this);
    }

    @JRubyMethod(name={"real"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject real(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"image", "imag"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject image(ThreadContext context) {
        return RubyFixnum.zero(context.getRuntime());
    }

    @JRubyMethod(name={"arg"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject arg(ThreadContext context) {
        if (!Numeric.f_negative_p(context, this)) {
            return RubyFixnum.zero(context.getRuntime());
        }
        return context.getRuntime().getMath().fastFetchConstant("PI");
    }

    @JRubyMethod(name={"polar"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject polar(ThreadContext context) {
        return context.getRuntime().newArray(Numeric.f_abs(context, this), Numeric.f_arg(context, this));
    }

    @JRubyMethod(name={"conjugate"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject conjugate(ThreadContext context) {
        return this;
    }

    public static class NumberTooLargeException
    extends NumberFormatException {
        private static final long serialVersionUID = -1835120694982699449L;

        public NumberTooLargeException() {
        }

        public NumberTooLargeException(String message) {
            super(message);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    public static class InvalidIntegerException
    extends NumberFormatException {
        private static final long serialVersionUID = 55019452543252148L;

        public InvalidIntegerException() {
        }

        public InvalidIntegerException(String message) {
            super(message);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

