/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.io.InputStream;
import java.io.PrintStream;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyException;
import org.jruby.nb.RubyInstanceConfig;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.exceptions.MainExitException;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.exceptions.ThreadKill;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.SafePropertyAccessor;
import org.jruby.nb.util.SimpleSampler;

public class Main {
    private boolean hasPrintedUsage = false;
    private final RubyInstanceConfig config;

    public Main(RubyInstanceConfig config) {
        this.config = config;
    }

    public Main(final InputStream in, final PrintStream out, final PrintStream err) {
        this(new RubyInstanceConfig(){
            {
                this.setInput(in);
                this.setOutput(out);
                this.setError(err);
            }
        });
    }

    public Main() {
        this(new RubyInstanceConfig());
    }

    public static void main(String[] args) {
        Main main = new Main();
        try {
            int status = main.run(args);
            if (status != 0) {
                System.exit(status);
            }
        }
        catch (RaiseException re) {
            throw re;
        }
        catch (Throwable t) {
            System.err.println(ThreadContext.createRawBacktraceStringFromThrowable(t));
            System.exit(1);
        }
    }

    public int run(String[] args) {
        try {
            this.config.processArguments(args);
            return this.run();
        }
        catch (MainExitException mee) {
            if (!mee.isAborted()) {
                this.config.getOutput().println(mee.getMessage());
                if (mee.isUsageError()) {
                    this.printUsage();
                }
            }
            return mee.getStatus();
        }
        catch (OutOfMemoryError oome) {
            System.gc();
            String memoryMax = SafePropertyAccessor.getProperty("jruby.memory.max");
            String message = "";
            if (memoryMax != null) {
                message = " of " + memoryMax;
            }
            System.err.println("Error: Your application used more memory than the safety cap" + message + ".");
            System.err.println("Specify -J-Xmx####m to increase it (#### = cap size in MB).");
            if (this.config.getVerbose().booleanValue()) {
                System.err.println("Exception trace follows:");
                oome.printStackTrace();
            } else {
                System.err.println("Specify -w for full OutOfMemoryError stack trace");
            }
            return 1;
        }
        catch (StackOverflowError soe) {
            System.gc();
            String stackMax = SafePropertyAccessor.getProperty("jruby.stack.max");
            String message = "";
            if (stackMax != null) {
                message = " of " + stackMax;
            }
            System.err.println("Error: Your application used more stack memory than the safety cap" + message + ".");
            System.err.println("Specify -J-Xss####k to increase it (#### = cap size in KB).");
            if (this.config.getVerbose().booleanValue()) {
                System.err.println("Exception trace follows:");
                soe.printStackTrace();
            } else {
                System.err.println("Specify -w for full StackOverflowError stack trace");
            }
            return 1;
        }
        catch (UnsupportedClassVersionError ucve) {
            System.err.println("Error: Some library (perhaps JRuby) was built with a later JVM version.");
            System.err.println("Please use libraries built with the version you intend to use or an earlier one.");
            if (this.config.getVerbose().booleanValue()) {
                System.err.println("Exception trace follows:");
                ucve.printStackTrace();
            } else {
                System.err.println("Specify -w for full UnsupportedClassVersionError stack trace");
            }
            return 1;
        }
        catch (ThreadKill kill) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() {
        Ruby runtime;
        String filename;
        InputStream in;
        block21: {
            if (this.config.isShowVersion()) {
                this.showVersion();
            }
            if (this.config.isShowCopyright()) {
                this.showCopyright();
            }
            if (!this.config.shouldRunInterpreter()) {
                if (this.config.shouldPrintUsage()) {
                    this.printUsage();
                }
                if (this.config.shouldPrintProperties()) {
                    this.printProperties();
                }
                return 0;
            }
            in = this.config.getScriptSource();
            filename = this.config.displayedFileName();
            runtime = Ruby.newInstance(this.config);
            try {
                Thread.currentThread().setContextClassLoader(runtime.getJRubyClassLoader());
            }
            catch (SecurityException se) {
                if (!runtime.getInstanceConfig().isVerbose()) break block21;
                System.err.println("WARNING: Security restrictions disallowed setting context classloader for main thread.");
            }
        }
        if (in != null) {
            if (this.config.isShouldCheckSyntax()) {
                runtime.parseFromMain(in, filename);
                this.config.getOutput().println("Syntax OK");
            } else {
                long now = -1L;
                try {
                    if (this.config.isBenchmarking()) {
                        now = System.currentTimeMillis();
                    }
                    if (this.config.isSamplingEnabled()) {
                        SimpleSampler.startSampleThread();
                    }
                    try {
                        runtime.runFromMain(in, filename);
                    }
                    finally {
                        runtime.tearDown();
                        if (this.config.isBenchmarking()) {
                            this.config.getOutput().println("Runtime: " + (System.currentTimeMillis() - now) + " ms");
                        }
                        if (this.config.isSamplingEnabled()) {
                            SimpleSampler.report();
                        }
                    }
                }
                catch (RaiseException rj) {
                    RubyException raisedException = rj.getException();
                    if (runtime.getSystemExit().isInstance(raisedException)) {
                        IRubyObject status = raisedException.callMethod(runtime.getCurrentContext(), "status");
                        if (status != null && !status.isNil()) {
                            return RubyNumeric.fix2int(status);
                        }
                    }
                    runtime.printError(raisedException);
                    return 1;
                }
            }
        }
        return 0;
    }

    private void showVersion() {
        this.config.getOutput().print(this.config.getVersionString());
    }

    private void showCopyright() {
        this.config.getOutput().print(this.config.getCopyrightString());
    }

    public void printUsage() {
        if (!this.hasPrintedUsage) {
            this.config.getOutput().print(this.config.getBasicUsageHelp());
            this.hasPrintedUsage = true;
        }
    }

    public void printProperties() {
        this.config.getOutput().print(this.config.getPropertyHelp());
    }
}

