/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class SelectPlatformAppModulePanel
extends JPanel {
    private DialogDescriptor dd;
    private Project appModuleProject;
    private final ArrayList<Project> openProjects;
    private JButton btnBrowse;
    private JComboBox comboProjects;
    private JLabel lblHint;
    private JLabel lblOpenProjects;

    public SelectPlatformAppModulePanel() {
        this.initComponents();
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        this.openProjects = new ArrayList(projectArray.length);
        ArrayList<String> arrayList = new ArrayList<String>(projectArray.length);
        for (Project project : projectArray) {
            if (!SelectPlatformAppModulePanel.isNbAppProject(project)) continue;
            this.openProjects.add(project);
            arrayList.add(ProjectUtils.getInformation((Project)project).getDisplayName());
        }
        this.comboProjects.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        this.comboProjects.setSelectedIndex(-1);
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectPlatformAppModulePanel.this.browseProject();
            }
        });
        this.comboProjects.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SelectPlatformAppModulePanel.this.dd.setValid(SelectPlatformAppModulePanel.this.comboProjects.getSelectedItem() != null);
            }
        });
    }

    private void initComponents() {
        this.lblHint = new JLabel();
        this.lblOpenProjects = new JLabel();
        this.comboProjects = new JComboBox();
        this.btnBrowse = new JButton();
        this.lblHint.setText(NbBundle.getMessage(SelectPlatformAppModulePanel.class, (String)"SelectPlatformAppModulePanel.lblHint.text"));
        this.lblOpenProjects.setText(NbBundle.getMessage(SelectPlatformAppModulePanel.class, (String)"SelectPlatformAppModulePanel.lblOpenProjects.text"));
        this.btnBrowse.setText(NbBundle.getMessage(SelectPlatformAppModulePanel.class, (String)"SelectPlatformAppModulePanel.btnBrowse.text"));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblHint).addGroup(groupLayout.createSequentialGroup().addComponent(this.lblOpenProjects).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboProjects, 0, 222, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.btnBrowse))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.lblHint).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblOpenProjects).addComponent(this.comboProjects, -2, -1, -2).addComponent(this.btnBrowse)).addContainerGap(27, Short.MAX_VALUE)));
    }

    private void browseProject() {
        JFileChooser jFileChooser = ProjectChooser.projectChooser();
        while (0 == jFileChooser.showOpenDialog(this)) {
            File file = jFileChooser.getSelectedFile();
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            if (null == fileObject || !fileObject.isFolder()) {
                return;
            }
            try {
                Project project = ProjectManager.getDefault().findProject(fileObject);
                if (null == project || !SelectPlatformAppModulePanel.isNbAppProject(project)) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SelectPlatformAppModulePanel.class, (String)"Err_NotMavenNBAppProject")));
                    continue;
                }
                this.appModuleProject = project;
                ArrayList<String> arrayList = new ArrayList<String>(this.openProjects.size() + 1);
                for (Project project2 : this.openProjects) {
                    arrayList.add(ProjectUtils.getInformation((Project)project2).getDisplayName());
                }
                arrayList.add(ProjectUtils.getInformation((Project)project).getDisplayName());
                this.comboProjects.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
                this.comboProjects.setSelectedItem(ProjectUtils.getInformation((Project)project).getDisplayName());
                return;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Exceptions.printStackTrace((Throwable)illegalArgumentException);
                continue;
            }
            break;
        }
        return;
    }

    private Project getSelectedProject() {
        int n;
        Project project = this.appModuleProject;
        if (null == project && (n = this.comboProjects.getSelectedIndex()) >= 0) {
            project = this.openProjects.get(n);
        }
        return project;
    }

    static boolean findAppModule(Project project) {
        DialogDescriptor dialogDescriptor;
        SelectPlatformAppModulePanel selectPlatformAppModulePanel = new SelectPlatformAppModulePanel();
        selectPlatformAppModulePanel.dd = dialogDescriptor = new DialogDescriptor((Object)selectPlatformAppModulePanel, NbBundle.getMessage(SelectPlatformAppModulePanel.class, (String)"Title_SelectProject"), true, null);
        dialogDescriptor.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        Project project2 = selectPlatformAppModulePanel.getSelectedProject();
        if (null != project2) {
            FileObject fileObject = project2.getProjectDirectory();
            File file = FileUtil.toFile((FileObject)fileObject);
            File file2 = FileUtil.toFile((FileObject)project.getProjectDirectory());
            String string = FileUtilities.relativizeFile((File)file2, (File)file);
            AuxiliaryProperties auxiliaryProperties = (AuxiliaryProperties)project.getLookup().lookup(AuxiliaryProperties.class);
            auxiliaryProperties.put("pathToNbApplicationModule", string, true);
            return true;
        }
        return false;
    }

    private static boolean isNbAppProject(Project project) {
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        return nbMavenProject != null && "nbm-application".equals(nbMavenProject.getPackagingType());
    }
}

