/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ReferenceType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import org.netbeans.modules.web.beans.impl.model.Checker;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;

class AssignabilityChecker
implements Checker {
    private DeclaredType myVarType;
    private WebBeansModelImplementation myImpl;
    private ReferenceType myType;

    AssignabilityChecker() {
    }

    static AssignabilityChecker get() {
        return new AssignabilityChecker();
    }

    void init(DeclaredType declaredType, ReferenceType referenceType, WebBeansModelImplementation webBeansModelImplementation) {
        this.myVarType = declaredType;
        this.myType = referenceType;
        this.myImpl = webBeansModelImplementation;
    }

    @Override
    public boolean check() {
        boolean bl = this.checkAssignability(this.getVarType(), this.getType());
        return bl;
    }

    public boolean checkAssignability(DeclaredType declaredType, ReferenceType referenceType) {
        Element element = declaredType.asElement();
        if (!(element instanceof TypeElement)) {
            return false;
        }
        if (((TypeElement)element).getTypeParameters().size() == 0) {
            return this.getImplementation().getHelper().getCompilationController().getTypes().isAssignable(referenceType, declaredType);
        }
        if (!(referenceType instanceof DeclaredType)) {
            return false;
        }
        DeclaredType declaredType2 = (DeclaredType)referenceType;
        List<? extends TypeMirror> list = declaredType2.getTypeArguments();
        if (list.size() == 0) {
            List<? extends TypeMirror> list2 = ((TypeElement)declaredType2.asElement()).getInterfaces();
            for (TypeMirror typeMirror : list2) {
                if (!(typeMirror instanceof DeclaredType) || !this.checkAssignability(declaredType, (DeclaredType)typeMirror)) continue;
                return true;
            }
            Object object = declaredType2;
            do {
                TypeMirror typeMirror;
                if ((typeMirror = ((TypeElement)object.asElement()).getSuperclass()) instanceof DeclaredType) {
                    object = (DeclaredType)typeMirror;
                    if (!this.checkAssignability(declaredType, (ReferenceType)object)) continue;
                    return true;
                }
                object = null;
            } while (object != null);
            return false;
        }
        TypeElement typeElement = this.getImplementation().getHelper().getCompilationController().getElements().getTypeElement(Object.class.getCanonicalName());
        Types types = this.getImplementation().getHelper().getCompilationController().getTypes();
        if (!types.isSameType(types.erasure(declaredType), types.erasure(declaredType2))) {
            return false;
        }
        List<? extends TypeMirror> list2 = declaredType.getTypeArguments();
        if (list2.size() == 0 || types.isSameType(declaredType, types.erasure(declaredType))) {
            for (TypeMirror typeMirror : list) {
                if (typeMirror.getKind() == TypeKind.DECLARED) {
                    if (((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().contentEquals(Object.class.getCanonicalName())) continue;
                    return false;
                }
                if (typeMirror.getKind() == TypeKind.TYPEVAR) {
                    TypeMirror typeMirror2 = ((TypeVariable)typeMirror).getLowerBound();
                    if (typeMirror2 != null && typeMirror2.getKind() != TypeKind.NULL) {
                        return false;
                    }
                    TypeMirror typeMirror3 = ((TypeVariable)typeMirror).getUpperBound();
                    if (typeMirror3 == null || typeMirror3.getKind() == TypeKind.NULL) continue;
                    return types.isSameType(typeMirror3, typeElement.asType());
                }
                return false;
            }
            return true;
        }
        if (list2.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < list2.size(); ++i) {
            TypeMirror typeMirror = list.get(i);
            if (this.checkParameter(typeMirror, list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean checkParameter(TypeMirror typeMirror, TypeMirror typeMirror2) {
        Types types = this.getImplementation().getHelper().getCompilationController().getTypes();
        if (typeMirror.getKind() != TypeKind.TYPEVAR && typeMirror2.getKind() != TypeKind.TYPEVAR && typeMirror instanceof ReferenceType && typeMirror2 instanceof ReferenceType) {
            if (this.isAssignable(typeMirror, typeMirror2, types)) {
                return true;
            }
            if (typeMirror2 instanceof DeclaredType) {
                return this.checkAssignability((DeclaredType)typeMirror2, (ReferenceType)typeMirror);
            }
            return false;
        }
        if (typeMirror2.getKind() == TypeKind.WILDCARD) {
            return this.handleWildCard(typeMirror, (WildcardType)typeMirror2, types);
        }
        if (typeMirror.getKind() == TypeKind.TYPEVAR && typeMirror2.getKind() == TypeKind.TYPEVAR) {
            TypeMirror typeMirror3 = ((TypeVariable)typeMirror).getUpperBound();
            TypeMirror typeMirror4 = ((TypeVariable)typeMirror2).getUpperBound();
            if (typeMirror3 == null || typeMirror3.getKind() == TypeKind.NULL) {
                return true;
            }
            if (typeMirror4 == null || typeMirror4.getKind() == TypeKind.NULL) {
                return false;
            }
            if (this.isAssignable(typeMirror3, typeMirror4, this.getImplementation().getHelper().getCompilationController().getTypes())) {
                return true;
            }
            if (typeMirror4 instanceof DeclaredType) {
                return this.checkAssignability((DeclaredType)typeMirror4, (ReferenceType)typeMirror3);
            }
            return false;
        }
        if (typeMirror2.getKind() != TypeKind.TYPEVAR && typeMirror.getKind() == TypeKind.TYPEVAR) {
            TypeMirror typeMirror5 = ((TypeVariable)typeMirror).getUpperBound();
            if (typeMirror5 == null || typeMirror5.getKind() == TypeKind.NULL || this.isAssignable(typeMirror2, typeMirror5, this.getImplementation().getHelper().getCompilationController().getTypes())) {
                return true;
            }
            if (typeMirror5 instanceof DeclaredType) {
                this.checkAssignability((DeclaredType)typeMirror5, (ReferenceType)typeMirror2);
            } else {
                return false;
            }
        }
        return false;
    }

    private boolean handleWildCard(TypeMirror typeMirror, WildcardType wildcardType, Types types) {
        TypeMirror typeMirror2 = wildcardType.getExtendsBound();
        TypeMirror typeMirror3 = wildcardType.getSuperBound();
        if (typeMirror instanceof ReferenceType && typeMirror.getKind() != TypeKind.TYPEVAR) {
            if (typeMirror2 == null || typeMirror2.getKind() == TypeKind.NULL) {
                if (typeMirror3 == null || typeMirror3.getKind() == TypeKind.NULL) {
                    return true;
                }
                if (this.isAssignable(typeMirror3, typeMirror, types)) {
                    return true;
                }
                if (typeMirror instanceof DeclaredType) {
                    return this.checkAssignability((DeclaredType)typeMirror, (ReferenceType)typeMirror3);
                }
                return false;
            }
            if (typeMirror3 == null || typeMirror3.getKind() == TypeKind.NULL) {
                if (this.isAssignable(typeMirror, typeMirror2, types)) {
                    return true;
                }
                if (typeMirror2 instanceof DeclaredType) {
                    return this.checkAssignability((DeclaredType)typeMirror2, (ReferenceType)typeMirror);
                }
                return false;
            }
            if (this.isAssignable(typeMirror, typeMirror2, types) && this.isAssignable(typeMirror3, typeMirror, types)) {
                return true;
            }
            if (typeMirror instanceof DeclaredType && typeMirror3 instanceof DeclaredType) {
                return this.checkAssignability((DeclaredType)typeMirror2, (ReferenceType)typeMirror) && this.checkAssignability((DeclaredType)typeMirror, (ReferenceType)typeMirror3);
            }
            return false;
        }
        if (typeMirror.getKind() == TypeKind.TYPEVAR) {
            TypeMirror typeMirror4 = ((TypeVariable)typeMirror).getUpperBound();
            if (typeMirror4 == null || typeMirror4.getKind() == TypeKind.NULL) {
                return typeMirror2 == null || typeMirror2.getKind() == TypeKind.NULL;
            }
            if (typeMirror2 == null || typeMirror2.getKind() == TypeKind.NULL) {
                if (typeMirror3 == null || typeMirror3.getKind() == TypeKind.NULL) {
                    return true;
                }
                if (this.isAssignable(typeMirror3, typeMirror4, types)) {
                    return true;
                }
                if (typeMirror4 instanceof DeclaredType) {
                    return this.checkAssignability((DeclaredType)typeMirror4, (ReferenceType)typeMirror3);
                }
                return false;
            }
            if (typeMirror3 == null || typeMirror3.getKind() == TypeKind.NULL) {
                if (this.isAssignable(typeMirror4, typeMirror2, types)) {
                    return true;
                }
                if (typeMirror2 instanceof DeclaredType) {
                    return this.checkAssignability((DeclaredType)typeMirror2, (ReferenceType)typeMirror4);
                }
                return false;
            }
            if (this.isAssignable(typeMirror4, typeMirror2, types) && this.isAssignable(typeMirror3, typeMirror4, types)) {
                return true;
            }
            if (typeMirror4 instanceof DeclaredType && typeMirror3 instanceof DeclaredType) {
                return this.checkAssignability((DeclaredType)typeMirror2, (ReferenceType)typeMirror4) && this.checkAssignability((DeclaredType)typeMirror4, (ReferenceType)typeMirror3);
            }
            return false;
        }
        return false;
    }

    private boolean isAssignable(TypeMirror typeMirror, TypeMirror typeMirror2, Types types) {
        boolean bl;
        Element element = types.asElement(typeMirror2);
        boolean bl2 = bl = element instanceof TypeElement && ((TypeElement)element).getTypeParameters().size() != 0;
        if (bl) {
            return false;
        }
        return types.isAssignable(typeMirror, typeMirror2);
    }

    private DeclaredType getVarType() {
        return this.myVarType;
    }

    private WebBeansModelImplementation getImplementation() {
        return this.myImpl;
    }

    private ReferenceType getType() {
        return this.myType;
    }
}

