/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.refactoring.RenameTransaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;

public class HibernateMappingRenameTransaction
extends RenameTransaction {
    private final String rescrName = "Resource";
    private boolean pathOnly = false;

    public HibernateMappingRenameTransaction(Set<FileObject> set, String string, String string2) {
        this(set, string, string2, false);
    }

    public HibernateMappingRenameTransaction(Set<FileObject> set, String string, String string2, boolean bl) {
        super(set, string, string2);
        this.pathOnly = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doChanges() {
        for (FileObject fileObject : this.getToBeModifiedFiles()) {
            OutputStream outputStream = null;
            try {
                InputStream inputStream = fileObject.getInputStream();
                HibernateConfiguration hibernateConfiguration = HibernateConfiguration.createGraph(inputStream);
                SessionFactory sessionFactory = hibernateConfiguration.getSessionFactory();
                if (sessionFactory != null) {
                    for (int i = 0; i < sessionFactory.sizeMapping(); ++i) {
                        int n;
                        String string = sessionFactory.getAttributeValue("Mapping", i, "Resource");
                        if (string == null) continue;
                        String string2 = string;
                        String string3 = this.newName;
                        if (this.pathOnly && (n = string.lastIndexOf(47)) > -1) {
                            string2 = string.substring(0, n);
                            string3 = string3 + "/" + string.substring(string.lastIndexOf(47) + 1);
                        }
                        if (!string2.equals(this.origName)) continue;
                        sessionFactory.setAttributeValue("Mapping", i, "Resource", string3);
                    }
                }
                outputStream = fileObject.getOutputStream();
                hibernateConfiguration.write(outputStream);
            }
            catch (FileAlreadyLockedException fileAlreadyLockedException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileAlreadyLockedException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            finally {
                try {
                    if (outputStream == null) continue;
                    outputStream.close();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        }
    }
}

