/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hibernate.refactoring.HibernateRefactoringElement;
import org.netbeans.modules.hibernate.refactoring.HibernateRefactoringUtil;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class HibernateFindUsagesPlugin
implements RefactoringPlugin {
    private final WhereUsedQuery query;
    private List<FileObject> mappingFileObjs;

    public HibernateFindUsagesPlugin(WhereUsedQuery whereUsedQuery) {
        this.query = whereUsedQuery;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        if (this.query.getBooleanValue((Object)"FIND_REFERENCES")) {
            TreePathHandle treePathHandle = (TreePathHandle)this.query.getRefactoringSource().lookup(TreePathHandle.class);
            FileObject fileObject = null;
            if (treePathHandle != null && (treePathHandle.getKind() == Tree.Kind.CLASS || treePathHandle.getKind() == Tree.Kind.VARIABLE || treePathHandle.getKind() == Tree.Kind.MEMBER_SELECT || treePathHandle.getKind() == Tree.Kind.IDENTIFIER)) {
                fileObject = treePathHandle.getFileObject();
            }
            if (fileObject == null) {
                return null;
            }
            Project project = FileOwnerQuery.getOwner(fileObject);
            if (project == null) {
                return null;
            }
            HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateEnvironment == null) {
                return null;
            }
            this.mappingFileObjs = hibernateEnvironment.getAllHibernateMappingFileObjects();
            if (this.mappingFileObjs == null || this.mappingFileObjs.size() == 0) {
                return null;
            }
            try {
                if (treePathHandle != null) {
                    if (treePathHandle.getKind() == Tree.Kind.CLASS) {
                        this.findJavaClassUsage(treePathHandle, refactoringElementsBag, fileObject);
                    } else {
                        this.findJavaClassFieldUsage(treePathHandle, refactoringElementsBag, fileObject);
                    }
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        return null;
    }

    private void findJavaClassUsage(final TreePathHandle treePathHandle, RefactoringElementsBag refactoringElementsBag, FileObject fileObject) throws IOException {
        final String[] stringArray = new String[]{null};
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return;
        }
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws IOException {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Element element = treePathHandle.resolveElement((CompilationInfo)compilationController);
                if (element == null || element.getKind() != ElementKind.CLASS) {
                    return;
                }
                stringArray[0] = ElementUtilities.getBinaryName((TypeElement)((TypeElement)element));
            }
        }, true);
        String string = stringArray[0];
        if (string != null) {
            Map<FileObject, List<HibernateRefactoringUtil.OccurrenceItem>> map = HibernateRefactoringUtil.getJavaClassOccurrences(this.mappingFileObjs, string);
            for (FileObject fileObject2 : map.keySet()) {
                List<HibernateRefactoringUtil.OccurrenceItem> list = map.get(fileObject2);
                for (HibernateRefactoringUtil.OccurrenceItem occurrenceItem : list) {
                    HibernateRefactoringElement hibernateRefactoringElement = new HibernateRefactoringElement(fileObject2, string, occurrenceItem.getLocation(), occurrenceItem.getText());
                    refactoringElementsBag.add((AbstractRefactoring)this.query, (RefactoringElementImplementation)hibernateRefactoringElement);
                }
            }
        }
    }

    private void findJavaClassFieldUsage(final TreePathHandle treePathHandle, RefactoringElementsBag refactoringElementsBag, FileObject fileObject) throws IOException {
        final String[] stringArray = new String[]{null, null};
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return;
        }
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws IOException {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Element element = treePathHandle.resolveElement((CompilationInfo)compilationController);
                if (element == null || element.getKind() != ElementKind.FIELD) {
                    return;
                }
                stringArray[0] = ElementUtilities.getBinaryName((TypeElement)((TypeElement)element.getEnclosingElement()));
                stringArray[1] = element.getSimpleName().toString();
            }
        }, true);
        String string = stringArray[0];
        String string2 = stringArray[1];
        if (string != null && string2 != null) {
            Map<FileObject, List<HibernateRefactoringUtil.OccurrenceItem>> map = HibernateRefactoringUtil.getJavaFieldOccurrences(this.mappingFileObjs, string, string2);
            for (FileObject fileObject2 : map.keySet()) {
                List<HibernateRefactoringUtil.OccurrenceItem> list = map.get(fileObject2);
                for (HibernateRefactoringUtil.OccurrenceItem occurrenceItem : list) {
                    HibernateRefactoringElement hibernateRefactoringElement = new HibernateRefactoringElement(fileObject2, string2, occurrenceItem.getLocation(), occurrenceItem.getText());
                    refactoringElementsBag.add((AbstractRefactoring)this.query, (RefactoringElementImplementation)hibernateRefactoringElement);
                }
            }
        }
    }
}

