/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.hyperlink;

import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.hibernate.hyperlink.HyperlinkEnv;
import org.netbeans.modules.hibernate.hyperlink.HyperlinkProcessor;
import org.netbeans.modules.hibernate.hyperlink.JavaClassHyperlinkProcessor;
import org.netbeans.modules.hibernate.hyperlink.ResourceHyperlinkProcessor;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;

public class HibernateCfgHyperlinkProvider
implements HyperlinkProvider {
    private BaseDocument lastDocument = null;
    private HyperlinkProcessor currentProcessor;
    private Map<String, HyperlinkProcessor> attribValueProcessors = new HashMap<String, HyperlinkProcessor>();

    public HibernateCfgHyperlinkProvider() {
        ResourceHyperlinkProcessor resourceHyperlinkProcessor = new ResourceHyperlinkProcessor();
        this.registerAttribValueHyperlinkPoint("mapping", "resource", resourceHyperlinkProcessor);
        JavaClassHyperlinkProcessor javaClassHyperlinkProcessor = new JavaClassHyperlinkProcessor();
        this.registerAttribValueHyperlinkPoint("mapping", "class", javaClassHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("class-cache", "class", javaClassHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("collection-cache", "collection", javaClassHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("listener", "class", javaClassHyperlinkProcessor);
    }

    private void registerAttribValueHyperlinkPoint(String string, String string2, HyperlinkProcessor hyperlinkProcessor) {
        this.attribValueProcessors.put(this.createRegisteredName(string, string2), hyperlinkProcessor);
    }

    public boolean isHyperlinkPoint(Document document, int n) {
        if (!(document instanceof BaseDocument)) {
            return false;
        }
        BaseDocument baseDocument = (BaseDocument)document;
        if (!(baseDocument.getSyntaxSupport() instanceof XMLSyntaxSupport)) {
            return false;
        }
        HyperlinkEnv hyperlinkEnv = new HyperlinkEnv(document, n);
        this.currentProcessor = hyperlinkEnv.getType().isValueHyperlink() ? this.locateHyperlinkProcessor(hyperlinkEnv.getTagName(), hyperlinkEnv.getAttribName(), this.attribValueProcessors) : null;
        return this.currentProcessor != null;
    }

    public int[] getHyperlinkSpan(Document document, int n) {
        if (!(document instanceof BaseDocument)) {
            return null;
        }
        if (this.currentProcessor == null) {
            return null;
        }
        HyperlinkEnv hyperlinkEnv = new HyperlinkEnv(document, n);
        return this.currentProcessor.getSpan(hyperlinkEnv);
    }

    public void performClickAction(Document document, int n) {
        HyperlinkEnv hyperlinkEnv = new HyperlinkEnv(document, n);
        if (this.currentProcessor != null) {
            this.currentProcessor.process(hyperlinkEnv);
        }
    }

    protected String createRegisteredName(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null && string.trim().length() > 0) {
            stringBuilder.append("/nodeName=");
            stringBuilder.append(string);
        } else {
            stringBuilder.append("/nodeName=");
            stringBuilder.append("*");
        }
        if (string2 != null && string2.trim().length() > 0) {
            stringBuilder.append("/attribute=");
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private HyperlinkProcessor locateHyperlinkProcessor(String string, String string2, Map<String, HyperlinkProcessor> map) {
        String string3 = this.createRegisteredName(string, string2);
        if (map.containsKey(string3)) {
            return map.get(string3);
        }
        string3 = this.createRegisteredName("*", string2);
        if (map.containsKey(string3)) {
            return map.get(string3);
        }
        return null;
    }
}

