/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.util;

import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.spi.ejbjar.EarImplementation;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class EarProjectUtil {
    private static final Logger UI_LOGGER = Logger.getLogger("org.netbeans.ui.j2ee.earproject");
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.j2ee.earproject");

    private EarProjectUtil() {
    }

    public static boolean isDDCompulsory(Project project) {
        assert (project != null);
        EarImplementation earImplementation = (EarImplementation)project.getLookup().lookup(EarImplementation.class);
        if (earImplementation != null) {
            return EarProjectUtil.isDDCompulsory(Profile.fromPropertiesString((String)earImplementation.getJ2eePlatformVersion()));
        }
        return EarProjectUtil.isDDCompulsory(Profile.J2EE_14);
    }

    public static boolean isDDCompulsory(Profile profile) {
        if (profile == null) {
            return false;
        }
        return Profile.J2EE_13.equals(profile) || Profile.J2EE_14.equals(profile);
    }

    public static boolean isDDWritable(EarProject earProject) {
        return earProject.getAppModule().getDeploymentDescriptor() != null;
    }

    public static boolean hasLength(String string) {
        return string != null && string.length() > 0;
    }

    public static void logUI(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        Parameters.notNull((CharSequence)"message", (Object)string);
        Parameters.notNull((CharSequence)"bundle", (Object)resourceBundle);
        LogRecord logRecord = new LogRecord(Level.INFO, string);
        logRecord.setLoggerName(UI_LOGGER.getName());
        logRecord.setResourceBundle(resourceBundle);
        if (objectArray != null) {
            logRecord.setParameters(objectArray);
        }
        UI_LOGGER.log(logRecord);
    }

    public static void logUsage(Class clazz, String string, Object[] objectArray) {
        Parameters.notNull((CharSequence)"message", (Object)string);
        LogRecord logRecord = new LogRecord(Level.INFO, string);
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setResourceBundle(NbBundle.getBundle((Class)clazz));
        logRecord.setResourceBundleName(clazz.getPackage().getName() + ".Bundle");
        if (objectArray != null) {
            logRecord.setParameters(objectArray);
        }
        USG_LOGGER.log(logRecord);
    }

    public static boolean isJavaEEModule(Project project) {
        return project != null && project.getLookup().lookup(J2eeModuleProvider.class) != null && project.getLookup().lookup(J2eeApplicationProvider.class) == null;
    }
}

