/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernateweb.framework;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.netbeans.modules.hibernate.wizards.Util;
import org.netbeans.modules.hibernateweb.framework.HibernateWebModuleExtender;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.openide.util.NbBundle;

public class HibernateConfigurationPanel
extends JPanel
implements DocumentListener,
ItemListener {
    private HibernateWebModuleExtender webModuleExtender;
    private ExtenderController controller;
    private boolean forNewProjectWizard = false;
    private JComboBox cmbDbConnection;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField txtDialect;

    public HibernateConfigurationPanel(HibernateWebModuleExtender hibernateWebModuleExtender, ExtenderController extenderController, boolean bl) {
        this.webModuleExtender = hibernateWebModuleExtender;
        this.controller = extenderController;
        this.forNewProjectWizard = bl;
        this.initComponents();
        this.setDefaults();
        this.fillPanel();
        this.cmbDbConnection.addItemListener(this);
    }

    public void setDefaults() {
        this.cmbDbConnection.setModel(new DefaultComboBoxModel<String>(new String[0]));
        DatabaseExplorerUIs.connect((JComboBox)this.cmbDbConnection, (ConnectionManager)ConnectionManager.getDefault());
    }

    public void fillPanel() {
        if (this.forNewProjectWizard && this.cmbDbConnection.getItemCount() > 1) {
            this.cmbDbConnection.setSelectedIndex(0);
        }
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(HibernateConfigurationPanel.class, (String)"LBL_HibernateConfigurationPanel_Name");
    }

    private void fillComponents() {
        DatabaseConnection databaseConnection = this.getDatabaseConnection();
        if (databaseConnection != null && this.cmbDbConnection.getItemCount() != 0) {
            this.txtDialect.setText(Util.getDialectName((String)databaseConnection.getDriverClass()));
        }
    }

    public boolean isPanelValid() {
        return !this.forNewProjectWizard || this.cmbDbConnection.getModel().getSize() > 1;
    }

    @Override
    public void disable() {
        super.disable();
        for (Component component : this.getComponents()) {
            component.setEnabled(false);
        }
    }

    public DatabaseConnection getDatabaseConnection() {
        return (DatabaseConnection)this.cmbDbConnection.getSelectedItem();
    }

    public void setDatabaseConnection(String string) {
        for (int i = 0; i < this.cmbDbConnection.getItemCount(); ++i) {
            DatabaseConnection databaseConnection;
            if (!(this.cmbDbConnection.getItemAt(i) instanceof DatabaseConnection) || !(databaseConnection = (DatabaseConnection)this.cmbDbConnection.getItemAt(i)).getDatabaseURL().equals(string)) continue;
            this.cmbDbConnection.setSelectedItem(databaseConnection);
            break;
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.cmbDbConnection = new JComboBox();
        this.txtDialect = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel3.setText(NbBundle.getMessage(HibernateConfigurationPanel.class, (String)"HibernateConfigurationPanel.jLabel3.text"));
        this.cmbDbConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HibernateConfigurationPanel.this.cmbDbConnectionActionPerformed(actionEvent);
            }
        });
        this.txtDialect.setEditable(false);
        this.txtDialect.setText(NbBundle.getMessage(HibernateConfigurationPanel.class, (String)"HibernateConfigurationPanel.txtDialect.text"));
        this.jLabel4.setText(NbBundle.getMessage(HibernateConfigurationPanel.class, (String)"HibernateConfigurationPanel.jLabel4.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.txtDialect, -1, 329, Short.MAX_VALUE).add((Component)this.cmbDbConnection, 0, 329, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(28, 28, 28).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.txtDialect, -2, -1, -2))).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.cmbDbConnection, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void cmbDbConnectionActionPerformed(ActionEvent actionEvent) {
        this.fillComponents();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.webModuleExtender.fireChangeEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.webModuleExtender.fireChangeEvent();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.webModuleExtender.fireChangeEvent();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.webModuleExtender.fireChangeEvent();
    }

    public String getSelectedDialect() {
        if (this.txtDialect.getText() != null) {
            return this.txtDialect.getText().trim();
        }
        return null;
    }

    public void setDialect(String string) {
        this.txtDialect.setText(string);
    }

    public String getSelectedDriver() {
        if (this.getDatabaseConnection() != null && this.getDatabaseConnection().getDriverClass() != null) {
            return this.getDatabaseConnection().getDriverClass().trim();
        }
        return null;
    }

    public String getSelectedURL() {
        if (this.getDatabaseConnection() != null && this.getDatabaseConnection().getDatabaseURL() != null) {
            return this.getDatabaseConnection().getDatabaseURL().trim();
        }
        return null;
    }

    public String getUserName() {
        if (this.getDatabaseConnection() != null && this.getDatabaseConnection().getUser() != null) {
            return this.getDatabaseConnection().getUser().trim();
        }
        return null;
    }

    public String getPassword() {
        if (this.getDatabaseConnection() != null && this.getDatabaseConnection().getPassword() != null) {
            return this.getDatabaseConnection().getPassword().trim();
        }
        return null;
    }
}

