/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.usages;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TooManyListenersException;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.document.DateTools;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.gsf.GsfTaskProvider;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.Indexer;
import org.netbeans.modules.gsf.api.ParseEvent;
import org.netbeans.modules.gsf.api.ParseListener;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.Severity;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathFactory;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathImplementation;
import org.netbeans.modules.gsfpath.spi.classpath.support.ClassPathSupport;
import org.netbeans.modules.gsfret.source.GlobalSourcePath;
import org.netbeans.modules.gsfret.source.SourceAccessor;
import org.netbeans.modules.gsfret.source.parsing.FileObjects;
import org.netbeans.modules.gsfret.source.usages.CachingIndexer;
import org.netbeans.modules.gsfret.source.usages.ClassIndexImpl;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.netbeans.modules.gsfret.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.gsfret.source.usages.Index;
import org.netbeans.modules.gsfret.source.usages.SourceAnalyser;
import org.netbeans.modules.gsfret.source.util.LowMemoryEvent;
import org.netbeans.modules.gsfret.source.util.LowMemoryListener;
import org.netbeans.modules.gsfret.source.util.LowMemoryNotifier;
import org.netbeans.napi.gsfret.source.ClasspathInfo;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.napi.gsfret.source.ParserTaskImpl;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

public class RepositoryUpdater
implements PropertyChangeListener,
FileChangeListener {
    private static final boolean PREINDEXING = Boolean.getBoolean("gsf.preindexing");
    static boolean haveIndexed = false;
    private static final Logger LOGGER = Logger.getLogger(RepositoryUpdater.class.getName());
    private static final Logger BUG_LOGGER = Logger.getLogger("ruby.indexerbug");
    private static final Set<String> ignoredDirectories = RepositoryUpdater.parseSet("org.netbeans.javacore.ignoreDirectories", "SCCS CVS .svn .hg");
    private static final boolean noscan = Boolean.getBoolean("netbeans.javacore.noscan");
    private static final boolean PERF_TEST = Boolean.getBoolean("perf.refactoring.test");
    private static final long STARTED = System.currentTimeMillis();
    private static final int DELAY = Utilities.isWindows() ? 2000 : 1000;
    private static RepositoryUpdater instance;
    private final GlobalSourcePath cpImpl;
    private final ClassPath cp;
    private final ClassPath ucp;
    private final ClassPath binCp;
    private Set<URL> scannedRoots;
    private Set<URL> scannedBinaries;
    private Map<URL, List<URL>> deps;
    private Delay delay;
    private Work currentWork;
    private boolean dirty;
    private int noSubmited;
    private final AtomicBoolean closed;
    private static List<IndexerEntry> indexers;

    private static String getElapsedTime() {
        StringBuilder sb = new StringBuilder();
        long now = System.currentTimeMillis();
        long elapsed = now - STARTED;
        long seconds = elapsed / 1000L;
        long minutes = seconds / 60L;
        if (seconds > 400L) {
            sb.append(minutes + " minutes, " + (seconds -= minutes * 60L) + " seconds");
        } else {
            sb.append(seconds + " seconds");
        }
        sb.append(": ");
        return sb.toString();
    }

    private RepositoryUpdater() {
        try {
            this.closed = new AtomicBoolean(false);
            this.scannedRoots = Collections.synchronizedSet(new HashSet());
            this.scannedBinaries = Collections.synchronizedSet(new HashSet());
            this.deps = Collections.synchronizedMap(new HashMap());
            this.delay = new Delay();
            this.cpImpl = GlobalSourcePath.getDefault();
            this.cpImpl.setExcludesListener(this);
            this.cp = ClassPathFactory.createClassPath((ClassPathImplementation)this.cpImpl.getSourcePath());
            this.cp.addPropertyChangeListener((PropertyChangeListener)this);
            this.ucp = ClassPathFactory.createClassPath((ClassPathImplementation)this.cpImpl.getUnknownSourcePath());
            this.binCp = ClassPathFactory.createClassPath((ClassPathImplementation)this.cpImpl.getBinaryPath());
            this.registerFileSystemListener();
            this.submitBatch();
        }
        catch (TooManyListenersException e) {
            throw new IllegalStateException();
        }
    }

    public ClassPath getScannedSources() {
        return this.cp;
    }

    public ClassPath getScannedBinaries() {
        return this.binCp;
    }

    public Map<URL, List<URL>> getDependencies() {
        return new HashMap<URL, List<URL>>(this.deps);
    }

    public void close() {
        this.closed.set(true);
        this.cp.removePropertyChangeListener((PropertyChangeListener)this);
        this.unregisterFileSystemListener();
        this.delay.cancel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("roots".equals(evt.getPropertyName())) {
            this.submitBatch();
        } else if ("includes".equals(evt.getPropertyName())) {
            ClassPath changedCp = (ClassPath)evt.getNewValue();
            assert (changedCp != null);
            for (ClassPath.Entry e : changedCp.entries()) {
                URL root = e.getURL();
                this.scheduleCompilation(root, root, true);
            }
        }
    }

    private synchronized void submitBatch() {
        if (this.currentWork == null) {
            this.currentWork = Work.batch();
            this.submit(this.currentWork);
        } else {
            this.dirty = true;
        }
    }

    public synchronized boolean isScanInProgress() {
        return this.noSubmited > 0;
    }

    public synchronized void waitScanFinished() throws InterruptedException {
        while (this.noSubmited > 0) {
            this.wait();
        }
    }

    private synchronized boolean isDirty() {
        if (this.dirty) {
            this.dirty = false;
            return true;
        }
        this.currentWork = null;
        return false;
    }

    private synchronized void resetDirty() {
        this.dirty = false;
        this.currentWork = null;
    }

    public void fileRenamed(FileRenameEvent fe) {
        FileObject fo = fe.getFile();
        try {
            URL root;
            if ((RepositoryUpdater.isRelevantSource(fo) || fo.isFolder()) && VisibilityQuery.getDefault().isVisible(fo)) {
                URL root2 = this.getOwningSourceRoot(fo);
                if (root2 != null) {
                    File parentFile;
                    String originalName = fe.getName();
                    String originalExt = fe.getExt();
                    if (originalExt.length() > 0) {
                        originalName = originalName + '.' + originalExt;
                    }
                    if ((parentFile = FileUtil.toFile((FileObject)fo.getParent())) != null) {
                        URL original = new File(parentFile, originalName).toURI().toURL();
                        this.submit(Work.delete(original, root2, fo.isFolder()));
                        this.delay.post(Work.compile(fo, root2));
                    }
                }
            } else if (RepositoryUpdater.isBinary(fo) && VisibilityQuery.getDefault().isVisible(fo) && (root = this.getOwningBinaryRoot(fo)) != null) {
                File parentFile;
                String originalName = fe.getName();
                String originalExt = fe.getExt();
                if (originalExt.length() > 0) {
                    originalName = originalName + '.' + originalExt;
                }
                if ((parentFile = FileUtil.toFile((FileObject)fo.getParent())) != null) {
                    URL original = new File(parentFile, originalName).toURI().toURL();
                    this.submit(Work.binary(original, root, fo.isFolder()));
                    this.submit(Work.binary(fo, root));
                }
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void fileFolderCreated(FileEvent fe) {
        FileObject fo = fe.getFile();
        try {
            URL root = this.getOwningSourceRoot(fo);
            if (root != null && VisibilityQuery.getDefault().isVisible(fo)) {
                this.scheduleCompilation(fo, root);
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    public void fileDeleted(FileEvent fe) {
        FileObject fo = fe.getFile();
        boolean isFolder = fo.isFolder();
        try {
            URL root;
            boolean relevantSource = RepositoryUpdater.isRelevantSource(fo);
            if (!relevantSource && "content/unknown".equals(fo.getMIMEType())) {
                relevantSource = true;
            }
            if ((relevantSource || isFolder) && VisibilityQuery.getDefault().isVisible(fo)) {
                URL root2 = this.getOwningSourceRoot(fo);
                if (root2 != null) {
                    this.submit(Work.delete(fo, root2, isFolder));
                }
            } else if ((RepositoryUpdater.isBinary(fo) || isFolder) && VisibilityQuery.getDefault().isVisible(fo) && (root = this.getOwningBinaryRoot(fo)) != null) {
                this.submit(Work.binary(fo, root));
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    public void fileDataCreated(FileEvent fe) {
        FileObject fo = fe.getFile();
        try {
            URL root;
            if (RepositoryUpdater.isRelevantSource(fo) && VisibilityQuery.getDefault().isVisible(fo)) {
                URL root2 = this.getOwningSourceRoot(fo);
                if (root2 != null) {
                    this.postCompilation(fo, root2);
                }
            } else if (RepositoryUpdater.isBinary(fo) && VisibilityQuery.getDefault().isVisible(fo) && (root = this.getOwningBinaryRoot(fo)) != null) {
                this.submit(Work.binary(fo, root));
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    public void fileChanged(FileEvent fe) {
        FileObject fo = fe.getFile();
        try {
            URL root;
            if (RepositoryUpdater.isRelevantSource(fo) && VisibilityQuery.getDefault().isVisible(fo)) {
                URL root2 = this.getOwningSourceRoot(fo);
                if (root2 != null) {
                    this.postCompilation(fo, root2);
                }
            } else if (RepositoryUpdater.isBinary(fo) && VisibilityQuery.getDefault().isVisible(fo) && (root = this.getOwningBinaryRoot(fo)) != null) {
                this.submit(Work.binary(fo, root));
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    public final void scheduleCompilation(FileObject fo, FileObject root) throws IOException {
        URL foURL = fo.getURL();
        URL rootURL = root.getURL();
        assert ("file".equals(foURL.getProtocol()) && "file".equals(rootURL.getProtocol()));
        this.scheduleCompilation(foURL, rootURL, fo.isFolder());
    }

    private final void scheduleCompilation(FileObject fo, URL root) throws IOException {
        this.scheduleCompilation(fo.getURL(), root, fo.isFolder());
    }

    private final void scheduleCompilation(URL file, URL root, boolean isFolder) {
        this.submit(Work.compile(file, root, isFolder));
    }

    private final void postCompilation(FileObject file, URL root) throws FileStateInvalidException {
        this.delay.post(Work.compile(file, root));
    }

    public final CountDownLatch scheduleCompilationAndWait(FileObject folder, FileObject root) throws IOException {
        CountDownLatch[] latch = new CountDownLatch[1];
        this.submit(Work.compile(folder, root.getURL(), latch));
        return latch[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submit(Work work) {
        if (!noscan) {
            RepositoryUpdater repositoryUpdater = this;
            synchronized (repositoryUpdater) {
                ++this.noSubmited;
            }
            CompileWorker cw = new CompileWorker(work);
            SourceAccessor.getINSTANCE().runSpecialTask(cw, Source.Priority.MAX);
        }
    }

    private void registerFileSystemListener() {
        FileUtil.addFileChangeListener((FileChangeListener)this);
    }

    private void unregisterFileSystemListener() {
        FileUtil.removeFileChangeListener((FileChangeListener)this);
    }

    private URL getOwningSourceRoot(FileObject fo) {
        if (fo == null) {
            return null;
        }
        ArrayList<URL> clone = new ArrayList<URL>(this.scannedRoots);
        for (URL root : clone) {
            FileObject rootFo = URLMapper.findFileObject((URL)root);
            if (rootFo == null || !FileUtil.isParentOf((FileObject)rootFo, (FileObject)fo)) continue;
            return root;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getOwningBinaryRoot(FileObject fo) {
        if (fo == null) {
            return null;
        }
        try {
            Set<URL> set = this.scannedBinaries;
            synchronized (set) {
                URL foURL = fo.getURL();
                for (URL root : this.scannedBinaries) {
                    String foPath;
                    String filePath;
                    URL fileURL = FileUtil.getArchiveFile((URL)root);
                    boolean archive = true;
                    if (fileURL == null) {
                        fileURL = root;
                        archive = false;
                    }
                    if ((filePath = fileURL.getPath()).equals(foPath = foURL.getPath())) {
                        return root;
                    }
                    if (archive || !foPath.startsWith(filePath)) continue;
                    return root;
                }
            }
        }
        catch (FileStateInvalidException fsi) {
            Exceptions.printStackTrace((Throwable)fsi);
        }
        return null;
    }

    public static boolean isRelevantSource(FileObject fo) {
        if (fo.isFolder()) {
            return false;
        }
        return LanguageRegistry.getInstance().isSupported(fo.getMIMEType());
    }

    private static boolean isBinary(FileObject fo) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void batchCompile(List<ParserFile> toCompile, FileObject rootFo, ClasspathInfo cpInfo, CachingIndexer cachingIndexer, URL root, Set<URI> dirtyFiles, Set added, Map<Language, Map<String, String>> timeStamps, Map<Language, List<File>> seenTimestampedFiles) throws IOException {
        assert (toCompile != null);
        assert (rootFo != null);
        assert (cpInfo != null);
        ParserFile active = null;
        CompilerListener listener = new CompilerListener();
        ArrayList<IndexerEntry> applicableIndexers = new ArrayList<IndexerEntry>(indexers.size());
        String urlString = root.toExternalForm();
        for (IndexerEntry entry : RepositoryUpdater.getIndexers()) {
            if (!entry.indexer.acceptQueryPath(urlString)) continue;
            applicableIndexers.add(entry);
        }
        LowMemoryNotifier.getDefault().addLowMemoryListener(listener);
        try {
            LinkedList<ParserFile> bigFiles = new LinkedList<ParserFile>();
            boolean state = false;
            boolean isBigFile = false;
            while (!toCompile.isEmpty() || !bigFiles.isEmpty() || active != null) {
                try {
                    if (listener.lowMemory.getAndSet(false)) {
                        if (state) break;
                        state = true;
                        System.gc();
                        continue;
                    }
                    if (active == null) {
                        if (!toCompile.isEmpty()) {
                            active = toCompile.remove(0);
                            isBigFile = false;
                        } else {
                            active = (ParserFile)bigFiles.remove(0);
                            isBigFile = true;
                        }
                    }
                    if (active.getNameExt().startsWith(".#")) {
                        state = false;
                        active = null;
                        continue;
                    }
                    for (int in = 0; in < applicableIndexers.size(); ++in) {
                        File file;
                        String url;
                        String timeStampString;
                        Map<String, String> ts;
                        IndexerEntry entry = (IndexerEntry)applicableIndexers.get(in);
                        Indexer indexer = entry.getIndexer();
                        if (!indexer.isIndexable(active)) continue;
                        Language language = entry.getLanguage();
                        if (timeStamps != null && (ts = timeStamps.get(language)) != null && (timeStampString = ts.get(url = indexer.getPersistentUrl(file = active.getFile()))) != null) {
                            List<File> list = seenTimestampedFiles.get(language);
                            if (list == null) {
                                list = new ArrayList<File>(toCompile.size());
                                seenTimestampedFiles.put(language, list);
                            }
                            list.add(file);
                            try {
                                long timeStamp = DateTools.stringToTime((String)timeStampString);
                                if (file.lastModified() <= timeStamp) {
                                    continue;
                                }
                            }
                            catch (ParseException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                        ParserTaskImpl jt = new ParserTaskImpl(language);
                        jt.setParseListener(listener);
                        Iterable<ParserResult> trees = jt.parse(active);
                        if (trees == null) continue;
                        if (cachingIndexer != null) {
                            cachingIndexer.index(language, active.getFile(), trees);
                            continue;
                        }
                        ClassIndexImpl uqImpl = ClassIndexManager.get(language).createUsagesQuery(root, true);
                        assert (uqImpl != null);
                        SourceAnalyser sa = uqImpl.getSourceAnalyser();
                        if (sa == null) continue;
                        sa.analyse(language, trees);
                    }
                    if (listener.lowMemory.getAndSet(false)) {
                        listener.cleanDiagnostics();
                        if (state) {
                            if (isBigFile) break;
                            bigFiles.add(active);
                            active = null;
                            state = false;
                        } else {
                            state = true;
                        }
                        System.gc();
                        continue;
                    }
                    if (!listener.errors.isEmpty()) {
                        listener.cleanDiagnostics();
                    }
                    active = null;
                    state = false;
                }
                catch (Throwable t) {
                    if (BUG_LOGGER.isLoggable(Level.FINE)) {
                        BUG_LOGGER.log(Level.FINE, RepositoryUpdater.getElapsedTime() + "CompilerWorker *** caught exception 4 ", t);
                    }
                    if (PREINDEXING) {
                        Exceptions.attachMessage((Throwable)t, (String)("Parsing " + active.getFile().getPath()));
                        Exceptions.printStackTrace((Throwable)t);
                        Toolkit.getDefaultToolkit().beep();
                    }
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    String activeURI = active != null ? active.getNameExt() : "unknown";
                    active = null;
                    listener.cleanDiagnostics();
                    ClassPath bootPath = cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT);
                    ClassPath classPath = cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE);
                    ClassPath sourcePath = cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
                    t = Exceptions.attachMessage((Throwable)t, (String)String.format("Root: %s File: %s Bootpath: %s Classpath: %s Sourcepath: %s", FileUtil.getFileDisplayName((FileObject)rootFo), activeURI.toString(), bootPath == null ? null : bootPath.toString(), classPath == null ? null : classPath.toString(), sourcePath == null ? null : sourcePath.toString()));
                    Exceptions.printStackTrace((Throwable)t);
                }
            }
            if (state) {
                LOGGER.warning("Not enough memory to compile folder: " + FileUtil.getFileDisplayName((FileObject)rootFo));
            }
        }
        finally {
            LowMemoryNotifier.getDefault().removeLowMemoryListener(listener);
        }
    }

    private static Set<String> parseSet(String propertyName, String defaultValue) {
        StringTokenizer st = new StringTokenizer(System.getProperty(propertyName, defaultValue), " \t\n\r\f,-:+!");
        HashSet<String> result = new HashSet<String>();
        while (st.hasMoreTokens()) {
            result.add(st.nextToken());
        }
        return result;
    }

    private static ClassPath.Entry getClassPathEntry(ClassPath cp, URL root) {
        assert (cp != null);
        assert (root != null);
        for (ClassPath.Entry e : cp.entries()) {
            if (!root.equals(e.getURL())) continue;
            return e;
        }
        return null;
    }

    public static synchronized RepositoryUpdater getDefault() {
        if (instance == null) {
            instance = new RepositoryUpdater();
        }
        return instance;
    }

    private static List<IndexerEntry> getIndexers() {
        if (indexers == null) {
            indexers = new ArrayList<IndexerEntry>();
            for (Language language : LanguageRegistry.getInstance()) {
                Indexer indexer = language.getIndexer();
                if (indexer == null) continue;
                IndexerEntry entry = new IndexerEntry(language, indexer);
                indexers.add(entry);
            }
        }
        return indexers;
    }

    static /* synthetic */ ClassPath access$1200(RepositoryUpdater x0) {
        return x0.cp;
    }

    static /* synthetic */ ClassPath access$1300(RepositoryUpdater x0) {
        return x0.ucp;
    }

    static /* synthetic */ ClassPath access$1400(RepositoryUpdater x0) {
        return x0.binCp;
    }

    static /* synthetic */ Map access$1700(RepositoryUpdater x0) {
        return x0.deps;
    }

    static /* synthetic */ void access$1800(RepositoryUpdater x0) {
        x0.resetDirty();
    }

    static /* synthetic */ boolean access$2000(RepositoryUpdater x0) {
        return x0.isDirty();
    }

    static /* synthetic */ int access$2410(RepositoryUpdater x0) {
        return x0.noSubmited--;
    }

    static /* synthetic */ int access$2400(RepositoryUpdater x0) {
        return x0.noSubmited;
    }

    static /* synthetic */ GlobalSourcePath access$2500(RepositoryUpdater x0) {
        return x0.cpImpl;
    }

    private static class IndexerEntry {
        private Language language;
        private Indexer indexer;

        IndexerEntry(Language language, Indexer indexer) {
            this.language = language;
            this.indexer = indexer;
        }

        Indexer getIndexer() {
            return this.indexer;
        }

        Language getLanguage() {
            return this.language;
        }
    }

    private static class CompilerListener
    implements LowMemoryListener,
    ParseListener {
        final List<Error> errors = new LinkedList<Error>();
        final List<Error> warnings = new LinkedList<Error>();
        final List<ParserResult> justEntered = new LinkedList<ParserResult>();
        final AtomicBoolean lowMemory = new AtomicBoolean();

        private CompilerListener() {
        }

        void cleanDiagnostics() {
            if (!this.errors.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    for (Error msg : this.errors) {
                        LOGGER.fine(msg.toString());
                    }
                }
                this.errors.clear();
            }
            if (!this.warnings.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    for (Error msg : this.warnings) {
                        LOGGER.fine(msg.toString());
                    }
                }
                this.warnings.clear();
            }
            this.justEntered.clear();
        }

        List<ParserResult> getEnteredTypes() {
            ArrayList<ParserResult> result = new ArrayList<ParserResult>(this.justEntered);
            this.justEntered.clear();
            return result;
        }

        public void error(Error error) {
            if (error.getSeverity() == Severity.ERROR) {
                this.errors.add(error);
            } else {
                this.warnings.add(error);
            }
        }

        public void exception(Exception exception) {
        }

        public void started(ParseEvent e) {
        }

        public void finished(ParseEvent event) {
            ParserResult result;
            if (event.getKind() == ParseEvent.Kind.PARSE && (result = event.getResult()) != null) {
                this.justEntered.add(result);
            }
        }

        @Override
        public void lowMemory(LowMemoryEvent event) {
            this.lowMemory.set(true);
        }
    }

    private final class Delay {
        private final Timer timer = new Timer(RepositoryUpdater.class.getName());
        private final List<Work> tasks = new LinkedList<Work>();

        public synchronized void post(Work work) {
            assert (work != null);
            this.tasks.add(work);
            this.timer.schedule((TimerTask)new DelayTask(work), DELAY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Work[] toCancel;
            Delay delay = this;
            synchronized (delay) {
                toCancel = this.tasks.toArray(new Work[this.tasks.size()]);
            }
            for (Work w : toCancel) {
                if (w.workType == WorkType.COMPILE) {
                    w = new SingleRootWork(WorkType.DELETE, ((SingleRootWork)w).file, ((SingleRootWork)w).root, ((SingleRootWork)w).isFolder, w.latch);
                }
                CompileWorker cw = new CompileWorker(w);
                try {
                    cw.run(null);
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        }

        private class DelayTask
        extends TimerTask {
            final Work work;

            public DelayTask(Work work) {
                this.work = work;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RepositoryUpdater.this.submit(this.work);
                Delay delay = Delay.this;
                synchronized (delay) {
                    Delay.this.tasks.remove(this.work);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancel() {
                boolean retValue = super.cancel();
                if (retValue) {
                    Delay delay = Delay.this;
                    synchronized (delay) {
                        Delay.this.tasks.remove(this.work);
                    }
                }
                return retValue;
            }
        }
    }

    static class LazyFileList
    implements Iterable<File> {
        private File root;

        public LazyFileList(File root) {
            assert (root != null);
            this.root = root;
        }

        @Override
        public Iterator<File> iterator() {
            if (!this.root.exists()) {
                return Collections.emptySet().iterator();
            }
            return new It(this.root);
        }

        private class It
        implements Iterator<File> {
            private final LinkedList<File> toDo = new LinkedList();

            public It(File root) {
                File[] files = root.listFiles();
                if (files != null && files.length > 0) {
                    this.toDo.addAll(Arrays.asList(files));
                }
            }

            @Override
            public boolean hasNext() {
                while (!this.toDo.isEmpty()) {
                    File f = this.toDo.peek();
                    String name = f.getName();
                    if (f.isDirectory() && !ignoredDirectories.contains(name)) {
                        f = this.toDo.removeFirst();
                        assert (f.isDirectory());
                        File[] content = f.listFiles();
                        if (content == null) continue;
                        for (int i = 0; i < content.length; ++i) {
                            f = content[i];
                            if (f == null) continue;
                            if (f.isFile()) {
                                this.toDo.addFirst(f);
                                continue;
                            }
                            this.toDo.addLast(f);
                        }
                        continue;
                    }
                    return true;
                }
                return false;
            }

            @Override
            public File next() {
                return this.toDo.removeFirst();
            }

            @Override
            public void remove() {
                if (BUG_LOGGER.isLoggable(Level.FINE)) {
                    BUG_LOGGER.log(Level.FINE, RepositoryUpdater.getElapsedTime() + "CompilerWorker throwing exception 1 ");
                }
                throw new UnsupportedOperationException();
            }
        }
    }

    private final class CompileWorker
    implements CancellableTask<CompilationInfo> {
        private Work work;
        private List<URL> state;
        private Set<URL> oldRoots;
        private Set<URL> oldBinaries;
        private Set<URL> newBinaries;
        private ProgressHandle handle;
        private final Set<URI> dirtyCrossFiles;
        private final Set<URL> ignoreExcludes;
        private final AtomicBoolean canceled;
        private Map<FileObject, WeakReference<ClassPath>> sourceClassPathsCache = new WeakHashMap<FileObject, WeakReference<ClassPath>>();

        public CompileWorker(Work work) {
            assert (work != null);
            this.work = work;
            this.canceled = new AtomicBoolean(false);
            this.dirtyCrossFiles = new HashSet<URI>();
            this.ignoreExcludes = new HashSet<URL>();
        }

        public void cancel() {
            this.canceled.set(true);
        }

        public void run(CompilationInfo nullInfo) throws IOException {
            ClassIndexManager.writeLock(new ClassIndexManager.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public Void run() throws IOException {
                    continuation = false;
                    try {
                        type = CompileWorker.access$000(CompileWorker.this).getType();
                        if (RepositoryUpdater.access$100().isLoggable(Level.FINE)) {
                            RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run - type=" + (Object)type);
                        }
                        switch (org.netbeans.modules.gsfret.source.usages.RepositoryUpdater$1.$SwitchMap$org$netbeans$modules$gsfret$source$usages$RepositoryUpdater$WorkType[type.ordinal()]) {
                            case 1: {
                                try {
                                    mw = (MultiRootsWork)CompileWorker.access$000(CompileWorker.this);
                                    roots = mw.getRoots();
                                    depGraph = new HashMap<K, V>();
                                    for (URL root : roots) {
                                        CompileWorker.access$300(CompileWorker.this, root, new Stack<E>(), depGraph, null, false);
                                    }
                                    CompileWorker.access$402(CompileWorker.this, Utilities.topologicalSort(roots, depGraph));
                                    it = CompileWorker.access$400(CompileWorker.this).listIterator(CompileWorker.access$400(CompileWorker.this).size());
lbl18:
                                    // 2 sources

                                    while (it.hasPrevious()) {
                                        if (RepositoryUpdater.access$500(RepositoryUpdater.this).get()) {
                                            root = null;
                                            return root;
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    break;
                                }
                                catch (TopologicalSortException tse) {
                                    ise = new IllegalStateException();
                                    if (RepositoryUpdater.access$100().isLoggable(Level.FINE) == false) throw (IllegalStateException)ise.initCause(tse);
                                    RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker *** IllegalStateException ", tse);
                                    throw (IllegalStateException)ise.initCause(tse);
                                }
lbl-1000:
                                // 1 sources

                                {
                                    rootURL = (URL)it.previous();
                                    it.remove();
                                    CompileWorker.access$700(CompileWorker.this, rootURL, rootURL, true, CompileWorker.access$600(CompileWorker.this));
                                    ** GOTO lbl18
                                }
                            }
                            case 2: {
                                if (!1.$assertionsDisabled && CompileWorker.access$600(CompileWorker.this) != null) {
                                    throw new AssertionError();
                                }
                                CompileWorker.access$602(CompileWorker.this, ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_BackgroundCompileStart")));
                                CompileWorker.access$600(CompileWorker.this).start();
                                if (RepositoryUpdater.access$100().isLoggable(Level.FINE)) {
                                    RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run.COMPILE_BATCH - created and started handle " + CompileWorker.access$600(CompileWorker.this));
                                }
                                completed = false;
                                try {
                                    CompileWorker.access$802(CompileWorker.this, new HashSet<E>(RepositoryUpdater.access$900(RepositoryUpdater.this)));
                                    CompileWorker.access$1002(CompileWorker.this, new HashSet<E>(RepositoryUpdater.access$1100(RepositoryUpdater.this)));
                                    entries = new LinkedList<E>();
                                    entries.addAll(RepositoryUpdater.access$1200(RepositoryUpdater.this).entries());
                                    entries.addAll(RepositoryUpdater.access$1300(RepositoryUpdater.this).entries());
                                    binaryEntries = RepositoryUpdater.access$1400(RepositoryUpdater.this).entries();
                                    CompileWorker.access$1502(CompileWorker.this, new HashSet<E>());
                                    for (ClassPath.Entry entry : binaryEntries) {
                                        binRoot = entry.getURL();
                                        if (CompileWorker.access$1000(CompileWorker.this).remove(binRoot)) continue;
                                        CompileWorker.access$1500(CompileWorker.this).add(binRoot);
                                    }
                                    depGraph = new HashMap<K, V>();
                                    for (ClassPath.Entry entry : entries) {
                                        if (RepositoryUpdater.access$500(RepositoryUpdater.this).get()) {
                                            var9_24 = null;
                                            return var9_24;
                                        }
                                        rootURL = entry.getURL();
                                        CompileWorker.access$300(CompileWorker.this, rootURL, new Stack<E>(), depGraph, CompileWorker.access$1500(CompileWorker.this), true);
                                    }
                                    if (RepositoryUpdater.access$1600() && depGraph.size() > 0) {
                                        for (Language language : LanguageRegistry.getInstance()) {
                                            coreLibraries = language.getGsfLanguage().getCoreLibraries();
                                            indexer = language.getIndexer();
                                            if (indexer == null || coreLibraries == null) continue;
                                            for (FileObject libFo : coreLibraries) {
                                                binRoot = libFo.getURL();
                                                if (!indexer.acceptQueryPath(binRoot.toExternalForm())) continue;
                                                depGraph.put(binRoot, Collections.<T>emptyList());
                                            }
                                        }
                                    }
                                    CompileWorker.access$402(CompileWorker.this, Utilities.topologicalSort(depGraph.keySet(), depGraph));
                                    RepositoryUpdater.access$1700(RepositoryUpdater.this).putAll(depGraph);
                                    completed = true;
                                }
                                catch (TopologicalSortException tse) {
                                    if (RepositoryUpdater.access$100().isLoggable(Level.FINE)) {
                                        RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run.COMPILE_BATCH - THREW EXCEPTION!", tse);
                                    }
                                    ise = new IllegalStateException();
                                    throw (IllegalStateException)ise.initCause(tse);
                                }
                                finally {
                                    if (RepositoryUpdater.access$100().isLoggable(Level.FINE)) {
                                        RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run.COMPILE_BATCH - completed=" + completed);
                                    }
                                    if (!completed) {
                                        RepositoryUpdater.access$1800(RepositoryUpdater.this);
                                    }
                                }
                            }
                            case 3: {
                                completed = false;
                                if (RepositoryUpdater.access$100().isLoggable(Level.FINE)) {
                                    RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run.COMPILE_CONT - about to scan roots");
                                }
                                try {
                                    if (!CompileWorker.access$1900(CompileWorker.this)) {
                                        if (RepositoryUpdater.access$100().isLoggable(Level.FINE)) {
                                            RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run.COMPILE_BATCH -failed - doing continuation!");
                                        }
                                        CompileWorker.access$002(CompileWorker.this, new Work(WorkType.COMPILE_CONT, null));
                                        SourceAccessor.getINSTANCE().runSpecialTask(CompileWorker.this, Source.Priority.MAX);
                                        continuation = true;
                                        tse = null;
                                        return tse;
                                    }
                                    while (RepositoryUpdater.access$2000(RepositoryUpdater.this)) {
                                        if (RepositoryUpdater.access$500(RepositoryUpdater.this).get()) {
                                            tse = null;
                                            return tse;
                                        }
                                        if (!1.$assertionsDisabled && !CompileWorker.access$400(CompileWorker.this).isEmpty()) {
                                            throw new AssertionError();
                                        }
                                        entries = new LinkedList<E>();
                                        entries.addAll(RepositoryUpdater.access$1200(RepositoryUpdater.this).entries());
                                        entries.addAll(RepositoryUpdater.access$1300(RepositoryUpdater.this).entries());
                                        binaryEntries = RepositoryUpdater.access$1400(RepositoryUpdater.this).entries();
                                        CompileWorker.access$1502(CompileWorker.this, new HashSet<E>());
                                        for (ClassPath.Entry entry : binaryEntries) {
                                            binRoot = entry.getURL();
                                            if (!RepositoryUpdater.access$1100(RepositoryUpdater.this).contains(binRoot)) {
                                                CompileWorker.access$1500(CompileWorker.this).add(binRoot);
                                                continue;
                                            }
                                            CompileWorker.access$1000(CompileWorker.this).remove(binRoot);
                                        }
                                        depGraph = new HashMap<URL, List<T>>();
                                        for (ClassPath.Entry entry : entries) {
                                            if (RepositoryUpdater.access$500(RepositoryUpdater.this).get()) {
                                                coreLibraries = null;
                                                return coreLibraries;
                                            }
                                            rootURL = entry.getURL();
                                            CompileWorker.access$300(CompileWorker.this, rootURL, new Stack<E>(), depGraph, CompileWorker.access$1500(CompileWorker.this), true);
                                        }
                                        try {
                                            CompileWorker.access$402(CompileWorker.this, Utilities.topologicalSort(depGraph.keySet(), depGraph));
                                            RepositoryUpdater.access$1700(RepositoryUpdater.this).putAll(depGraph);
                                        }
                                        catch (TopologicalSortException tse) {
                                            ise = new IllegalStateException();
                                            if (RepositoryUpdater.access$100().isLoggable(Level.FINE) == false) throw (IllegalStateException)ise.initCause(tse);
                                            RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker *** IllegalStateException ", ise);
                                            throw (IllegalStateException)ise.initCause(tse);
                                        }
                                        if (RepositoryUpdater.access$100().isLoggable(Level.FINE)) {
                                            RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run.COMPILE_BATCH - tryihng scanRoots again - state=" + CompileWorker.access$400(CompileWorker.this) + ",newBinaries=" + CompileWorker.access$1500(CompileWorker.this) + ", oldBinaries=" + CompileWorker.access$1000(CompileWorker.this));
                                        }
                                        if (CompileWorker.access$1900(CompileWorker.this)) continue;
                                        if (RepositoryUpdater.access$100().isLoggable(Level.FINE)) {
                                            RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run.COMPILE_BATCH - scanRoots failed AGAIN!");
                                        }
                                        CompileWorker.access$002(CompileWorker.this, new Work(WorkType.COMPILE_CONT, null));
                                        SourceAccessor.getINSTANCE().runSpecialTask(CompileWorker.this, Source.Priority.MAX);
                                        continuation = true;
                                        var7_20 = null;
                                        return var7_20;
                                    }
                                    completed = true;
                                }
                                finally {
                                    if (RepositoryUpdater.access$100().isLoggable(Level.FINE)) {
                                        RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run.COMPILE_BATCH - finally: completed=" + completed + ", continuation=" + continuation);
                                    }
                                    if (!completed && !continuation) {
                                        RepositoryUpdater.access$1800(RepositoryUpdater.this);
                                    }
                                }
                                RepositoryUpdater.access$900(RepositoryUpdater.this).removeAll(CompileWorker.access$800(CompileWorker.this));
                                RepositoryUpdater.access$1700(RepositoryUpdater.this).keySet().remove(CompileWorker.access$800(CompileWorker.this));
                                RepositoryUpdater.access$1100(RepositoryUpdater.this).removeAll(CompileWorker.access$1000(CompileWorker.this));
                                break;
                            }
                            case 4: {
                                try {
                                    sw = (SingleRootWork)CompileWorker.access$000(CompileWorker.this);
                                    file = sw.getFile();
                                    root = sw.getRoot();
                                    if (RepositoryUpdater.access$100().isLoggable(Level.FINE)) {
                                        RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run.COMPILE; file=" + file + ", root=" + root);
                                    }
                                    if (sw.isFolder()) {
                                        CompileWorker.access$602(CompileWorker.this, ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_Updating")));
                                        if (RepositoryUpdater.access$100().isLoggable(Level.FINE)) {
                                            RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run.COMPILE - created handle - " + CompileWorker.access$600(CompileWorker.this));
                                        }
                                        CompileWorker.access$600(CompileWorker.this).start();
                                        if (RepositoryUpdater.access$100().isLoggable(Level.FINE)) {
                                            RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run.COMPILE - started handle - " + CompileWorker.access$600(CompileWorker.this));
                                        }
                                        try {
                                            if (RepositoryUpdater.access$100().isLoggable(Level.FINE)) {
                                                RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run.COMPILE - updating file " + file + ", root=" + root);
                                            }
                                            CompileWorker.access$700(CompileWorker.this, file, root, false, CompileWorker.access$600(CompileWorker.this));
                                            break;
                                        }
                                        finally {
                                            CompileWorker.access$600(CompileWorker.this).finish();
                                            if (RepositoryUpdater.access$100().isLoggable(Level.FINE)) {
                                                RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run.COMPILE - finished handle - " + CompileWorker.access$600(CompileWorker.this));
                                            }
                                        }
                                    }
                                    if (RepositoryUpdater.access$100().isLoggable(Level.FINE)) {
                                        RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run.COMPILE - updating file");
                                    }
                                    CompileWorker.access$2100(CompileWorker.this, file, root);
                                }
                                catch (Exception abort) {}
                                break;
                            }
                            case 5: {
                                if (RepositoryUpdater.access$100().isLoggable(Level.FINE)) {
                                    RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run.DELETE");
                                }
                                sw = (SingleRootWork)CompileWorker.access$000(CompileWorker.this);
                                file = sw.getFile();
                                root = sw.getRoot();
                                CompileWorker.access$2200(CompileWorker.this, file, root, sw.isFolder());
                                break;
                            }
                            case 6: {
                                if (RepositoryUpdater.access$100().isLoggable(Level.FINE)) {
                                    RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run.BINARY");
                                }
                                sw = (SingleRootWork)CompileWorker.access$000(CompileWorker.this);
                                file = sw.getFile();
                                root = sw.getRoot();
                                CompileWorker.access$2300(CompileWorker.this, file, root);
                                break;
                            }
                        }
                        var3_3 = null;
                        return var3_3;
                    }
                    finally {
                        if (RepositoryUpdater.access$100().isLoggable(Level.FINE)) {
                            RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run.finally: continuation=" + continuation);
                        }
                        if (!continuation) {
                            var8_22 = RepositoryUpdater.this;
                            synchronized (var8_22) {
                                RepositoryUpdater.access$2410(RepositoryUpdater.this);
                                if (RepositoryUpdater.access$2400(RepositoryUpdater.this) == 0) {
                                    RepositoryUpdater.this.notifyAll();
                                    if (RepositoryUpdater.access$1600() && RepositoryUpdater.haveIndexed) {
                                        LifecycleManager.getDefault().saveAll();
                                        LifecycleManager.getDefault().exit();
                                    }
                                }
                                ** if (!RepositoryUpdater.access$100().isLoggable((Level)Level.FINE)) goto lbl242
                            }
lbl-1000:
                            // 1 sources

                            {
                                RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run.finally.after submission noSubmitted=" + RepositoryUpdater.access$2400(RepositoryUpdater.this));
                            }
lbl242:
                            // 2 sources

                            CompileWorker.access$000(CompileWorker.this).finished();
                            if (RepositoryUpdater.access$100().isLoggable(Level.FINE)) {
                                RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run.finally.finished -- handle=" + CompileWorker.access$600(CompileWorker.this));
                            }
                            if (CompileWorker.access$600(CompileWorker.this) != null) {
                                CompileWorker.access$600(CompileWorker.this).finish();
                                if (RepositoryUpdater.access$100().isLoggable(Level.FINE)) {
                                    RepositoryUpdater.access$100().log(Level.FINE, RepositoryUpdater.access$200() + "CompilerWorker.run.COMPILE_BATCH - finished handle " + CompileWorker.access$600(CompileWorker.this));
                                }
                            }
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ClassPath getBootClassPaths(FileObject file, String type) {
            CompileWorker compileWorker = this;
            synchronized (compileWorker) {
                Reference ref;
                ClassPath cp = null;
                if (!file.isFolder()) assert (false) : file;
                if (file.isFolder() && ((ref = (Reference)this.sourceClassPathsCache.get(file)) == null || (cp = (ClassPath)ref.get()) == null)) {
                    cp = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{file});
                    this.sourceClassPathsCache.put(file, new WeakReference<ClassPath>(cp));
                }
                return cp;
            }
        }

        private void findDependencies(URL rootURL, Stack<URL> cycleDetector, Map<URL, List<URL>> depGraph, Set<URL> binaries, boolean useInitialState) {
            if (useInitialState && RepositoryUpdater.this.scannedRoots.contains(rootURL)) {
                this.oldRoots.remove(rootURL);
                return;
            }
            if (depGraph.containsKey(rootURL)) {
                return;
            }
            FileObject rootFo = URLMapper.findFileObject((URL)rootURL);
            if (rootFo == null) {
                return;
            }
            depGraph.put(rootURL, new LinkedList());
            if (!RepositoryUpdater.this.scannedBinaries.contains(rootURL)) {
                binaries.add(rootURL);
            }
            this.oldBinaries.remove(rootURL);
        }

        private boolean scanRoots() {
            URL rootURL;
            Iterator<URL> it = this.newBinaries.iterator();
            while (it.hasNext()) {
                if (this.canceled.getAndSet(false)) {
                    return false;
                }
                if (RepositoryUpdater.this.closed.get()) {
                    return true;
                }
                rootURL = it.next();
                try {
                    it.remove();
                    String urlString = rootURL.toExternalForm();
                    for (IndexerEntry entry : RepositoryUpdater.getIndexers()) {
                        Language language = entry.getLanguage();
                        if (!entry.indexer.acceptQueryPath(urlString)) continue;
                        ClassIndexImpl ci = ClassIndexManager.get(language).createUsagesQuery(rootURL, false);
                    }
                    RepositoryUpdater.this.scannedBinaries.add(rootURL);
                }
                catch (Throwable e) {
                    if (BUG_LOGGER.isLoggable(Level.FINE)) {
                        BUG_LOGGER.log(Level.FINE, RepositoryUpdater.getElapsedTime() + "CompilerWorker *** caught exception ", e);
                    }
                    if (e instanceof ThreadDeath) {
                        throw (ThreadDeath)e;
                    }
                    Exceptions.attachMessage((Throwable)e, (String)("While scanning: " + rootURL));
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            it = this.state.listIterator(this.state.size());
            while (it.hasPrevious()) {
                if (this.canceled.getAndSet(false)) {
                    return false;
                }
                if (RepositoryUpdater.this.closed.get()) {
                    return true;
                }
                try {
                    rootURL = (URL)it.previous();
                    it.remove();
                    if (this.oldRoots.remove(rootURL) || RepositoryUpdater.this.scannedRoots.contains(rootURL)) continue;
                    long startT = System.currentTimeMillis();
                    this.updateFolder(rootURL, rootURL, false, this.handle);
                    long endT = System.currentTimeMillis();
                    if (PERF_TEST) {
                        try {
                            Class<?> c = Class.forName("org.netbeans.performance.test.utilities.LoggingScanClasspath", true, Thread.currentThread().getContextClassLoader());
                            Method m = c.getMethod("reportScanOfFile", String.class, Long.class);
                            m.invoke(c.newInstance(), rootURL.toExternalForm(), new Long(endT - startT));
                        }
                        catch (Exception e) {
                            Exceptions.printStackTrace((Throwable)e);
                        }
                    }
                    if (!PREINDEXING) continue;
                    for (Language language : LanguageRegistry.getInstance()) {
                        if (language.getIndexer() == null) continue;
                        Index.preindex(language, rootURL);
                    }
                    haveIndexed = true;
                }
                catch (Throwable e) {
                    if (BUG_LOGGER.isLoggable(Level.FINE)) {
                        BUG_LOGGER.log(Level.FINE, RepositoryUpdater.getElapsedTime() + "CompilerWorker *** caught exception 3 ", e);
                    }
                    if (e instanceof ThreadDeath) {
                        throw (ThreadDeath)e;
                    }
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            return true;
        }

        private boolean isBoot(ClassPath bootPath, FileObject rootFo) {
            for (FileObject fo : bootPath.getRoots()) {
                if (fo != rootFo) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateFolder(URL folder, URL root, boolean clean, ProgressHandle handle) throws IOException {
            String urlString;
            boolean isBoot;
            FileObject rootFo = URLMapper.findFileObject((URL)root);
            if (rootFo == null) {
                return;
            }
            if (!rootFo.isFolder()) {
                LOGGER.warning("Source root has to be a folder: " + FileUtil.getFileDisplayName((FileObject)rootFo));
                return;
            }
            ClassPath sourcePath = ClassPath.getClassPath((FileObject)rootFo, (String)"classpath/source");
            ClassPath bootPath = ClassPath.getClassPath((FileObject)rootFo, (String)"classpath/boot");
            ClassPath compilePath = ClassPath.getClassPath((FileObject)rootFo, (String)"classpath/compile");
            boolean isInitialCompilation = folder.equals(root);
            if (sourcePath == null || bootPath == null || compilePath == null) {
                ClassPath cp = this.getBootClassPaths(rootFo, "classpath/source");
                if (sourcePath == null) {
                    sourcePath = cp;
                }
                if (bootPath == null) {
                    bootPath = cp;
                }
                if (compilePath == null) {
                    compilePath = cp;
                }
            }
            boolean bl = isBoot = isInitialCompilation && this.isBoot(bootPath, rootFo);
            if (!isBoot && (urlString = root.toExternalForm()).indexOf("/vendor/") != -1) {
                isBoot = true;
            }
            try {
                ClasspathInfo cpInfo;
                FileObject jar;
                File rootFile = FileUtil.toFile((FileObject)rootFo);
                if (rootFile == null && (rootFile = FileUtil.toFile((FileObject)(jar = FileUtil.getArchiveFile((FileObject)rootFo)))) == null) {
                    return;
                }
                File folderFile = isInitialCompilation ? rootFile : FileUtil.normalizeFile((File)new File(URI.create(folder.toExternalForm())));
                Object filter = null;
                LinkedList<ParserFile> toCompile = new LinkedList<ParserFile>();
                Map resources = Collections.emptyMap();
                LazyFileList children = new LazyFileList(folderFile);
                boolean isRootFolder = isBoot;
                if (folderFile.getName().equals("vendor") || folderFile.getName().equals("lib")) {
                    isRootFolder = true;
                }
                boolean checkUpToDate = false;
                if (isRootFolder && folderFile.exists() && folderFile.canRead()) {
                    checkUpToDate = true;
                }
                boolean allUpToDate = checkUpToDate;
                HashMap<Language, Map<String, String>> timeStamps = new HashMap<Language, Map<String, String>>();
                boolean invalidIndex = false;
                String rootString = root.toExternalForm();
                for (IndexerEntry entry : RepositoryUpdater.getIndexers()) {
                    Map<String, String> ts;
                    Language language = entry.getLanguage();
                    if (!entry.indexer.acceptQueryPath(rootString)) continue;
                    ClassIndexImpl uqImpl = ClassIndexManager.get(language).createUsagesQuery(root, true);
                    assert (uqImpl != null);
                    SourceAnalyser sa = uqImpl.getSourceAnalyser();
                    assert (sa != null);
                    if (checkUpToDate && !sa.isUpToDate(null, folderFile.lastModified())) {
                        allUpToDate = false;
                        continue;
                    }
                    if (!isInitialCompilation) continue;
                    if (!sa.isValid()) {
                        invalidIndex = true;
                        allUpToDate = false;
                        continue;
                    }
                    ClassIndexImpl ci = ClassIndexManager.get(language).getUsagesQuery(root);
                    if (ci == null || (ts = ci.getTimeStamps()) == null || ts.size() <= 0) continue;
                    timeStamps.put(language, ts);
                }
                if (allUpToDate) {
                    return;
                }
                if (handle != null) {
                    String message = NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_Scannig", (Object)rootFile.getAbsolutePath());
                    handle.setDisplayName(message);
                    if (BUG_LOGGER.isLoggable(Level.FINE)) {
                        BUG_LOGGER.log(Level.FINE, RepositoryUpdater.getElapsedTime() + "CompilerWorker.updateFolder - updating handle " + handle + " to " + message + " + folderFile");
                    }
                }
                if (timeStamps.size() == 0) {
                    timeStamps = null;
                }
                ClassPath.Entry entry = null;
                if (!this.ignoreExcludes.contains(root)) {
                    entry = RepositoryUpdater.getClassPathEntry(sourcePath, root);
                    cpInfo = ClasspathInfoAccessor.getInstance().create(bootPath, compilePath, sourcePath, filter, true, false);
                } else {
                    cpInfo = ClasspathInfoAccessor.getInstance().create(bootPath, compilePath, sourcePath, filter, true, true);
                }
                Object removed = null;
                Set added = null;
                for (File child : children) {
                    List files;
                    String offset = FileObjects.getRelativePath(rootFile, child);
                    if (entry != null && !entry.includes(offset.replace(File.separatorChar, '/'))) continue;
                    if (invalidIndex || clean || this.dirtyCrossFiles.remove(child.toURI())) {
                        toCompile.add(FileObjects.fileFileObject(child, rootFile, isBoot, null));
                        continue;
                    }
                    int index = offset.lastIndexOf(46);
                    if (index > -1) {
                        offset = offset.substring(0, index);
                    }
                    if ((files = (List)resources.remove(offset)) == null) {
                        toCompile.add(FileObjects.fileFileObject(child, rootFile, isBoot, null));
                        continue;
                    }
                    if (((File)files.get(0)).lastModified() >= child.lastModified()) continue;
                    toCompile.add(FileObjects.fileFileObject(child, rootFile, isBoot, null));
                    for (File toDelete : files) {
                        toDelete.delete();
                    }
                }
                for (List files : resources.values()) {
                    for (File toDelete : files) {
                        toDelete.delete();
                        if (!toDelete.getName().endsWith("sig")) continue;
                    }
                }
                if (!toCompile.isEmpty()) {
                    if (handle != null) {
                        String path = rootFile.getAbsolutePath();
                        String message = NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_Analyzing", (Object)path);
                        if (BUG_LOGGER.isLoggable(Level.FINE)) {
                            BUG_LOGGER.log(Level.FINE, RepositoryUpdater.getElapsedTime() + "CompilerWorker.updateFolder2 - updating handle " + handle + " to " + message);
                        }
                        handle.setDisplayName(message);
                    }
                    CachingIndexer cachingIndexer = CachingIndexer.get(root, toCompile.size());
                    HashMap<Language, List<File>> seenTimestampedFiles = new HashMap<Language, List<File>>();
                    RepositoryUpdater.batchCompile(toCompile, rootFo, cpInfo, cachingIndexer, root, this.dirtyCrossFiles, added, timeStamps, seenTimestampedFiles);
                    if (timeStamps != null) {
                        this.deleteRemovedFiles(cachingIndexer, timeStamps, seenTimestampedFiles);
                    }
                    if (cachingIndexer != null) {
                        cachingIndexer.flush();
                    }
                }
            }
            finally {
                if (!clean && isInitialCompilation) {
                    RepositoryUpdater.this.scannedRoots.add(root);
                }
            }
        }

        private void deleteRemovedFiles(CachingIndexer cachingIndexer, Map<Language, Map<String, String>> timeStamps, Map<Language, List<File>> seenTimestampedFiles) {
            for (Language language : timeStamps.keySet()) {
                Map<String, String> stamps;
                int indexedCount;
                List<File> seen = seenTimestampedFiles.get(language);
                int seenCount = seen != null ? seen.size() : 0;
                if (seenCount == (indexedCount = (stamps = timeStamps.get(language)) != null ? stamps.keySet().size() : 0)) continue;
                int jarFileCount = 0;
                for (String url : stamps.keySet()) {
                    if (!url.startsWith("jar:")) continue;
                    ++jarFileCount;
                }
                if (seenCount + jarFileCount == indexedCount) continue;
                if (seenCount > indexedCount) {
                    LOGGER.warning("Unexpectedly encountered more timestamped files (" + seenCount + ") than indexed (" + indexedCount + ")");
                    if (seenCount < 50) {
                        LOGGER.warning(" Details: seen=" + seen + "; stamps=" + stamps);
                    }
                }
                HashSet<String> seenUrls = new HashSet<String>(2 * seenCount);
                if (seen != null) {
                    assert (stamps != null);
                    for (File f : seen) {
                        Indexer indexer = language.getIndexer();
                        assert (indexer != null);
                        String url = indexer.getPersistentUrl(f);
                        seenUrls.add(url);
                    }
                }
                HashSet<String> removed = new HashSet<String>(stamps.keySet());
                removed.removeAll(seenUrls);
                for (String url : removed) {
                    try {
                        if (url.startsWith("jar:")) continue;
                        cachingIndexer.remove(language, url);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }

        private List<Language> getApplicableIndexers(String mimeType) {
            List<Language> languages = null;
            for (Language language : LanguageRegistry.getInstance().getApplicableLanguages(mimeType)) {
                if (language.getIndexer() == null) continue;
                if (languages == null) {
                    languages = new ArrayList<Language>(5);
                }
                languages.add(language);
            }
            return languages != null ? languages : Collections.emptyList();
        }

        private void updateFile(URL file, URL root) throws IOException {
            FileObject fo = URLMapper.findFileObject((URL)file);
            if (fo == null) {
                return;
            }
            List<Language> languages = this.getApplicableIndexers(fo.getMIMEType());
            if (languages.size() > 0) {
                File rootFile = FileUtil.normalizeFile((File)new File(URI.create(root.toExternalForm())));
                File fileFile = FileUtil.toFile((FileObject)fo);
                ParserFile active = FileObjects.fileFileObject(fileFile, rootFile, false, null);
                ParserFile[] activeList = new ParserFile[]{active};
                ClasspathInfo cpInfo = ClasspathInfoAccessor.getInstance().create(fo, null, true, false);
                ClassPath.Entry entry = RepositoryUpdater.getClassPathEntry(cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), root);
                boolean scan = entry == null || entry.includes(fo);
                String rootString = root.toExternalForm();
                assert ("file".equals(root.getProtocol())) : "Unexpected protocol of URL: " + root;
                for (Language language : languages) {
                    ClassIndexImpl uqImpl;
                    if (language.getIndexer() != null && !language.getIndexer().acceptQueryPath(rootString) || (uqImpl = ClassIndexManager.get(language).createUsagesQuery(root, true)) == null) continue;
                    uqImpl.setDirty(null);
                    SourceAnalyser sa = uqImpl.getSourceAnalyser();
                    assert (sa != null);
                    if (!scan) continue;
                    CompilerListener listener = new CompilerListener();
                    ParserTaskImpl jt = SourceAccessor.getINSTANCE().createParserTask(language, cpInfo);
                    jt.setParseListener(listener);
                    Iterable<ParserResult> trees = jt.parse(activeList);
                    sa.analyse(language, trees);
                    listener.cleanDiagnostics();
                }
                GsfTaskProvider.refresh(fo);
            }
        }

        private void delete(URL file, URL root, boolean folder) throws IOException {
            assert ("file".equals(root.getProtocol())) : "Unexpected protocol of URL: " + root;
            File rootFile = FileUtil.normalizeFile((File)new File(URI.create(root.toExternalForm())));
            assert ("file".equals(file.getProtocol())) : "Unexpected protocol of URL: " + file;
            File fileFile = FileUtil.normalizeFile((File)new File(URI.create(file.toExternalForm())));
            String offset = FileObjects.getRelativePath(rootFile, fileFile);
            assert (offset != null && offset.length() > 0) : String.format("File %s not under root %s ", fileFile.getAbsolutePath(), rootFile.getAbsolutePath());
            boolean platform = false;
            ParserFile parserFile = FileObjects.fileFileObject(fileFile, rootFile, platform, null);
            for (Language language : LanguageRegistry.getInstance()) {
                if (language.getIndexer() == null || !language.getIndexer().acceptQueryPath(root.toExternalForm())) continue;
                ClassIndexImpl uqImpl = ClassIndexManager.get(language).createUsagesQuery(root, true);
                assert (uqImpl != null);
                SourceAnalyser sa = uqImpl.getSourceAnalyser();
                assert (sa != null);
                sa.delete(parserFile, language);
            }
        }

        private void updateBinary(URL file, URL root) throws IOException {
        }

        static /* synthetic */ Work access$000(CompileWorker x0) {
            return x0.work;
        }

        static /* synthetic */ void access$300(CompileWorker x0, URL x1, Stack x2, Map x3, Set x4, boolean x5) {
            x0.findDependencies(x1, x2, x3, x4, x5);
        }

        static /* synthetic */ List access$402(CompileWorker x0, List x1) {
            x0.state = x1;
            return x0.state;
        }

        static /* synthetic */ List access$400(CompileWorker x0) {
            return x0.state;
        }

        static /* synthetic */ ProgressHandle access$600(CompileWorker x0) {
            return x0.handle;
        }

        static /* synthetic */ void access$700(CompileWorker x0, URL x1, URL x2, boolean x3, ProgressHandle x4) throws IOException {
            x0.updateFolder(x1, x2, x3, x4);
        }

        static /* synthetic */ ProgressHandle access$602(CompileWorker x0, ProgressHandle x1) {
            x0.handle = x1;
            return x0.handle;
        }

        static /* synthetic */ Set access$802(CompileWorker x0, Set x1) {
            x0.oldRoots = x1;
            return x0.oldRoots;
        }

        static /* synthetic */ Set access$1002(CompileWorker x0, Set x1) {
            x0.oldBinaries = x1;
            return x0.oldBinaries;
        }

        static /* synthetic */ Set access$1502(CompileWorker x0, Set x1) {
            x0.newBinaries = x1;
            return x0.newBinaries;
        }

        static /* synthetic */ Set access$1000(CompileWorker x0) {
            return x0.oldBinaries;
        }

        static /* synthetic */ Set access$1500(CompileWorker x0) {
            return x0.newBinaries;
        }

        static /* synthetic */ boolean access$1900(CompileWorker x0) {
            return x0.scanRoots();
        }

        static /* synthetic */ Work access$002(CompileWorker x0, Work x1) {
            x0.work = x1;
            return x0.work;
        }

        static /* synthetic */ Set access$800(CompileWorker x0) {
            return x0.oldRoots;
        }

        static /* synthetic */ void access$2100(CompileWorker x0, URL x1, URL x2) throws IOException {
            x0.updateFile(x1, x2);
        }

        static /* synthetic */ void access$2200(CompileWorker x0, URL x1, URL x2, boolean x3) throws IOException {
            x0.delete(x1, x2, x3);
        }

        static /* synthetic */ void access$2300(CompileWorker x0, URL x1, URL x2) throws IOException {
            x0.updateBinary(x1, x2);
        }
    }

    private static class MultiRootsWork
    extends Work {
        private List<URL> roots;

        public MultiRootsWork(WorkType type, List<URL> roots, CountDownLatch latch) {
            super(type, latch);
            this.roots = roots;
        }

        public List<URL> getRoots() {
            return this.roots;
        }
    }

    private static class SingleRootWork
    extends Work {
        private URL file;
        private URL root;
        private boolean isFolder;

        public SingleRootWork(WorkType type, URL file, URL root, boolean isFolder, CountDownLatch latch) {
            super(type, latch);
            this.file = file;
            this.root = root;
            this.isFolder = isFolder;
        }

        public URL getFile() {
            return this.file;
        }

        public URL getRoot() {
            return this.root;
        }

        public boolean isFolder() {
            return this.isFolder;
        }
    }

    private static class Work {
        private final WorkType workType;
        private final CountDownLatch latch;

        protected Work(WorkType workType, CountDownLatch latch) {
            assert (workType != null);
            this.workType = workType;
            this.latch = latch;
        }

        public WorkType getType() {
            return this.workType;
        }

        public void finished() {
            if (this.latch != null) {
                this.latch.countDown();
            }
        }

        public static Work batch() {
            return new Work(WorkType.COMPILE_BATCH, null);
        }

        public static Work compile(FileObject file, URL root) throws FileStateInvalidException {
            return Work.compile(file.getURL(), root, file.isFolder());
        }

        public static Work compile(URL file, URL root, boolean isFolder) {
            assert (file != null && root != null);
            return new SingleRootWork(WorkType.COMPILE, file, root, isFolder, null);
        }

        public static Work compile(FileObject file, URL root, CountDownLatch[] latch) throws FileStateInvalidException {
            assert (file != null && root != null);
            assert (latch != null && latch.length == 1 && latch[0] == null);
            latch[0] = new CountDownLatch(1);
            return new SingleRootWork(WorkType.COMPILE, file.getURL(), root, file.isFolder(), latch[0]);
        }

        public static Work delete(FileObject file, URL root, boolean isFolder) throws FileStateInvalidException {
            return Work.delete(file.getURL(), root, file.isFolder());
        }

        public static Work delete(URL file, URL root, boolean isFolder) {
            assert (file != null && root != null);
            return new SingleRootWork(WorkType.DELETE, file, root, isFolder, null);
        }

        public static Work binary(FileObject file, URL root) throws FileStateInvalidException {
            return Work.binary(file.getURL(), root, file.isFolder());
        }

        public static Work binary(URL file, URL root, boolean isFolder) {
            assert (file != null && root != null);
            return new SingleRootWork(WorkType.UPDATE_BINARY, file, root, isFolder, null);
        }

        public static Work filterChange(List<URL> roots) {
            assert (roots != null);
            return new MultiRootsWork(WorkType.FILTER_CHANGED, roots, null);
        }
    }

    private static enum WorkType {
        COMPILE_BATCH,
        COMPILE_CONT,
        COMPILE,
        DELETE,
        UPDATE_BINARY,
        FILTER_CHANGED;

    }
}

