/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.usages;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.lucene.index.IndexReader;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.IndexDocument;
import org.netbeans.modules.gsf.api.Indexer;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsfpath.api.queries.SourceForBinaryQuery;
import org.netbeans.modules.gsfret.source.SourceAccessor;
import org.netbeans.modules.gsfret.source.usages.ClassIndexImpl;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.netbeans.modules.gsfret.source.usages.Index;
import org.netbeans.modules.gsfret.source.usages.LuceneIndex;
import org.netbeans.modules.gsfret.source.usages.SourceAnalyser;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class PersistentClassIndex
extends ClassIndexImpl {
    private final Index index;
    private final URL root;
    private final boolean isSource;
    private WeakReference<Source> dirty;
    private static final Logger LOGGER = Logger.getLogger(PersistentClassIndex.class.getName());
    private File cacheRoot;
    private Language language;

    private PersistentClassIndex(Language language, URL root, File cacheRoot, boolean source) throws IOException, IllegalArgumentException {
        assert (root != null);
        this.root = root;
        this.index = LuceneIndex.create(language, cacheRoot, this);
        this.isSource = source;
        this.language = language;
        this.cacheRoot = cacheRoot;
    }

    @Override
    public SourceAnalyser getSourceAnalyser() {
        return new SourceAnalyser(this.index);
    }

    @Override
    public FileObject[] getSourceRoots() {
        FileObject[] rootFos;
        if (this.isSource) {
            FileObject[] fileObjectArray;
            FileObject rootFo = URLMapper.findFileObject((URL)this.root);
            if (rootFo == null) {
                fileObjectArray = new FileObject[]{};
            } else {
                FileObject[] fileObjectArray2 = new FileObject[1];
                fileObjectArray = fileObjectArray2;
                fileObjectArray2[0] = rootFo;
            }
            rootFos = fileObjectArray;
        } else {
            rootFos = SourceForBinaryQuery.findSourceRoots((URL)this.root).getRoots();
        }
        return rootFos;
    }

    public static ClassIndexImpl create(Language language, URL root, File cacheRoot, boolean indexNow) throws IOException, IllegalArgumentException {
        return new PersistentClassIndex(language, root, cacheRoot, indexNow);
    }

    @Override
    public synchronized void setDirty(Source js) {
        if (js == null) {
            this.dirty = null;
        } else if (this.dirty == null || this.dirty.get() != js) {
            this.dirty = new WeakReference<Source>(js);
        }
    }

    public String toString() {
        return "CompromiseUQ[" + this.root.toExternalForm() + "]";
    }

    @Override
    protected final void close() throws IOException {
        this.index.close();
    }

    private Void runIndexers(CompilationInfo info) throws IOException {
        Indexer indexer = this.language.getIndexer();
        if (indexer == null) {
            return null;
        }
        SourceAnalyser sa = this.getSourceAnalyser();
        long st = System.currentTimeMillis();
        String mimeType = this.language.getMimeType();
        for (ParserResult parserResult : info.getEmbeddedResults(mimeType)) {
            assert (parserResult != null);
            if (!parserResult.isValid()) continue;
            sa.analyseUnitAndStore(indexer, parserResult);
        }
        long et = System.currentTimeMillis();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDirty() {
        Source js;
        WeakReference<Source> jsRef;
        PersistentClassIndex persistentClassIndex = this;
        synchronized (persistentClassIndex) {
            jsRef = this.dirty;
        }
        if (jsRef != null && (js = (Source)jsRef.get()) != null) {
            long startTime = System.currentTimeMillis();
            if (SourceAccessor.getINSTANCE().isDispatchThread()) {
                try {
                    ClassIndexManager.writeLock(new ClassIndexManager.ExceptionAction<Void>(){

                        @Override
                        public Void run() throws IOException {
                            CompilationInfo compilationInfo = SourceAccessor.getINSTANCE().getCurrentCompilationInfo(js, Phase.RESOLVED);
                            if (compilationInfo != null) {
                                return PersistentClassIndex.this.runIndexers(compilationInfo);
                            }
                            return null;
                        }
                    });
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            } else {
                try {
                    js.runUserActionTask(new CancellableTask<CompilationController>(){

                        public void run(final CompilationController controller) {
                            try {
                                ClassIndexManager.writeLock(new ClassIndexManager.ExceptionAction<Void>(){

                                    @Override
                                    public Void run() throws IOException {
                                        controller.toPhase(Phase.RESOLVED);
                                        return PersistentClassIndex.this.runIndexers(controller);
                                    }
                                });
                            }
                            catch (IOException ioe) {
                                Exceptions.printStackTrace((Throwable)ioe);
                            }
                        }

                        public void cancel() {
                        }
                    }, true);
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
            PersistentClassIndex ioe = this;
            synchronized (ioe) {
                this.dirty = null;
            }
            long endTime = System.currentTimeMillis();
            LOGGER.fine("PersistentClassIndex.updateDirty took: " + (endTime - startTime) + " ms");
        }
    }

    @Override
    public void search(final String primaryField, final String name, final NameKind kind, final Set<Index.SearchScope> scope, final Set<Index.SearchResult> result, final Set<String> terms) throws IOException {
        this.updateDirty();
        ClassIndexManager.readLock(new ClassIndexManager.ExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                PersistentClassIndex.this.index.search(primaryField, name, kind, scope, result, terms);
                return null;
            }
        });
    }

    @Override
    public Map<String, String> getTimeStamps() throws IOException {
        final Map[] mapHolder = new Map[1];
        ClassIndexManager.readLock(new ClassIndexManager.ExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                mapHolder[0] = PersistentClassIndex.this.index.getTimeStamps();
                return null;
            }
        });
        return mapHolder[0];
    }

    @Override
    public File getSegment() {
        return this.cacheRoot;
    }

    @Override
    public URL getRoot() {
        return this.root;
    }

    public IndexReader getDumpIndexReader() throws IOException {
        this.updateDirty();
        final IndexReader[] readerHolder = new IndexReader[1];
        ClassIndexManager.readLock(new ClassIndexManager.ExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                readerHolder[0] = ((LuceneIndex)PersistentClassIndex.this.index).getDumpIndexReader();
                return null;
            }
        });
        return readerHolder[0];
    }

    @Override
    public void storeEmpty() {
        List<IndexDocument> list = Collections.emptyList();
        try {
            this.index.store(null, list);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

