/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintsProvider;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.RuleContext;
import org.netbeans.modules.gsfret.hints.infrastructure.GsfHintsManager;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;

public final class GsfHintsProvider
implements CancellableTask<CompilationInfo> {
    public static ErrorManager ERR = ErrorManager.getDefault().getInstance("org.netbeans.modules.gsfret.hints");
    public static Logger LOG = Logger.getLogger("org.netbeans.modules.gsfret.hints");
    private FileObject file;
    private static final Map<org.netbeans.modules.gsf.api.Severity, Severity> errorKind2Severity = new EnumMap<org.netbeans.modules.gsf.api.Severity, Severity>(org.netbeans.modules.gsf.api.Severity.class);
    private boolean cancel;

    GsfHintsProvider(FileObject file) {
        this.file = file;
    }

    List<ErrorDescription> computeErrors(CompilationInfo info, Document doc, ParserResult result, List<Error> errors, List<ErrorDescription> descs) {
        if (ERR.isLoggable(1)) {
            ERR.log(1, "errors = " + errors);
        }
        for (Error d : errors) {
            int endPosition;
            int position;
            if (this.isCanceled()) {
                return null;
            }
            if (ERR.isLoggable(1)) {
                ERR.log(1, "d = " + d);
            }
            int astOffset = d.getStartPosition();
            int astEndOffset = d.getEndPosition();
            if (result.getTranslatedSource() != null) {
                position = result.getTranslatedSource().getLexicalOffset(astOffset);
                if (position == -1) continue;
                endPosition = position + (astEndOffset - astOffset);
            } else {
                position = astOffset;
                endPosition = astEndOffset;
            }
            LazyFixList ehm = ErrorDescriptionFactory.lazyListForFixes(Collections.emptyList());
            if (ERR.isLoggable(1)) {
                ERR.log(1, "ehm=" + ehm);
            }
            String desc = d.getDisplayName();
            Position[] range = this.getLine(info, d, doc, position, endPosition);
            if (this.isCanceled()) {
                return null;
            }
            if (range[0] == null || range[1] == null) continue;
            descs.add(ErrorDescriptionFactory.createErrorDescription((Severity)errorKind2Severity.get(d.getSeverity()), (String)desc, (LazyFixList)ehm, (Document)doc, (Position)range[0], (Position)range[1]));
        }
        if (this.isCanceled()) {
            return null;
        }
        return descs;
    }

    public Document getDocument() {
        return DataLoadersBridge.getDefault().getDocument(this.file);
    }

    private Position[] getLine(CompilationInfo info, Error d, final Document doc, int startOffset, int endOffset) {
        StyledDocument sdoc = (StyledDocument)doc;
        int lineNumber = NbDocument.findLineNumber((StyledDocument)sdoc, (int)startOffset);
        int lineOffset = NbDocument.findLineOffset((StyledDocument)sdoc, (int)lineNumber);
        String text = DataLoadersBridge.getDefault().getLine(doc, lineNumber);
        if (text == null) {
            return new Position[2];
        }
        boolean rangePrepared = false;
        if (!rangePrepared) {
            int column;
            int length = text.length();
            for (column = 0; column < text.length() && Character.isWhitespace(text.charAt(column)); ++column) {
            }
            while (length > 0 && Character.isWhitespace(text.charAt(length - 1))) {
                --length;
            }
            startOffset = lineOffset + column;
            endOffset = lineOffset + length;
            if (startOffset > endOffset) {
                startOffset = lineOffset;
            }
        }
        if (ERR.isLoggable(1)) {
            ERR.log(1, "startOffset = " + startOffset);
            ERR.log(1, "endOffset = " + endOffset);
        }
        final int startOffsetFinal = startOffset;
        final int endOffsetFinal = endOffset;
        final Position[] result = new Position[2];
        doc.render(new Runnable(){

            @Override
            public void run() {
                if (GsfHintsProvider.this.isCanceled()) {
                    return;
                }
                int len = doc.getLength();
                if (startOffsetFinal > len || endOffsetFinal > len) {
                    if (!GsfHintsProvider.this.isCanceled() && ERR.isLoggable(16)) {
                        ERR.log(16, "document changed, but not canceled?");
                        ERR.log(16, "len = " + len);
                        ERR.log(16, "startOffset = " + startOffsetFinal);
                        ERR.log(16, "endOffset = " + endOffsetFinal);
                    }
                    GsfHintsProvider.this.cancel();
                    return;
                }
                try {
                    result[0] = NbDocument.createPosition((Document)doc, (int)startOffsetFinal, (Position.Bias)Position.Bias.Forward);
                    result[1] = NbDocument.createPosition((Document)doc, (int)endOffsetFinal, (Position.Bias)Position.Bias.Backward);
                }
                catch (BadLocationException e) {
                    ERR.notify(65536, (Throwable)e);
                }
            }
        });
        return result;
    }

    synchronized boolean isCanceled() {
        return this.cancel;
    }

    public synchronized void cancel() {
        this.cancel = true;
    }

    synchronized void resume() {
        this.cancel = false;
    }

    public void run(CompilationInfo info) {
        this.resume();
        Document doc = this.getDocument();
        if (doc == null) {
            Logger.getLogger(GsfHintsProvider.class.getName()).log(Level.INFO, "SemanticHighlighter: Cannot get document!");
            return;
        }
        long start = System.currentTimeMillis();
        Set<String> mimeTypes = info.getEmbeddedMimeTypes();
        LanguageRegistry registry = LanguageRegistry.getInstance();
        ArrayList<ErrorDescription> descriptions = new ArrayList<ErrorDescription>();
        for (String mimeType : mimeTypes) {
            Language language = registry.getLanguageByMimeType(mimeType);
            HintsProvider provider = language.getHintsProvider();
            GsfHintsManager manager = null;
            RuleContext ruleContext = null;
            if (provider != null && ((manager = language.getHintsManager()) == null || (ruleContext = manager.createRuleContext(info, language, -1, -1, -1)) == null)) continue;
            for (ParserResult parserResult : info.getEmbeddedResults(mimeType)) {
                assert (parserResult != null);
                ArrayList errors = parserResult.getDiagnostics();
                List<ErrorDescription> desc = new ArrayList<ErrorDescription>();
                if (provider != null) {
                    assert (ruleContext != null);
                    ruleContext.parserResult = parserResult;
                    ArrayList unhandled = new ArrayList();
                    ArrayList hints = new ArrayList();
                    provider.computeErrors((HintsProvider.HintsManager)manager, ruleContext, hints, unhandled);
                    errors = unhandled;
                    boolean allowDisableEmpty = true;
                    for (Hint hint : hints) {
                        ErrorDescription errorDesc = manager.createDescription(hint, ruleContext, allowDisableEmpty);
                        descriptions.add(errorDesc);
                    }
                }
                if ((desc = this.computeErrors(info, doc, parserResult, errors, desc)) == null) {
                    return;
                }
                if (this.isCanceled()) {
                    return;
                }
                descriptions.addAll(desc);
            }
        }
        HintsController.setErrors((Document)doc, (String)"gsf-hints", descriptions);
        long end = System.currentTimeMillis();
    }

    static {
        errorKind2Severity.put(org.netbeans.modules.gsf.api.Severity.ERROR, Severity.ERROR);
        errorKind2Severity.put(org.netbeans.modules.gsf.api.Severity.WARNING, Severity.WARNING);
    }
}

