/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mode;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.h2.util.StringUtils;

public class FunctionsMySQL {
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String[] FORMAT_REPLACE = new String[]{"%a", "EEE", "%b", "MMM", "%c", "MM", "%d", "dd", "%e", "d", "%H", "HH", "%h", "hh", "%I", "hh", "%i", "mm", "%j", "DDD", "%k", "H", "%l", "h", "%M", "MMMM", "%m", "MM", "%p", "a", "%r", "hh:mm:ss a", "%S", "ss", "%s", "ss", "%T", "HH:mm:ss", "%W", "EEEE", "%w", "F", "%Y", "yyyy", "%y", "yy", "%%", "%"};

    public static void register(Connection connection) throws SQLException {
        String[] stringArray = new String[]{"UNIX_TIMESTAMP", "unixTimestamp", "FROM_UNIXTIME", "fromUnixTime", "DATE", "date"};
        Statement statement = connection.createStatement();
        for (int i = 0; i < stringArray.length; i += 2) {
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            statement.execute("CREATE ALIAS IF NOT EXISTS " + string + " FOR \"" + FunctionsMySQL.class.getName() + "." + string2 + "\"");
        }
    }

    public static int unixTimestamp() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static int unixTimestamp(Timestamp timestamp) throws SQLException {
        return (int)(timestamp.getTime() / 1000L);
    }

    public static String fromUnixTime(int n) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_TIME_FORMAT);
        return simpleDateFormat.format(new Date((long)n * 1000L));
    }

    public static String fromUnixTime(int n, String string) {
        string = FunctionsMySQL.convertToSimpleDateFormat(string);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(new Date((long)n * 1000L));
    }

    private static String convertToSimpleDateFormat(String string) {
        String[] stringArray = FORMAT_REPLACE;
        for (int i = 0; i < stringArray.length; i += 2) {
            string = StringUtils.replaceAll(string, stringArray[i], stringArray[i + 1]);
        }
        return string;
    }

    public static String date(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(32);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }
}

