/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import org.h2.command.Command;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.ObjectArray;
import org.h2.value.Value;

public class Insert
extends Prepared {
    private Table table;
    private Column[] columns;
    private ObjectArray list = new ObjectArray();
    private Query query;

    public Insert(Session session) {
        super(session);
    }

    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columnArray) {
        this.columns = columnArray;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void addRow(Expression[] expressionArray) {
        this.list.add(expressionArray);
    }

    public int update() throws SQLException {
        int n;
        this.session.getUser().checkRight(this.table, 4);
        this.setCurrentRowNumber(0);
        if (this.list.size() > 0) {
            n = 0;
            for (int i = 0; i < this.list.size(); ++i) {
                Expression[] expressionArray = (Expression[])this.list.get(i);
                Row row = this.table.getTemplateRow();
                this.setCurrentRowNumber(i + 1);
                for (int j = 0; j < this.columns.length; ++j) {
                    Column column = this.columns[j];
                    int n2 = column.getColumnId();
                    Expression expression = expressionArray[j];
                    if (expression == null) continue;
                    expression = expression.optimize(this.session);
                    Value value = expression.getValue(this.session).convertTo(column.getType());
                    row.setValue(n2, value);
                }
                this.checkCanceled();
                this.table.fireBefore(this.session);
                this.table.validateConvertUpdateSequence(this.session, row);
                this.table.fireBeforeRow(this.session, null, row);
                this.table.lock(this.session, true, false);
                this.table.addRow(this.session, row);
                this.session.log(this.table, (short)0, row);
                this.table.fireAfter(this.session);
                this.table.fireAfterRow(this.session, null, row);
                ++n;
            }
        } else {
            LocalResult localResult = this.query.query(0);
            n = 0;
            this.table.fireBefore(this.session);
            this.table.lock(this.session, true, false);
            while (localResult.next()) {
                this.checkCanceled();
                Value[] valueArray = localResult.currentRow();
                Row row = this.table.getTemplateRow();
                this.setCurrentRowNumber(++n);
                for (int i = 0; i < this.columns.length; ++i) {
                    Column column = this.columns[i];
                    int n3 = column.getColumnId();
                    Value value = valueArray[i].convertTo(column.getType());
                    row.setValue(n3, value);
                }
                this.table.validateConvertUpdateSequence(this.session, row);
                this.table.fireBeforeRow(this.session, null, row);
                this.table.addRow(this.session, row);
                this.session.log(this.table, (short)0, row);
                this.table.fireAfterRow(this.session, null, row);
            }
            localResult.close();
            this.table.fireAfter(this.session);
        }
        return n;
    }

    public String getPlanSQL() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(this.table.getSQL());
        stringBuffer.append('(');
        for (n = 0; n < this.columns.length; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.columns[n].getSQL());
        }
        stringBuffer.append(")\n");
        if (this.list.size() > 0) {
            stringBuffer.append("VALUES ");
            for (n = 0; n < this.list.size(); ++n) {
                Expression[] expressionArray = (Expression[])this.list.get(n);
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("(");
                for (int i = 0; i < this.columns.length; ++i) {
                    Expression expression;
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    if ((expression = expressionArray[i]) == null) {
                        stringBuffer.append("DEFAULT");
                        continue;
                    }
                    stringBuffer.append(expression.getSQL());
                }
                stringBuffer.append(')');
            }
        } else {
            stringBuffer.append(this.query.getPlanSQL());
        }
        return stringBuffer.toString();
    }

    public void prepare() throws SQLException {
        if (this.columns == null) {
            this.columns = this.list.size() > 0 && ((Expression[])this.list.get(0)).length == 0 ? new Column[0] : this.table.getColumns();
        }
        if (this.list.size() > 0) {
            for (int i = 0; i < this.list.size(); ++i) {
                Expression[] expressionArray = (Expression[])this.list.get(i);
                if (expressionArray.length != this.columns.length) {
                    throw Message.getSQLException(21002);
                }
                for (int j = 0; j < expressionArray.length; ++j) {
                    Expression expression = expressionArray[j];
                    if (expression == null) continue;
                    if ((expression = expression.optimize(this.session)) instanceof Parameter) {
                        Parameter parameter = (Parameter)expression;
                        parameter.setColumn(this.columns[j]);
                    }
                    expressionArray[j] = expression;
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw Message.getSQLException(21002);
            }
        }
    }

    public boolean isTransactional() {
        return true;
    }

    public LocalResult queryMeta() {
        return null;
    }
}

