/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.plan;

import java.util.List;
import java.util.Stack;
import org.apache.maven.lifecycle.LifecycleSpecificationException;
import org.apache.maven.lifecycle.MojoBindingUtils;
import org.apache.maven.lifecycle.model.MojoBinding;
import org.apache.maven.lifecycle.plan.BuildPlan;
import org.apache.maven.lifecycle.plan.LifecyclePlannerException;
import org.apache.maven.lifecycle.statemgmt.StateManagementUtils;

public final class BuildPlanUtils {
    private BuildPlanUtils() {
    }

    public static String listBuildPlan(BuildPlan plan, boolean extendedInfo) throws LifecycleSpecificationException, LifecyclePlannerException {
        List mojos = plan.renderExecutionPlan(new Stack());
        plan.resetExecutionProgress();
        return BuildPlanUtils.listBuildPlan(mojos, extendedInfo);
    }

    public static String listBuildPlan(List mojoBindings, boolean extendedInfo) throws LifecycleSpecificationException, LifecyclePlannerException {
        StringBuffer listing = new StringBuffer();
        int indentLevel = 0;
        int counter = 1;
        for (MojoBinding binding : mojoBindings) {
            if (StateManagementUtils.isForkedExecutionStartMarker(binding)) {
                BuildPlanUtils.newListingLine(listing, indentLevel, counter);
                listing.append("[fork start]");
                if (extendedInfo) {
                    listing.append(' ').append(BuildPlanUtils.formatMojoListing(binding, indentLevel, extendedInfo));
                }
                ++indentLevel;
            } else if (StateManagementUtils.isForkedExecutionClearMarker(binding)) {
                BuildPlanUtils.newListingLine(listing, --indentLevel, counter);
                listing.append("[fork cleanup]");
                if (extendedInfo) {
                    listing.append(' ').append(BuildPlanUtils.formatMojoListing(binding, indentLevel, extendedInfo));
                }
            } else if (StateManagementUtils.isForkedExecutionEndMarker(binding)) {
                BuildPlanUtils.newListingLine(listing, --indentLevel, counter);
                listing.append("[fork end]");
                if (extendedInfo) {
                    listing.append(' ').append(BuildPlanUtils.formatMojoListing(binding, indentLevel, extendedInfo));
                }
                ++indentLevel;
            } else {
                BuildPlanUtils.newListingLine(listing, indentLevel, counter);
                listing.append(BuildPlanUtils.formatMojoListing(binding, indentLevel, extendedInfo));
            }
            ++counter;
        }
        return listing.toString();
    }

    private static void newListingLine(StringBuffer listing, int indentLevel, int counter) {
        listing.append('\n');
        listing.append(counter).append(".");
        int i = 0;
        while (i < indentLevel) {
            listing.append("  ");
            ++i;
        }
        listing.append(' ');
    }

    public static String formatMojoListing(MojoBinding binding, int indentLevel, boolean extendedInfo) {
        StringBuffer listing = new StringBuffer();
        listing.append(MojoBindingUtils.toString(binding));
        listing.append(" [executionId: ").append(binding.getExecutionId()).append(", phase: ");
        if (binding.getPhase() != null && binding.getPhase().getName() != null) {
            listing.append(binding.getPhase().getName());
        } else {
            listing.append("None specified");
        }
        listing.append("]");
        if (extendedInfo) {
            listing.append("\nOrigin: ").append(binding.getOrigin());
            listing.append("\nOrigin Description: ").append(binding.getOriginDescription());
            listing.append("\nConfiguration:\n\t").append(String.valueOf(binding.getConfiguration()).replaceAll("\\n", "\n\t")).append('\n');
        }
        return listing.toString();
    }
}

