/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.ArtifactFilterManager;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExclusionSetFilter;

public class DefaultArtifactFilterManager
implements ArtifactFilterManager {
    private static final Set DEFAULT_EXCLUSIONS;
    private Set excludedArtifacts = new HashSet(DEFAULT_EXCLUSIONS);

    static {
        HashSet<String> artifacts = new HashSet<String>();
        artifacts.add("classworlds");
        artifacts.add("plexus-classworlds");
        artifacts.add("commons-cli");
        artifacts.add("doxia-sink-api");
        artifacts.add("jsch");
        artifacts.add("maven-artifact");
        artifacts.add("maven-artifact-manager");
        artifacts.add("maven-build-context");
        artifacts.add("maven-core");
        artifacts.add("maven-error-diagnoser");
        artifacts.add("maven-lifecycle");
        artifacts.add("maven-model");
        artifacts.add("maven-monitor");
        artifacts.add("maven-plugin-api");
        artifacts.add("maven-plugin-descriptor");
        artifacts.add("maven-plugin-parameter-documenter");
        artifacts.add("maven-profile");
        artifacts.add("maven-project");
        artifacts.add("maven-reporting-api");
        artifacts.add("maven-repository-metadata");
        artifacts.add("maven-settings");
        artifacts.add("maven-toolchain");
        artifacts.add("plexus-component-api");
        artifacts.add("plexus-container-default");
        artifacts.add("plexus-interactivity-api");
        artifacts.add("wagon-provider-api");
        artifacts.add("wagon-file");
        artifacts.add("wagon-http-lightweight");
        artifacts.add("wagon-manager");
        artifacts.add("wagon-ssh");
        artifacts.add("wagon-ssh-external");
        DEFAULT_EXCLUSIONS = artifacts;
    }

    public static ArtifactFilter createStandardFilter() {
        return new ExclusionSetFilter(DEFAULT_EXCLUSIONS);
    }

    public ArtifactFilter getArtifactFilter() {
        return new ExclusionSetFilter(this.excludedArtifacts);
    }

    public ArtifactFilter getCoreArtifactFilter() {
        return new ExclusionSetFilter(DEFAULT_EXCLUSIONS);
    }

    public void excludeArtifact(String artifactId) {
        this.excludedArtifacts.add(artifactId);
    }
}

