/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.svnclientadapter;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapter;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.svnkit.SvnKitClientAdapterFactory;

public class SvnClientAdapterFactory {
    private static final Logger LOG = Logger.getLogger("org.netbeans.libs.svnclientadapter");
    private static SvnClientAdapterFactory instance;
    private Client client;

    private SvnClientAdapterFactory() {
    }

    public static SvnClientAdapterFactory getInstance() {
        if (instance == null) {
            instance = new SvnClientAdapterFactory();
        }
        return instance;
    }

    private static boolean isSupportedJavahlVersion(String version) {
        boolean retval = false;
        if (version != null && ((version = version.toLowerCase()).startsWith("1.6") || version.contains("version 1.6"))) {
            retval = true;
        }
        return retval;
    }

    public boolean setup(Client c) throws SVNClientException {
        this.client = c;
        switch (c) {
            case javahl: {
                try {
                    JhlClientAdapterFactory.setup();
                }
                catch (Throwable t) {
                    String jhlErorrs = JhlClientAdapterFactory.getLibraryLoadErrors();
                    LOG.log(Level.INFO, t.getMessage());
                    LOG.log(Level.WARNING, "{0}\n", jhlErorrs);
                    return false;
                }
                return JhlClientAdapterFactory.isAvailable();
            }
            case svnkit: {
                SvnKitClientAdapterFactory.setup();
                return SvnKitClientAdapterFactory.isAvailable();
            }
        }
        return false;
    }

    public ISVNClientAdapter createClient() {
        switch (this.client) {
            case javahl: {
                return JhlClientAdapterFactory.createSVNClient("javahl");
            }
            case svnkit: {
                return SvnKitClientAdapterFactory.createSVNClient("svnkit");
            }
        }
        return null;
    }

    public boolean isSupportedJavahlVersion() {
        ISVNClientAdapter adapter;
        boolean retval = false;
        if (Client.javahl.equals((Object)this.client) && (adapter = JhlClientAdapterFactory.createSVNClient("javahl")) != null && adapter instanceof JhlClientAdapter) {
            JhlClientAdapter jhlAdapter = (JhlClientAdapter)adapter;
            String version = jhlAdapter.getNativeLibraryVersionString();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "isSupportedJavahlVersion: version {0}", version);
            }
            retval = SvnClientAdapterFactory.isSupportedJavahlVersion(version);
        }
        return retval;
    }

    public static enum Client {
        javahl,
        svnkit;

    }
}

