/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.provider.PersistenceProviderSupplier;
import org.netbeans.modules.web.project.WebProject;

public class WebPersistenceProviderSupplier
implements PersistenceProviderSupplier {
    private final WebProject project;

    public WebPersistenceProviderSupplier(WebProject webProject) {
        this.project = webProject;
    }

    public List<Provider> getSupportedProviders() {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(j2eeModuleProvider.getServerInstanceID());
        if (j2eePlatform == null) {
            return Collections.emptyList();
        }
        ArrayList<Provider> arrayList = new ArrayList<Provider>();
        this.addPersistenceProvider(ProviderUtil.HIBERNATE_PROVIDER, "hibernatePersistenceProviderIsDefault", j2eePlatform, arrayList);
        this.addPersistenceProvider(ProviderUtil.TOPLINK_PROVIDER, "toplinkPersistenceProviderIsDefault", j2eePlatform, arrayList);
        this.addPersistenceProvider(ProviderUtil.KODO_PROVIDER, "kodoPersistenceProviderIsDefault", j2eePlatform, arrayList);
        this.addPersistenceProvider(ProviderUtil.DATANUCLEUS_PROVIDER, "dataNucleusPersistenceProviderIsDefault", j2eePlatform, arrayList);
        this.addPersistenceProvider(ProviderUtil.OPENJPA_PROVIDER, "openJpaPersistenceProviderIsDefault", j2eePlatform, arrayList);
        this.addPersistenceProvider(ProviderUtil.ECLIPSELINK_PROVIDER, "eclipseLinkPersistenceProviderIsDefault", j2eePlatform, arrayList);
        return arrayList;
    }

    private void addPersistenceProvider(Provider provider, String string, J2eePlatform j2eePlatform, List<Provider> list) {
        if (j2eePlatform.isToolSupported(provider.getProviderClass())) {
            if (j2eePlatform.isToolSupported(string)) {
                list.add(0, provider);
            } else {
                list.add(provider);
            }
        }
    }

    public boolean supportsDefaultProvider() {
        J2eeProjectCapabilities j2eeProjectCapabilities = J2eeProjectCapabilities.forProject((Project)this.project);
        return j2eeProjectCapabilities != null && j2eeProjectCapabilities.hasDefaultPersistenceProvider();
    }
}

