/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.api.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.dataprovider.DataModelScheme;
import org.netbeans.modules.dlight.spi.dataprovider.DataProvider;
import org.netbeans.modules.dlight.spi.dataprovider.DataProviderFactory;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerDataProvider;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerDataProviderFactory;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class DataProvidersManager {
    private static final Logger log = DLightLogger.getLogger(DataProvidersManager.class);
    private static final DataProvidersManager instance = new DataProvidersManager();
    private final LookupListener lookupListener;
    private final Collection<VisualizerDataProviderFactory> allVisualizerDataProviders = new ArrayList<VisualizerDataProviderFactory>();
    private final Lookup.Result<VisualizerDataProviderFactory> lookupResult = Lookup.getDefault().lookupResult(VisualizerDataProviderFactory.class);
    private final Collection<VisualizerDataProvider> activeVisualizerDataProviders;

    private DataProvidersManager() {
        this.lookupListener = new LookupListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resultChanged(LookupEvent ev) {
                Collection collection = DataProvidersManager.this.allVisualizerDataProviders;
                synchronized (collection) {
                    Collection newSet = DataProvidersManager.this.lookupResult.allInstances();
                    DataProvidersManager.this.allVisualizerDataProviders.retainAll(newSet);
                    for (VisualizerDataProviderFactory f : newSet) {
                        Collection supportedSchemes;
                        if (DataProvidersManager.this.allVisualizerDataProviders.contains(f) || (supportedSchemes = f.getProvidedDataModelScheme()) == null) continue;
                        DataProvidersManager.this.allVisualizerDataProviders.add(f);
                        log.log(Level.FINE, "New VisualizerDataProvider factory registered for the following schemas: {0}", Arrays.toString(supportedSchemes.toArray(new DataModelScheme[0])));
                    }
                }
            }
        };
        this.lookupResult.addLookupListener(this.lookupListener);
        this.lookupListener.resultChanged(null);
        this.activeVisualizerDataProviders = new ArrayList<VisualizerDataProvider>();
    }

    public static DataProvidersManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisualizerDataProvider getDataProviderFor(DataModelScheme dataModel) {
        Collection<VisualizerDataProviderFactory> collection = this.allVisualizerDataProviders;
        synchronized (collection) {
            for (VisualizerDataProviderFactory providerFactory : this.allVisualizerDataProviders) {
                try {
                    if (!providerFactory.provides(dataModel)) continue;
                    VisualizerDataProvider newProvider = providerFactory.create();
                    this.activeVisualizerDataProviders.add(newProvider);
                    return newProvider;
                }
                catch (Throwable th) {
                    log.log(Level.FINE, "Exeption in getDataProviderFor " + dataModel, th);
                }
            }
        }
        return null;
    }

    public Collection<DataProviderFactory> getDataProviderFactories(DataModelScheme visDataModelScheme) {
        Collection factories = Lookup.getDefault().lookupAll(DataProviderFactory.class);
        ArrayList<DataProviderFactory> result = new ArrayList<DataProviderFactory>();
        for (DataProviderFactory factory : factories) {
            if (!factory.getProvidedDataModelScheme().contains(visDataModelScheme)) continue;
            result.add(factory);
        }
        return Collections.unmodifiableCollection(result);
    }

    public DataProvider createProvider(DataProviderFactory providerFactory) {
        DataProvider newProvider = providerFactory.create();
        this.activeVisualizerDataProviders.add((VisualizerDataProvider)newProvider);
        return newProvider;
    }
}

