/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spi;

import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.modules.java.hints.jackpot.impl.RulesManager;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.modules.java.hints.spi.TreeRule;
import org.netbeans.spi.editor.hints.Severity;

public abstract class AbstractHint
implements TreeRule {
    private boolean enableDefault;
    private boolean showInTaskListDefault;
    private HintSeverity severityDefault;
    private String[] suppressBy;

    public AbstractHint(boolean bl, boolean bl2, HintSeverity hintSeverity, String ... stringArray) {
        this.enableDefault = bl;
        this.showInTaskListDefault = bl2;
        this.severityDefault = hintSeverity;
        this.suppressBy = stringArray;
    }

    public Preferences getPreferences(String string) {
        return RulesManager.getPreferences(this.getId(), string);
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    public abstract String getDescription();

    public final boolean isEnabled() {
        return HintsSettings.isEnabled(this, this.getPreferences(HintsSettings.getCurrentProfileId()));
    }

    public final HintSeverity getSeverity() {
        return HintsSettings.getSeverity(this, this.getPreferences(HintsSettings.getCurrentProfileId()));
    }

    static {
        HintsSettings.HINTS_ACCESSOR = new HintAccessorImpl();
    }

    private static class HintAccessorImpl
    implements HintsSettings.HintsAccessor {
        private HintAccessorImpl() {
        }

        @Override
        public boolean isEnabledDefault(AbstractHint abstractHint) {
            return abstractHint.enableDefault;
        }

        @Override
        public boolean isShowInTaskListDefault(AbstractHint abstractHint) {
            return abstractHint.showInTaskListDefault;
        }

        @Override
        public HintSeverity severiryDefault(AbstractHint abstractHint) {
            return abstractHint.severityDefault;
        }

        @Override
        public String[] getSuppressBy(AbstractHint abstractHint) {
            return abstractHint.suppressBy;
        }
    }

    public static enum HintSeverity {
        ERROR,
        WARNING,
        CURRENT_LINE_WARNING;


        public Severity toEditorSeverity() {
            switch (this) {
                case ERROR: {
                    return Severity.ERROR;
                }
                case WARNING: {
                    return Severity.VERIFIER;
                }
                case CURRENT_LINE_WARNING: {
                    return Severity.HINT;
                }
            }
            return null;
        }
    }
}

