/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.spi;

import com.sun.source.tree.Tree;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.Parameters;

public final class HintDescription {
    private final HintMetadata metadata;
    private final Tree.Kind triggerKind;
    private final PatternDescription triggerPattern;
    private final Worker worker;

    private HintDescription(HintMetadata metadata, Tree.Kind triggerKind, PatternDescription triggerPattern, Worker worker) {
        this.metadata = metadata;
        this.triggerKind = triggerKind;
        this.triggerPattern = triggerPattern;
        this.worker = worker;
    }

    public Tree.Kind getTriggerKind() {
        return this.triggerKind;
    }

    public PatternDescription getTriggerPattern() {
        return this.triggerPattern;
    }

    public Worker getWorker() {
        return this.worker;
    }

    public HintMetadata getMetadata() {
        return this.metadata;
    }

    public Iterable<? extends String> getSuppressWarnings() {
        return this.metadata.suppressWarnings;
    }

    static HintDescription create(HintMetadata metadata, PatternDescription triggerPattern, Worker worker) {
        return new HintDescription(metadata, null, triggerPattern, worker);
    }

    static HintDescription create(HintMetadata metadata, Tree.Kind triggerKind, Worker worker) {
        return new HintDescription(metadata, triggerKind, null, worker);
    }

    public String toString() {
        return "[HintDescription:" + this.getTriggerPattern().getPattern() + "]";
    }

    public static interface Worker {
        public Collection<? extends ErrorDescription> createErrors(HintContext var1);
    }

    public static final class PatternDescription {
        private final String pattern;
        private final Map<String, String> constraints;
        private final Iterable<? extends String> imports;

        private PatternDescription(String pattern, Map<String, String> constraints, String ... imports) {
            this.pattern = pattern;
            this.constraints = constraints;
            this.imports = Arrays.asList(imports);
        }

        public static PatternDescription create(String pattern, Map<String, String> constraints, String ... imports) {
            Parameters.notNull((CharSequence)"pattern", (Object)pattern);
            Parameters.notNull((CharSequence)"constraints", constraints);
            Parameters.notNull((CharSequence)"imports", (Object)imports);
            return new PatternDescription(pattern, constraints, imports);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PatternDescription other = (PatternDescription)obj;
            if (this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern)) {
                return false;
            }
            return this.constraints == other.constraints || this.constraints != null && ((Object)this.constraints).equals(other.constraints);
        }

        public int hashCode() {
            int hash = 7;
            hash = 71 * hash + (this.pattern != null ? this.pattern.hashCode() : 0);
            hash = 71 * hash + (this.constraints != null ? ((Object)this.constraints).hashCode() : 0);
            return hash;
        }

        public String getPattern() {
            return this.pattern;
        }

        public Map<String, String> getConstraints() {
            return this.constraints;
        }

        public Iterable<? extends String> getImports() {
            return this.imports;
        }
    }
}

