/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.jackpot.impl.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;

public class CopyFinder
extends TreeScanner<Boolean, TreePath> {
    private final TreePath searchingFor;
    private final CompilationInfo info;
    private final Map<TreePath, VariableAssignments> result = new LinkedHashMap<TreePath, VariableAssignments>();
    private boolean allowGoDeeper = true;
    private Set<VariableElement> variablesWithAllowedRemap = Collections.emptySet();
    private State bindState = State.empty();
    private boolean allowVariablesRemap = false;
    private AtomicBoolean cancel;
    private Map<String, TypeMirror> designedTypeHack;
    private static final Set<TypeKind> IGNORE_KINDS = EnumSet.of(TypeKind.EXECUTABLE, TypeKind.PACKAGE, TypeKind.ERROR);
    private TreePath currentPath;

    private CopyFinder(TreePath treePath, CompilationInfo compilationInfo, AtomicBoolean atomicBoolean) {
        this.searchingFor = treePath;
        this.info = compilationInfo;
        this.cancel = atomicBoolean;
    }

    public static Map<TreePath, VariableAssignments> computeDuplicates(CompilationInfo compilationInfo, TreePath treePath, TreePath treePath2, AtomicBoolean atomicBoolean, Map<String, TypeMirror> map) {
        return CopyFinder.computeDuplicates(compilationInfo, treePath, treePath2, true, atomicBoolean, map);
    }

    public static Map<TreePath, VariableAssignments> computeDuplicates(final CompilationInfo compilationInfo, TreePath treePath, TreePath treePath2, boolean bl, AtomicBoolean atomicBoolean, Map<String, TypeMirror> map) {
        CopyFinder copyFinder = bl ? new CopyFinder(treePath, compilationInfo, atomicBoolean) : new CopyFinder(treePath, compilationInfo, atomicBoolean){

            @Override
            protected VerifyResult verifyElements(TreePath treePath, TreePath treePath2) {
                return CopyFinder.getSimpleName(treePath.getLeaf()).contentEquals(CopyFinder.getSimpleName(treePath2.getLeaf())) ? VerifyResult.MATCH : VerifyResult.NO_MATCH_CONTINUE;
            }

            @Override
            protected Iterable<? extends TreePath> prepareThis(TreePath treePath) {
                ExpressionTree expressionTree = compilationInfo.getTreeUtilities().parseExpression("this", new SourcePositions[1]);
                return Collections.singleton(new TreePath(treePath, expressionTree));
            }
        };
        copyFinder.designedTypeHack = map;
        copyFinder.scan(treePath2, null);
        return copyFinder.result;
    }

    public static VariableAssignments computeVariables(CompilationInfo compilationInfo, TreePath treePath, TreePath treePath2, AtomicBoolean atomicBoolean, Map<String, TypeMirror> map) {
        if (!CopyFinder.sameKind(treePath2.getLeaf(), treePath.getLeaf())) {
            return null;
        }
        CopyFinder copyFinder = new CopyFinder(treePath, compilationInfo, atomicBoolean);
        copyFinder.allowGoDeeper = false;
        copyFinder.designedTypeHack = map;
        if (copyFinder.scan(treePath2, treePath).booleanValue()) {
            return new VariableAssignments(copyFinder.bindState);
        }
        return null;
    }

    public static boolean isDuplicate(CompilationInfo compilationInfo, TreePath treePath, TreePath treePath2, AtomicBoolean atomicBoolean) {
        return CopyFinder.isDuplicate(compilationInfo, treePath, treePath2, true, atomicBoolean);
    }

    public static boolean isDuplicate(CompilationInfo compilationInfo, TreePath treePath, TreePath treePath2, boolean bl, AtomicBoolean atomicBoolean) {
        return CopyFinder.isDuplicate(compilationInfo, treePath, treePath2, bl, null, false, atomicBoolean);
    }

    public static boolean isDuplicate(final CompilationInfo compilationInfo, TreePath treePath, TreePath treePath2, boolean bl, HintContext hintContext, boolean bl2, AtomicBoolean atomicBoolean) {
        CopyFinder copyFinder;
        if (treePath.getLeaf().getKind() != treePath2.getLeaf().getKind()) {
            return false;
        }
        CopyFinder copyFinder2 = copyFinder = bl ? new CopyFinder(treePath, compilationInfo, atomicBoolean) : new CopyFinder(treePath, compilationInfo, atomicBoolean){

            @Override
            protected VerifyResult verifyElements(TreePath treePath, TreePath treePath2) {
                return CopyFinder.getSimpleName(treePath.getLeaf()).contentEquals(CopyFinder.getSimpleName(treePath2.getLeaf())) ? VerifyResult.MATCH : VerifyResult.NO_MATCH_CONTINUE;
            }

            @Override
            protected Iterable<? extends TreePath> prepareThis(TreePath treePath) {
                ExpressionTree expressionTree = compilationInfo.getTreeUtilities().parseExpression("this", new SourcePositions[1]);
                return Collections.singleton(new TreePath(treePath, expressionTree));
            }
        };
        if (hintContext != null) {
            if (bl2) {
                copyFinder.bindState = State.from(hintContext.getVariables(), hintContext.getMultiVariables(), hintContext.getVariableNames());
            } else {
                copyFinder.bindState.variables.putAll(hintContext.getVariables());
                copyFinder.bindState.variables2Names.putAll(hintContext.getVariableNames());
                copyFinder.bindState.multiVariables.putAll(hintContext.getMultiVariables());
            }
        }
        copyFinder.allowGoDeeper = false;
        return copyFinder.scan(treePath2, treePath);
    }

    public static Collection<? extends MethodDuplicateDescription> computeDuplicatesAndRemap(CompilationInfo compilationInfo, Collection<? extends TreePath> collection, TreePath treePath, Collection<VariableElement> collection2, AtomicBoolean atomicBoolean) {
        TreePath treePath2 = collection.iterator().next();
        boolean bl = StatementTree.class.isAssignableFrom(treePath2.getLeaf().getKind().asInterface());
        assert (bl || collection.size() == 1);
        LinkedList<MethodDuplicateDescription> linkedList = new LinkedList<MethodDuplicateDescription>();
        CopyFinder copyFinder = new CopyFinder(treePath2, compilationInfo, atomicBoolean);
        copyFinder.designedTypeHack = Collections.emptyMap();
        copyFinder.variablesWithAllowedRemap = new HashSet<VariableElement>(collection2);
        copyFinder.allowVariablesRemap = true;
        copyFinder.scan(treePath, null);
        block0: for (Map.Entry<TreePath, VariableAssignments> entry : copyFinder.result.entrySet()) {
            TreePath treePath3 = entry.getKey();
            if (!bl) {
                linkedList.add(new MethodDuplicateDescription(treePath3, -1, -1, entry.getValue().variablesRemapToElement, entry.getValue().variablesRemapToTrees));
                continue;
            }
            List<? extends StatementTree> list = CopyFinder.getStatements(treePath3);
            int n = list.indexOf(treePath3.getLeaf());
            if (n + collection.size() > list.size()) continue;
            int n2 = n;
            Iterator<? extends TreePath> iterator = collection.iterator();
            HashMap<Element, Element> hashMap = new HashMap<Element, Element>(entry.getValue().variablesRemapToElement);
            HashMap<Element, TreePath> hashMap2 = new HashMap<Element, TreePath>(entry.getValue().variablesRemapToTrees);
            iterator.next();
            while (iterator.hasNext()) {
                ++n2;
                TreePath treePath4 = iterator.next();
                CopyFinder copyFinder2 = new CopyFinder(treePath4, compilationInfo, atomicBoolean);
                copyFinder2.designedTypeHack = Collections.emptyMap();
                copyFinder2.allowGoDeeper = false;
                copyFinder2.variablesWithAllowedRemap = new HashSet<VariableElement>(collection2);
                copyFinder2.bindState = State.from(hashMap, hashMap2);
                copyFinder2.allowVariablesRemap = true;
                if (copyFinder2.scan(new TreePath(treePath3.getParentPath(), list.get(n2)), treePath4).booleanValue()) continue;
                continue block0;
            }
            linkedList.add(new MethodDuplicateDescription(treePath3, n, n2, entry.getValue().variablesRemapToElement, entry.getValue().variablesRemapToTrees));
        }
        return linkedList;
    }

    private static boolean sameKind(Tree tree, Tree tree2) {
        Tree.Kind kind;
        Tree.Kind kind2 = tree.getKind();
        if (kind2 == (kind = tree2.getKind())) {
            return true;
        }
        if (CopyFinder.isSingleStatemenBlockAndStatement(tree, tree2) || CopyFinder.isSingleStatemenBlockAndStatement(tree2, tree)) {
            return true;
        }
        if (kind == Tree.Kind.BLOCK && StatementTree.class.isAssignableFrom(kind2.asInterface())) {
            BlockTree blockTree = (BlockTree)tree2;
            if (blockTree.isStatic()) {
                return false;
            }
            switch (blockTree.getStatements().size()) {
                case 1: {
                    return true;
                }
                case 2: {
                    return Utilities.isMultistatementWildcardTree(blockTree.getStatements().get(0)) || Utilities.isMultistatementWildcardTree(blockTree.getStatements().get(1));
                }
                case 3: {
                    return Utilities.isMultistatementWildcardTree(blockTree.getStatements().get(0)) || Utilities.isMultistatementWildcardTree(blockTree.getStatements().get(2));
                }
            }
            return false;
        }
        if (kind2 != Tree.Kind.MEMBER_SELECT && kind2 != Tree.Kind.IDENTIFIER || kind != Tree.Kind.MEMBER_SELECT && kind != Tree.Kind.IDENTIFIER) {
            return false;
        }
        return Utilities.isPureMemberSelect(tree, true) && Utilities.isPureMemberSelect(tree2, true);
    }

    private static boolean isSingleStatemenBlockAndStatement(Tree tree, Tree tree2) {
        Tree.Kind kind = tree.getKind();
        Tree.Kind kind2 = tree2.getKind();
        if (kind == Tree.Kind.BLOCK && ((BlockTree)tree).getStatements().size() == 1 && !((BlockTree)tree).isStatic()) {
            return StatementTree.class.isAssignableFrom(kind2.asInterface());
        }
        return false;
    }

    protected TreePath getCurrentPath() {
        return this.currentPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean scan(TreePath treePath, TreePath treePath2) {
        this.currentPath = treePath.getParentPath();
        try {
            Boolean bl = this.scan(treePath.getLeaf(), treePath2);
            return bl;
        }
        finally {
            this.currentPath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean scan(Tree tree, TreePath treePath) {
        Object object;
        String string;
        if (this.cancel.get()) {
            return false;
        }
        if (tree == null) {
            return treePath == null;
        }
        if (treePath != null && treePath.getLeaf().getKind() == Tree.Kind.IDENTIFIER) {
            string = ((IdentifierTree)treePath.getLeaf()).getName().toString();
            if (string.startsWith("$")) {
                Object object2;
                if (this.bindState.variables2Names.containsKey(string)) {
                    if (tree.getKind() == Tree.Kind.IDENTIFIER) {
                        return ((IdentifierTree)tree).getName().toString().equals(this.bindState.variables2Names.get(string));
                    }
                    return false;
                }
                TreePath treePath2 = new TreePath(this.getCurrentPath(), tree);
                TypeMirror typeMirror = this.designedTypeHack != null ? this.designedTypeHack.get(string) : null;
                boolean bl = true;
                if (typeMirror != null && typeMirror.getKind() != TypeKind.ERROR) {
                    object2 = this.info.getTrees().getTypeMirror(treePath2);
                    bl = object2 != null && !IGNORE_KINDS.contains((Object)object2.getKind()) ? this.info.getTypes().isAssignable((TypeMirror)object2, typeMirror) : false;
                }
                if (bl) {
                    object2 = this.bindState.variables.get(string);
                    if (object2 == null) {
                        this.bindState.variables.put(string, treePath2);
                        return true;
                    }
                    boolean bl2 = this.allowGoDeeper;
                    try {
                        Boolean bl3 = this.scan(tree, (TreePath)object2);
                        return bl3;
                    }
                    finally {
                        this.allowGoDeeper = bl2;
                    }
                }
                return false;
            }
            object = this.info.getTrees().getElement(treePath);
            if (this.variablesWithAllowedRemap.contains(object)) {
                TreePath treePath3 = this.bindState.variablesRemapToTrees.get(object);
                if (treePath3 != null) {
                    boolean bl = this.allowGoDeeper;
                    try {
                        this.allowGoDeeper = false;
                        Boolean bl4 = this.superScan(tree, treePath3);
                        return bl4;
                    }
                    finally {
                        this.allowGoDeeper = bl;
                    }
                }
                TreePath treePath4 = new TreePath(this.getCurrentPath(), tree);
                TypeMirror typeMirror = this.info.getTrees().getTypeMirror(treePath4);
                TypeMirror typeMirror2 = ((VariableElement)object).asType();
                if (typeMirror != null && typeMirror2 != null && this.isSameTypeForVariableRemap(typeMirror, typeMirror2)) {
                    this.bindState.variablesRemapToTrees.put((Element)object, treePath4);
                    return true;
                }
                return false;
            }
        }
        if (treePath != null && Utilities.getWildcardTreeName(treePath.getLeaf()) != null && (string = ((Object)Utilities.getWildcardTreeName(treePath.getLeaf())).toString()).startsWith("$") && StatementTree.class.isAssignableFrom(tree.getKind().asInterface())) {
            object = this.bindState.variables.get(string);
            if (object == null) {
                TreePath treePath5 = new TreePath(this.getCurrentPath(), tree);
                this.bindState.variables.put(string, treePath5);
                return true;
            }
            boolean bl = this.allowGoDeeper;
            try {
                Boolean bl5 = this.scan(tree, (TreePath)object);
                return bl5;
            }
            finally {
                this.allowGoDeeper = bl;
            }
        }
        if (treePath != null && CopyFinder.sameKind(tree, treePath.getLeaf())) {
            boolean bl;
            boolean bl6 = bl = this.superScan(tree, treePath) == Boolean.TRUE;
            if (bl) {
                if (treePath == this.searchingFor && tree != this.searchingFor && this.allowGoDeeper) {
                    this.result.put(new TreePath(this.getCurrentPath(), tree), new VariableAssignments(this.bindState));
                    this.bindState = State.empty();
                }
                return true;
            }
        }
        if (!this.allowGoDeeper) {
            return false;
        }
        if (treePath != null && treePath.getLeaf() == this.searchingFor.getLeaf() || !CopyFinder.sameKind(tree, this.searchingFor.getLeaf())) {
            if (this.bindState.multiVariables.isEmpty() || this.bindState.variables.isEmpty() || this.bindState.variables2Names.isEmpty() || this.bindState.variablesRemapToElement.isEmpty() || this.bindState.variablesRemapToTrees.isEmpty()) {
                this.bindState = State.empty();
            }
            this.superScan(tree, null);
            return false;
        }
        this.allowGoDeeper = false;
        boolean bl = this.superScan(tree, this.searchingFor) == Boolean.TRUE;
        this.allowGoDeeper = true;
        if (bl) {
            if (tree != this.searchingFor.getLeaf()) {
                this.result.put(new TreePath(this.getCurrentPath(), tree), new VariableAssignments(this.bindState));
                this.bindState = State.empty();
            }
            return true;
        }
        this.superScan(tree, null);
        return false;
    }

    private Boolean superScan(Tree tree, TreePath treePath) {
        Object object;
        if (treePath == null) {
            return this.doSuperScan(tree, treePath);
        }
        if (treePath.getLeaf().getKind() == Tree.Kind.IDENTIFIER && ((String)(object = ((IdentifierTree)treePath.getLeaf()).getName().toString())).startsWith("$")) {
            return this.scan(tree, treePath);
        }
        if (treePath.getLeaf().getKind() == Tree.Kind.BLOCK && tree.getKind() != Tree.Kind.BLOCK) {
            object = (BlockTree)treePath.getLeaf();
            switch (object.getStatements().size()) {
                case 1: {
                    if (Utilities.isMultistatementWildcardTree(object.getStatements().get(0))) {
                        if (!this.validateMultiVariable(object.getStatements().get(0), Collections.singletonList(new TreePath(this.getCurrentPath(), tree)))) {
                            return false;
                        }
                        return true;
                    }
                    treePath = new TreePath(treePath, object.getStatements().get(0));
                    break;
                }
                case 2: {
                    if (Utilities.isMultistatementWildcardTree(object.getStatements().get(0))) {
                        if (!this.validateMultiVariable(object.getStatements().get(0), Collections.emptyList())) {
                            return false;
                        }
                        treePath = new TreePath(treePath, object.getStatements().get(1));
                        break;
                    }
                    if (Utilities.isMultistatementWildcardTree(object.getStatements().get(1))) {
                        if (!this.validateMultiVariable(object.getStatements().get(1), Collections.emptyList())) {
                            return false;
                        }
                        treePath = new TreePath(treePath, object.getStatements().get(0));
                        break;
                    }
                    throw new UnsupportedOperationException();
                }
                case 3: {
                    if (Utilities.isMultistatementWildcardTree(object.getStatements().get(0)) && Utilities.isMultistatementWildcardTree(object.getStatements().get(2))) {
                        if (!this.validateMultiVariable(object.getStatements().get(0), Collections.emptyList())) {
                            return false;
                        }
                        if (!this.validateMultiVariable(object.getStatements().get(2), Collections.emptyList())) {
                            return false;
                        }
                        treePath = new TreePath(treePath, object.getStatements().get(1));
                        break;
                    }
                    throw new UnsupportedOperationException();
                }
            }
        }
        if (!CopyFinder.sameKind(tree, treePath.getLeaf())) {
            return false;
        }
        return this.doSuperScan(tree, treePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean doSuperScan(Tree tree, TreePath treePath) {
        if (tree == null) {
            return null;
        }
        TreePath treePath2 = this.currentPath;
        try {
            this.currentPath = new TreePath(this.currentPath, tree);
            Boolean bl = (Boolean)super.scan(tree, treePath);
            return bl;
        }
        finally {
            this.currentPath = treePath2;
        }
    }

    private Boolean scan(Tree tree, Tree tree2, TreePath treePath) {
        if (tree == null || tree2 == null) {
            return tree == tree2;
        }
        return this.scan(tree, new TreePath(treePath, tree2));
    }

    @Override
    public Boolean visitMethodInvocation(MethodInvocationTree methodInvocationTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitMethodInvocation(methodInvocationTree, treePath);
        }
        MethodInvocationTree methodInvocationTree2 = (MethodInvocationTree)treePath.getLeaf();
        if (!this.scan(methodInvocationTree.getMethodSelect(), methodInvocationTree2.getMethodSelect(), treePath).booleanValue()) {
            return false;
        }
        if (!this.checkLists(methodInvocationTree.getTypeArguments(), methodInvocationTree2.getTypeArguments(), treePath)) {
            return false;
        }
        return this.checkLists(methodInvocationTree.getArguments(), methodInvocationTree2.getArguments(), treePath);
    }

    private <T extends Tree> boolean checkLists(List<? extends T> list, List<? extends T> list2, TreePath treePath) {
        if (list == null || list2 == null) {
            return list == list2;
        }
        if (Utilities.containsMultistatementTrees(list2)) {
            return this.checkListsWithMultistatementTrees(list, 0, list2, 0, treePath);
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (this.scan((Tree)list.get(i), (Tree)list2.get(i), treePath).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitAssert(AssertTree assertTree, TreePath treePath) {
        if (treePath == null) {
            super.visitAssert(assertTree, treePath);
            return false;
        }
        AssertTree assertTree2 = (AssertTree)treePath.getLeaf();
        if (!this.scan(assertTree.getCondition(), assertTree2.getCondition(), treePath).booleanValue()) {
            return false;
        }
        return this.scan(assertTree.getDetail(), assertTree2.getDetail(), treePath);
    }

    @Override
    public Boolean visitAssignment(AssignmentTree assignmentTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitAssignment(assignmentTree, treePath);
        }
        AssignmentTree assignmentTree2 = (AssignmentTree)treePath.getLeaf();
        boolean bl = this.scan(assignmentTree.getExpression(), assignmentTree2.getExpression(), treePath);
        return bl && this.scan(assignmentTree.getVariable(), assignmentTree2.getVariable(), treePath) != false;
    }

    @Override
    public Boolean visitCompoundAssignment(CompoundAssignmentTree compoundAssignmentTree, TreePath treePath) {
        if (treePath == null) {
            super.visitCompoundAssignment(compoundAssignmentTree, treePath);
            return false;
        }
        CompoundAssignmentTree compoundAssignmentTree2 = (CompoundAssignmentTree)treePath.getLeaf();
        boolean bl = this.scan(compoundAssignmentTree.getExpression(), compoundAssignmentTree2.getExpression(), treePath);
        return bl && this.scan(compoundAssignmentTree.getVariable(), compoundAssignmentTree2.getVariable(), treePath) != false;
    }

    @Override
    public Boolean visitBinary(BinaryTree binaryTree, TreePath treePath) {
        if (treePath == null) {
            super.visitBinary(binaryTree, treePath);
            return false;
        }
        BinaryTree binaryTree2 = (BinaryTree)treePath.getLeaf();
        boolean bl = this.scan(binaryTree.getLeftOperand(), binaryTree2.getLeftOperand(), treePath);
        return bl && this.scan(binaryTree.getRightOperand(), binaryTree2.getRightOperand(), treePath) != false;
    }

    private boolean validateMultiVariable(Tree tree, List<? extends TreePath> list) {
        String string = ((Object)Utilities.getWildcardTreeName(tree)).toString();
        Collection<? extends TreePath> collection = this.bindState.multiVariables.get(string);
        if (collection == null) {
            this.bindState.multiVariables.put(string, list);
            return true;
        }
        if (list.size() != collection.size()) {
            return false;
        }
        Iterator<? extends TreePath> iterator = collection.iterator();
        Iterator<? extends TreePath> iterator2 = list.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (this.scan(iterator2.next(), iterator.next()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean checkListsWithMultistatementTrees(List<? extends Tree> list, int n, List<? extends Tree> list2, int n2, TreePath treePath) {
        while (n < list.size() && n2 < list2.size() && !Utilities.isMultistatementWildcardTree(list2.get(n2))) {
            if (!this.scan(list.get(n), list2.get(n2), treePath).booleanValue()) {
                return false;
            }
            ++n;
            ++n2;
        }
        if (n == list.size() && n2 == list2.size()) {
            return true;
        }
        if (Utilities.isMultistatementWildcardTree(list2.get(n2))) {
            if (n2 + 1 == list2.size()) {
                LinkedList<TreePath> linkedList = new LinkedList<TreePath>();
                for (Tree tree : list.subList(n, list.size())) {
                    linkedList.add(new TreePath(this.getCurrentPath(), tree));
                }
                return this.validateMultiVariable(list2.get(n2), linkedList);
            }
            LinkedList<TreePath> linkedList = new LinkedList<TreePath>();
            while (n < list.size()) {
                State state = State.copyOf(this.bindState);
                if (this.checkListsWithMultistatementTrees(list, n, list2, n2 + 1, treePath)) {
                    return this.validateMultiVariable(list2.get(n2), linkedList);
                }
                this.bindState = state;
                linkedList.add(new TreePath(this.getCurrentPath(), list.get(n)));
                ++n;
            }
            return false;
        }
        return false;
    }

    @Override
    public Boolean visitBlock(BlockTree blockTree, TreePath treePath) {
        if (treePath == null) {
            super.visitBlock(blockTree, treePath);
            return false;
        }
        if (treePath.getLeaf().getKind() != Tree.Kind.BLOCK) {
            assert (blockTree.getStatements().size() == 1);
            assert (!blockTree.isStatic());
            if (treePath.getLeaf() == this.searchingFor.getLeaf()) {
                return false;
            }
            return this.checkLists(blockTree.getStatements(), Collections.singletonList(treePath.getLeaf()), treePath.getParentPath());
        }
        BlockTree blockTree2 = (BlockTree)treePath.getLeaf();
        if (blockTree.isStatic() != blockTree2.isStatic()) {
            return false;
        }
        return this.checkLists(blockTree.getStatements(), blockTree2.getStatements(), treePath);
    }

    @Override
    public Boolean visitCatch(CatchTree catchTree, TreePath treePath) {
        if (treePath == null) {
            super.visitCatch(catchTree, treePath);
            return false;
        }
        CatchTree catchTree2 = (CatchTree)treePath.getLeaf();
        if (!this.scan(catchTree.getParameter(), catchTree2.getParameter(), treePath).booleanValue()) {
            return false;
        }
        return this.scan(catchTree.getBlock(), catchTree2.getBlock(), treePath);
    }

    @Override
    public Boolean visitConditionalExpression(ConditionalExpressionTree conditionalExpressionTree, TreePath treePath) {
        if (treePath == null) {
            super.visitConditionalExpression(conditionalExpressionTree, treePath);
            return false;
        }
        ConditionalExpressionTree conditionalExpressionTree2 = (ConditionalExpressionTree)treePath.getLeaf();
        if (!this.scan(conditionalExpressionTree.getCondition(), conditionalExpressionTree2.getCondition(), treePath).booleanValue()) {
            return false;
        }
        if (!this.scan(conditionalExpressionTree.getFalseExpression(), conditionalExpressionTree2.getFalseExpression(), treePath).booleanValue()) {
            return false;
        }
        return this.scan(conditionalExpressionTree.getTrueExpression(), conditionalExpressionTree2.getTrueExpression(), treePath);
    }

    @Override
    public Boolean visitDoWhileLoop(DoWhileLoopTree doWhileLoopTree, TreePath treePath) {
        if (treePath == null) {
            super.visitDoWhileLoop(doWhileLoopTree, treePath);
            return false;
        }
        DoWhileLoopTree doWhileLoopTree2 = (DoWhileLoopTree)treePath.getLeaf();
        if (!this.scan(doWhileLoopTree.getStatement(), doWhileLoopTree2.getStatement(), treePath).booleanValue()) {
            return false;
        }
        return this.scan(doWhileLoopTree.getCondition(), doWhileLoopTree2.getCondition(), treePath);
    }

    @Override
    public Boolean visitExpressionStatement(ExpressionStatementTree expressionStatementTree, TreePath treePath) {
        if (treePath == null) {
            super.visitExpressionStatement(expressionStatementTree, treePath);
            return false;
        }
        ExpressionStatementTree expressionStatementTree2 = (ExpressionStatementTree)treePath.getLeaf();
        return this.scan(expressionStatementTree.getExpression(), expressionStatementTree2.getExpression(), treePath);
    }

    @Override
    public Boolean visitEnhancedForLoop(EnhancedForLoopTree enhancedForLoopTree, TreePath treePath) {
        if (treePath == null) {
            super.visitEnhancedForLoop(enhancedForLoopTree, treePath);
            return false;
        }
        EnhancedForLoopTree enhancedForLoopTree2 = (EnhancedForLoopTree)treePath.getLeaf();
        if (!this.scan(enhancedForLoopTree.getVariable(), enhancedForLoopTree2.getVariable(), treePath).booleanValue()) {
            return false;
        }
        if (!this.scan(enhancedForLoopTree.getExpression(), enhancedForLoopTree2.getExpression(), treePath).booleanValue()) {
            return false;
        }
        return this.scan(enhancedForLoopTree.getStatement(), enhancedForLoopTree2.getStatement(), treePath);
    }

    @Override
    public Boolean visitForLoop(ForLoopTree forLoopTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitForLoop(forLoopTree, treePath);
        }
        ForLoopTree forLoopTree2 = (ForLoopTree)treePath.getLeaf();
        if (!this.checkLists(forLoopTree.getInitializer(), forLoopTree2.getInitializer(), treePath)) {
            return false;
        }
        if (!this.scan(forLoopTree.getCondition(), forLoopTree2.getCondition(), treePath).booleanValue()) {
            return false;
        }
        if (!this.checkLists(forLoopTree.getUpdate(), forLoopTree2.getUpdate(), treePath)) {
            return false;
        }
        return this.scan(forLoopTree.getStatement(), forLoopTree2.getStatement(), treePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean visitIdentifier(IdentifierTree identifierTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitIdentifier(identifierTree, treePath);
        }
        switch (this.verifyElements(this.getCurrentPath(), treePath)) {
            case MATCH_CHECK_DEEPER: {
                if (identifierTree.getKind() == treePath.getLeaf().getKind()) {
                    return true;
                }
                for (TreePath treePath2 : this.prepareThis(this.getCurrentPath())) {
                    State state = State.copyOf(this.bindState);
                    try {
                        MemberSelectTree memberSelectTree = (MemberSelectTree)treePath.getLeaf();
                        if (this.scan(treePath2.getLeaf(), memberSelectTree.getExpression(), treePath) != Boolean.TRUE) continue;
                        Boolean bl = true;
                        return bl;
                    }
                    finally {
                        this.bindState = state;
                    }
                }
                return false;
            }
            case MATCH: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Boolean visitIf(IfTree ifTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitIf(ifTree, treePath);
        }
        IfTree ifTree2 = (IfTree)treePath.getLeaf();
        if (!this.scan(ifTree.getCondition(), ifTree2.getCondition(), treePath).booleanValue()) {
            return false;
        }
        if (!this.scan(ifTree.getThenStatement(), ifTree2.getThenStatement(), treePath).booleanValue()) {
            return false;
        }
        return this.scan(ifTree.getElseStatement(), ifTree2.getElseStatement(), treePath);
    }

    @Override
    public Boolean visitArrayAccess(ArrayAccessTree arrayAccessTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitArrayAccess(arrayAccessTree, treePath);
        }
        ArrayAccessTree arrayAccessTree2 = (ArrayAccessTree)treePath.getLeaf();
        if (!this.scan(arrayAccessTree.getExpression(), arrayAccessTree2.getExpression(), treePath).booleanValue()) {
            return false;
        }
        return this.scan(arrayAccessTree.getIndex(), arrayAccessTree2.getIndex(), treePath);
    }

    @Override
    public Boolean visitLiteral(LiteralTree literalTree, TreePath treePath) {
        Object object;
        if (treePath == null) {
            return (Boolean)super.visitLiteral(literalTree, treePath);
        }
        LiteralTree literalTree2 = (LiteralTree)treePath.getLeaf();
        Object object2 = literalTree.getValue();
        if (object2 == (object = literalTree2.getValue())) {
            return true;
        }
        if (object2 == null || object == null) {
            return false;
        }
        return object2.equals(object);
    }

    @Override
    public Boolean visitModifiers(ModifiersTree modifiersTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitModifiers(modifiersTree, treePath);
        }
        ModifiersTree modifiersTree2 = (ModifiersTree)treePath.getLeaf();
        if (!this.checkLists(modifiersTree.getAnnotations(), modifiersTree2.getAnnotations(), treePath)) {
            return false;
        }
        return ((Object)modifiersTree.getFlags()).equals(modifiersTree2.getFlags());
    }

    @Override
    public Boolean visitNewArray(NewArrayTree newArrayTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitNewArray(newArrayTree, treePath);
        }
        NewArrayTree newArrayTree2 = (NewArrayTree)treePath.getLeaf();
        if (!this.checkLists(newArrayTree.getDimensions(), newArrayTree2.getDimensions(), treePath)) {
            return false;
        }
        if (!this.checkLists(newArrayTree.getInitializers(), newArrayTree2.getInitializers(), treePath)) {
            return false;
        }
        return this.scan(newArrayTree.getType(), newArrayTree2.getType(), treePath);
    }

    @Override
    public Boolean visitNewClass(NewClassTree newClassTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitNewClass(newClassTree, treePath);
        }
        NewClassTree newClassTree2 = (NewClassTree)treePath.getLeaf();
        if (!this.scan(newClassTree.getIdentifier(), newClassTree2.getIdentifier(), treePath).booleanValue()) {
            return false;
        }
        if (!this.scan(newClassTree.getEnclosingExpression(), newClassTree2.getEnclosingExpression(), treePath).booleanValue()) {
            return false;
        }
        if (!this.checkLists(newClassTree.getTypeArguments(), newClassTree2.getTypeArguments(), treePath)) {
            return false;
        }
        if (!this.checkLists(newClassTree.getArguments(), newClassTree2.getArguments(), treePath)) {
            return false;
        }
        return this.scan(newClassTree.getClassBody(), newClassTree2.getClassBody(), treePath);
    }

    @Override
    public Boolean visitParenthesized(ParenthesizedTree parenthesizedTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitParenthesized(parenthesizedTree, treePath);
        }
        ParenthesizedTree parenthesizedTree2 = (ParenthesizedTree)treePath.getLeaf();
        return this.scan(parenthesizedTree.getExpression(), parenthesizedTree2.getExpression(), treePath);
    }

    @Override
    public Boolean visitReturn(ReturnTree returnTree, TreePath treePath) {
        if (treePath == null) {
            super.visitReturn(returnTree, treePath);
            return false;
        }
        ReturnTree returnTree2 = (ReturnTree)treePath.getLeaf();
        return this.scan(returnTree.getExpression(), returnTree2.getExpression(), treePath);
    }

    @Override
    public Boolean visitMemberSelect(MemberSelectTree memberSelectTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitMemberSelect(memberSelectTree, treePath);
        }
        if (Utilities.isPureMemberSelect(memberSelectTree, true) && Utilities.isPureMemberSelect(treePath.getLeaf(), true)) {
            switch (this.verifyElements(this.getCurrentPath(), treePath)) {
                case MATCH_CHECK_DEEPER: {
                    if (memberSelectTree.getKind() == treePath.getLeaf().getKind()) {
                        MemberSelectTree memberSelectTree2 = (MemberSelectTree)treePath.getLeaf();
                        return this.scan(memberSelectTree.getExpression(), memberSelectTree2.getExpression(), treePath) == Boolean.TRUE;
                    }
                    return true;
                }
                case MATCH: {
                    return true;
                }
                case NO_MATCH: {
                    return false;
                }
            }
        }
        if (memberSelectTree.getKind() != treePath.getLeaf().getKind()) {
            return false;
        }
        MemberSelectTree memberSelectTree3 = (MemberSelectTree)treePath.getLeaf();
        if (!this.scan(memberSelectTree.getExpression(), memberSelectTree3.getExpression(), treePath).booleanValue()) {
            return false;
        }
        String string = memberSelectTree3.getIdentifier().toString();
        if (string.startsWith("$")) {
            if (this.bindState.variables2Names.containsKey(string)) {
                return memberSelectTree.getIdentifier().contentEquals(this.bindState.variables2Names.get(string));
            }
            this.bindState.variables2Names.put(string, memberSelectTree.getIdentifier().toString());
            return true;
        }
        return memberSelectTree.getIdentifier().toString().equals(memberSelectTree3.getIdentifier().toString());
    }

    @Override
    public Boolean visitSynchronized(SynchronizedTree synchronizedTree, TreePath treePath) {
        if (treePath == null) {
            super.visitSynchronized(synchronizedTree, treePath);
            return false;
        }
        SynchronizedTree synchronizedTree2 = (SynchronizedTree)treePath.getLeaf();
        if (!this.scan(synchronizedTree.getExpression(), synchronizedTree2.getExpression(), treePath).booleanValue()) {
            return false;
        }
        return this.scan(synchronizedTree.getBlock(), synchronizedTree2.getBlock(), treePath);
    }

    @Override
    public Boolean visitThrow(ThrowTree throwTree, TreePath treePath) {
        if (treePath == null) {
            super.visitThrow(throwTree, treePath);
            return false;
        }
        ThrowTree throwTree2 = (ThrowTree)treePath.getLeaf();
        return this.scan(throwTree.getExpression(), throwTree2.getExpression(), treePath);
    }

    @Override
    public Boolean visitTry(TryTree tryTree, TreePath treePath) {
        if (treePath == null) {
            super.visitTry(tryTree, treePath);
            return false;
        }
        TryTree tryTree2 = (TryTree)treePath.getLeaf();
        if (!this.scan(tryTree.getBlock(), tryTree2.getBlock(), treePath).booleanValue()) {
            return false;
        }
        if (!this.checkLists(tryTree.getCatches(), tryTree2.getCatches(), treePath)) {
            return false;
        }
        return this.scan(tryTree.getFinallyBlock(), tryTree2.getFinallyBlock(), treePath);
    }

    @Override
    public Boolean visitParameterizedType(ParameterizedTypeTree parameterizedTypeTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitParameterizedType(parameterizedTypeTree, treePath);
        }
        ParameterizedTypeTree parameterizedTypeTree2 = (ParameterizedTypeTree)treePath.getLeaf();
        if (!this.scan(parameterizedTypeTree.getType(), parameterizedTypeTree2.getType(), treePath).booleanValue()) {
            return false;
        }
        return this.checkLists(parameterizedTypeTree.getTypeArguments(), parameterizedTypeTree2.getTypeArguments(), treePath);
    }

    @Override
    public Boolean visitArrayType(ArrayTypeTree arrayTypeTree, TreePath treePath) {
        if (treePath == null) {
            super.visitArrayType(arrayTypeTree, treePath);
            return false;
        }
        ArrayTypeTree arrayTypeTree2 = (ArrayTypeTree)treePath.getLeaf();
        return this.scan(arrayTypeTree.getType(), arrayTypeTree2.getType(), treePath);
    }

    @Override
    public Boolean visitTypeCast(TypeCastTree typeCastTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitTypeCast(typeCastTree, treePath);
        }
        TypeCastTree typeCastTree2 = (TypeCastTree)treePath.getLeaf();
        if (!this.scan(typeCastTree.getType(), typeCastTree2.getType(), treePath).booleanValue()) {
            return false;
        }
        return this.scan(typeCastTree.getExpression(), typeCastTree2.getExpression(), treePath);
    }

    @Override
    public Boolean visitPrimitiveType(PrimitiveTypeTree primitiveTypeTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitPrimitiveType(primitiveTypeTree, treePath);
        }
        PrimitiveTypeTree primitiveTypeTree2 = (PrimitiveTypeTree)treePath.getLeaf();
        return primitiveTypeTree.getPrimitiveTypeKind() == primitiveTypeTree2.getPrimitiveTypeKind();
    }

    @Override
    public Boolean visitInstanceOf(InstanceOfTree instanceOfTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitInstanceOf(instanceOfTree, treePath);
        }
        InstanceOfTree instanceOfTree2 = (InstanceOfTree)treePath.getLeaf();
        if (!this.scan(instanceOfTree.getExpression(), instanceOfTree2.getExpression(), treePath).booleanValue()) {
            return false;
        }
        return this.scan(instanceOfTree.getType(), instanceOfTree2.getType(), treePath);
    }

    @Override
    public Boolean visitUnary(UnaryTree unaryTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitUnary(unaryTree, treePath);
        }
        UnaryTree unaryTree2 = (UnaryTree)treePath.getLeaf();
        return this.scan(unaryTree.getExpression(), unaryTree2.getExpression(), treePath);
    }

    @Override
    public Boolean visitVariable(VariableTree variableTree, TreePath treePath) {
        Object object;
        Object object2;
        if (treePath == null) {
            return (Boolean)super.visitVariable(variableTree, treePath);
        }
        VariableTree variableTree2 = (VariableTree)treePath.getLeaf();
        if (!this.scan(variableTree.getModifiers(), variableTree2.getModifiers(), treePath).booleanValue()) {
            return false;
        }
        if (!this.scan(variableTree.getType(), variableTree2.getType(), treePath).booleanValue()) {
            return false;
        }
        String string = variableTree2.getName().toString();
        if (string.startsWith("$")) {
            object2 = this.bindState.variables2Names.get(string);
            object = variableTree.getName().toString();
            if (object2 != null) {
                if (!((String)object2).equals(string)) {
                    return false;
                }
            } else {
                this.bindState.variables.put(string, this.getCurrentPath());
                this.bindState.variables2Names.put(string, (String)object);
            }
        }
        if (this.allowVariablesRemap) {
            object2 = (VariableElement)this.info.getTrees().getElement(this.getCurrentPath());
            object = (VariableElement)this.info.getTrees().getElement(treePath);
            if (object2 != null && object != null && this.isSameTypeForVariableRemap(object2.asType(), object.asType())) {
                this.bindState.variablesRemapToElement.put((Element)object, (Element)object2);
            }
        }
        return this.scan(variableTree.getInitializer(), variableTree2.getInitializer(), treePath);
    }

    @Override
    public Boolean visitWhileLoop(WhileLoopTree whileLoopTree, TreePath treePath) {
        if (treePath == null) {
            return (Boolean)super.visitWhileLoop(whileLoopTree, treePath);
        }
        WhileLoopTree whileLoopTree2 = (WhileLoopTree)treePath.getLeaf();
        if (!this.scan(whileLoopTree.getCondition(), whileLoopTree2.getCondition(), treePath).booleanValue()) {
            return false;
        }
        return this.scan(whileLoopTree.getStatement(), whileLoopTree2.getStatement(), treePath);
    }

    @NonNull
    protected VerifyResult verifyElements(TreePath treePath, TreePath treePath2) {
        Element element = this.info.getTrees().getElement(treePath);
        Element element2 = this.info.getTrees().getElement(treePath2);
        if (element == null) {
            return element2 == null ? VerifyResult.MATCH : VerifyResult.NO_MATCH_CONTINUE;
        }
        VerifyResult verifyResult = !element.getModifiers().contains((Object)Modifier.STATIC) ? (element.getKind().isClass() && this.info.getElementUtilities().enclosingTypeElement(element) == null ? VerifyResult.MATCH : VerifyResult.MATCH_CHECK_DEEPER) : VerifyResult.MATCH;
        if (element == element2) {
            return verifyResult;
        }
        if (element == null || element2 == null) {
            return VerifyResult.NO_MATCH;
        }
        if (element.getKind() == element2.getKind() && element.getKind() == ElementKind.METHOD && this.info.getElements().overrides((ExecutableElement)element, (ExecutableElement)element2, (TypeElement)element.getEnclosingElement())) {
            return VerifyResult.MATCH_CHECK_DEEPER;
        }
        if (((Object)element).equals(element2)) {
            return verifyResult;
        }
        if (this.allowVariablesRemap && ((Object)element).equals(this.bindState.variablesRemapToElement.get(element2))) {
            return verifyResult;
        }
        TypeMirror typeMirror = this.info.getTrees().getTypeMirror(treePath);
        if (typeMirror == null || typeMirror.getKind() == TypeKind.ERROR) {
            return VerifyResult.NO_MATCH_CONTINUE;
        }
        TypeMirror typeMirror2 = this.info.getTrees().getTypeMirror(treePath2);
        if (typeMirror2 == null || typeMirror2.getKind() == TypeKind.ERROR) {
            return VerifyResult.NO_MATCH_CONTINUE;
        }
        return VerifyResult.NO_MATCH;
    }

    protected Iterable<? extends TreePath> prepareThis(TreePath treePath) {
        LinkedList<TreePath> linkedList = new LinkedList<TreePath>();
        Object var4_4 = null;
        for (Scope scope = this.info.getTrees().getScope(treePath); scope != null && scope.getEnclosingClass() != null; scope = scope.getEnclosingScope()) {
            if (var4_4 == scope.getEnclosingClass()) continue;
            ExpressionTree expressionTree = this.info.getTreeUtilities().parseExpression("this", new SourcePositions[1]);
            this.info.getTreeUtilities().attributeTree((Tree)expressionTree, scope);
            linkedList.add(new TreePath(treePath, expressionTree));
        }
        return linkedList;
    }

    private boolean isSameTypeForVariableRemap(TypeMirror typeMirror, TypeMirror typeMirror2) {
        return this.info.getTypes().isSameType(typeMirror, typeMirror2);
    }

    private static Name getSimpleName(Tree tree) {
        if (tree.getKind() == Tree.Kind.IDENTIFIER) {
            return ((IdentifierTree)tree).getName();
        }
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            return ((MemberSelectTree)tree).getIdentifier();
        }
        throw new UnsupportedOperationException();
    }

    public static List<? extends StatementTree> getStatements(TreePath treePath) {
        switch (treePath.getParentPath().getLeaf().getKind()) {
            case BLOCK: {
                return ((BlockTree)treePath.getParentPath().getLeaf()).getStatements();
            }
            case CASE: {
                return ((CaseTree)treePath.getParentPath().getLeaf()).getStatements();
            }
        }
        return Collections.singletonList((StatementTree)treePath.getLeaf());
    }

    private static final class State {
        final Map<String, TreePath> variables;
        final Map<String, Collection<? extends TreePath>> multiVariables;
        final Map<String, String> variables2Names;
        final Map<Element, Element> variablesRemapToElement;
        final Map<Element, TreePath> variablesRemapToTrees;

        private State(Map<String, TreePath> map, Map<String, Collection<? extends TreePath>> map2, Map<String, String> map3, Map<Element, Element> map4, Map<Element, TreePath> map5) {
            this.variables = map;
            this.multiVariables = map2;
            this.variables2Names = map3;
            this.variablesRemapToElement = map4;
            this.variablesRemapToTrees = map5;
        }

        public static State empty() {
            return new State(new HashMap<String, TreePath>(), new HashMap<String, Collection<? extends TreePath>>(), new HashMap<String, String>(), new HashMap<Element, Element>(), new HashMap<Element, TreePath>());
        }

        public static State copyOf(State state) {
            return new State(new HashMap<String, TreePath>(state.variables), new HashMap<String, Collection<? extends TreePath>>(state.multiVariables), new HashMap<String, String>(state.variables2Names), new HashMap<Element, Element>(state.variablesRemapToElement), new HashMap<Element, TreePath>(state.variablesRemapToTrees));
        }

        public static State from(Map<Element, Element> map, Map<Element, TreePath> map2) {
            return new State(new HashMap<String, TreePath>(), new HashMap<String, Collection<? extends TreePath>>(), new HashMap<String, String>(), map, map2);
        }

        public static State from(Map<String, TreePath> map, Map<String, Collection<? extends TreePath>> map2, Map<String, String> map3) {
            return new State(map, map2, map3, null, null);
        }
    }

    public static final class MethodDuplicateDescription {
        public final TreePath firstLeaf;
        public final int dupeStart;
        public final int dupeEnd;
        public final Map<Element, Element> variablesRemapToElement;
        public final Map<Element, TreePath> variablesRemapToTrees;

        public MethodDuplicateDescription(TreePath treePath, int n, int n2, Map<Element, Element> map, Map<Element, TreePath> map2) {
            this.firstLeaf = treePath;
            this.dupeStart = n;
            this.dupeEnd = n2;
            this.variablesRemapToElement = map;
            this.variablesRemapToTrees = map2;
        }
    }

    public static final class VariableAssignments {
        public final Map<String, TreePath> variables;
        public final Map<String, Collection<? extends TreePath>> multiVariables;
        public final Map<String, String> variables2Names;
        final Map<Element, Element> variablesRemapToElement;
        final Map<Element, TreePath> variablesRemapToTrees;

        public VariableAssignments(Map<String, TreePath> map, Map<String, Collection<? extends TreePath>> map2, Map<String, String> map3) {
            this.variables = map;
            this.multiVariables = map2;
            this.variables2Names = map3;
            this.variablesRemapToElement = null;
            this.variablesRemapToTrees = null;
        }

        VariableAssignments(State state) {
            this.variables = state.variables;
            this.multiVariables = state.multiVariables;
            this.variables2Names = state.variables2Names;
            this.variablesRemapToElement = state.variablesRemapToElement;
            this.variablesRemapToTrees = state.variablesRemapToTrees;
        }
    }

    private static enum VerifyResult {
        MATCH_CHECK_DEEPER,
        MATCH,
        NO_MATCH_CONTINUE,
        NO_MATCH;

    }
}

