/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.modules.java.hints.infrastructure.Pair;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;

public class Utilities {
    public static final String JAVA_MIME_TYPE = "text/x-java";
    private static final String DEFAULT_NAME = "name";
    private static final Map<Tree.Kind, String> operator2DN = new HashMap<Tree.Kind, String>();

    public static String guessName(CompilationInfo compilationInfo, TreePath treePath) {
        ExpressionTree expressionTree = (ExpressionTree)treePath.getLeaf();
        String string = Utilities.getName(expressionTree);
        if (string == null) {
            Object object;
            if (expressionTree instanceof LiteralTree && (object = ((LiteralTree)expressionTree).getValue()) != null && object instanceof String) {
                return Utilities.guessLiteralName((String)object);
            }
            return DEFAULT_NAME;
        }
        Scope scope = compilationInfo.getTrees().getScope(treePath);
        int n = 0;
        boolean bl = true;
        String string2 = string;
        block0: while (bl) {
            string2 = string + (n != 0 ? String.valueOf(n) : "");
            bl = false;
            for (Element element : compilationInfo.getElementUtilities().getLocalMembersAndVars(scope, (ElementUtilities.ElementAcceptor)new VariablesFilter())) {
                if (!string2.equals(element.getSimpleName().toString())) continue;
                ++n;
                bl = true;
                continue block0;
            }
        }
        return string2;
    }

    private static String guessLiteralName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() == 0) {
            return DEFAULT_NAME;
        }
        char c = string.charAt(0);
        if (Character.isJavaIdentifierStart(string.charAt(0))) {
            stringBuffer.append(c);
        }
        for (int i = 1; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == ' ') {
                stringBuffer.append('_');
                continue;
            }
            if (Character.isJavaIdentifierPart(c2)) {
                stringBuffer.append(c2);
            }
            if (i > 40) break;
        }
        if (stringBuffer.length() == 0) {
            return DEFAULT_NAME;
        }
        return stringBuffer.toString();
    }

    public static boolean isEnhancedForLoopIdentifier(TreePath treePath) {
        if (treePath == null || treePath.getLeaf().getKind() != Tree.Kind.IDENTIFIER) {
            return false;
        }
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null || treePath2.getLeaf().getKind() != Tree.Kind.VARIABLE) {
            return false;
        }
        TreePath treePath3 = treePath2.getParentPath();
        return treePath3 != null && treePath3.getLeaf().getKind() == Tree.Kind.ENHANCED_FOR_LOOP;
    }

    public static TypeMirror getIterableGenericType(CompilationInfo compilationInfo, TreePath treePath) {
        TypeElement typeElement = compilationInfo.getElements().getTypeElement("java.lang.Iterable");
        if (typeElement == null) {
            return null;
        }
        TypeMirror typeMirror = compilationInfo.getTrees().getTypeMirror(treePath);
        if (typeMirror == null) {
            return null;
        }
        TypeMirror typeMirror2 = null;
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            if (!compilationInfo.getTypes().isSubtype(compilationInfo.getTypes().erasure(declaredType), compilationInfo.getTypes().erasure(typeElement.asType()))) {
                return null;
            }
            ExecutableElement executableElement = (ExecutableElement)typeElement.getEnclosedElements().get(0);
            ExecutableType executableType = (ExecutableType)compilationInfo.getTypes().asMemberOf(declaredType, executableElement);
            List<? extends TypeMirror> list = ((DeclaredType)executableType.getReturnType()).getTypeArguments();
            if (!list.isEmpty()) {
                typeMirror2 = list.get(0);
            }
        } else if (typeMirror.getKind() == TypeKind.ARRAY) {
            typeMirror2 = ((ArrayType)typeMirror).getComponentType();
        }
        if (typeMirror2 == null) {
            return null;
        }
        return Utilities.resolveCapturedType(compilationInfo, typeMirror2);
    }

    public static String getName(TypeMirror typeMirror) {
        if (typeMirror.getKind().isPrimitive()) {
            return "" + Character.toLowerCase(typeMirror.getKind().name().charAt(0));
        }
        switch (typeMirror.getKind()) {
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                return Utilities.firstToLower(declaredType.asElement().getSimpleName().toString());
            }
            case ARRAY: {
                return Utilities.getName(((ArrayType)typeMirror).getComponentType());
            }
        }
        return DEFAULT_NAME;
    }

    public static String getName(ExpressionTree expressionTree) {
        return Utilities.getName((Tree)expressionTree);
    }

    public static String getName(Tree tree) {
        return Utilities.adjustName(Utilities.getNameRaw(tree));
    }

    private static String getNameRaw(Tree tree) {
        if (tree == null) {
            return null;
        }
        switch (tree.getKind()) {
            case IDENTIFIER: {
                return ((IdentifierTree)tree).getName().toString();
            }
            case METHOD_INVOCATION: {
                return Utilities.getName(((MethodInvocationTree)tree).getMethodSelect());
            }
            case MEMBER_SELECT: {
                return ((MemberSelectTree)tree).getIdentifier().toString();
            }
            case NEW_CLASS: {
                return Utilities.firstToLower(Utilities.getName(((NewClassTree)tree).getIdentifier()));
            }
            case PARAMETERIZED_TYPE: {
                return Utilities.firstToLower(Utilities.getName(((ParameterizedTypeTree)tree).getType()));
            }
        }
        return null;
    }

    static String adjustName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        if (string.startsWith("get") && string.length() > 3) {
            string2 = string.substring(3);
        }
        if (string.startsWith("is") && string.length() > 2) {
            string2 = string.substring(2);
        }
        if (string2 != null) {
            return Utilities.firstToLower(string2);
        }
        if (SourceVersion.isKeyword(string)) {
            return "a" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        return string;
    }

    private static String firstToLower(String string) {
        if (string.length() == 0) {
            return null;
        }
        String string2 = Character.toLowerCase(string.charAt(0)) + string.substring(1);
        if (SourceVersion.isKeyword(string2)) {
            string2 = "a" + string;
        }
        return string2;
    }

    public static ChangeInfo commitAndComputeChangeInfo(FileObject fileObject, final ModificationResult modificationResult, final Object object) throws IOException {
        ChangeInfo changeInfo;
        block5: {
            List list = modificationResult.getDifferences(fileObject);
            changeInfo = null;
            modificationResult.commit();
            try {
                if (list == null) break block5;
                for (ModificationResult.Difference difference : list) {
                    if (difference.getNewText() == null) continue;
                    final PositionRef positionRef = difference.getStartPosition();
                    StyledDocument styledDocument = positionRef.getCloneableEditorSupport().getDocument();
                    if (styledDocument == null) {
                        styledDocument = positionRef.getCloneableEditorSupport().openDocument();
                    }
                    final Position[] positionArray = new Position[2];
                    final StyledDocument styledDocument2 = styledDocument;
                    styledDocument.render(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int[] nArray = modificationResult.getSpan(object);
                                if (nArray != null) {
                                    positionArray[0] = styledDocument2.createPosition(nArray[0]);
                                    positionArray[1] = styledDocument2.createPosition(nArray[1]);
                                } else {
                                    positionArray[0] = NbDocument.createPosition((Document)styledDocument2, (int)positionRef.getOffset(), (Position.Bias)Position.Bias.Backward);
                                    positionArray[1] = positionArray[0];
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                Exceptions.printStackTrace((Throwable)badLocationException);
                            }
                        }
                    });
                    if (positionArray[0] != null) {
                        changeInfo = new ChangeInfo(fileObject, positionArray[0], positionArray[1]);
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return changeInfo;
    }

    public static boolean isMethodHeaderInsideGuardedBlock(CompilationInfo compilationInfo, MethodTree methodTree) {
        try {
            Document document = compilationInfo.getDocument();
            if (document instanceof GuardedDocument) {
                GuardedDocument guardedDocument = (GuardedDocument)document;
                int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), methodTree);
                int n2 = (int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), methodTree);
                return (guardedDocument.getGuardedBlockChain().compareBlock(n, n2) & 1) != 0;
            }
            return false;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    public static TypeMirror resolveCapturedType(CompilationInfo compilationInfo, TypeMirror typeMirror) {
        TypeMirror typeMirror2 = Utilities.resolveCapturedTypeInt(compilationInfo, typeMirror);
        if (typeMirror2.getKind() == TypeKind.WILDCARD) {
            TypeMirror typeMirror3 = ((WildcardType)typeMirror2).getExtendsBound();
            if (typeMirror3 != null) {
                return typeMirror3;
            }
            return compilationInfo.getElements().getTypeElement("java.lang.Object").asType();
        }
        return typeMirror2;
    }

    private static TypeMirror resolveCapturedTypeInt(CompilationInfo compilationInfo, TypeMirror typeMirror) {
        WildcardType wildcardType = SourceUtils.resolveCapturedType((TypeMirror)typeMirror);
        if (wildcardType != null) {
            TypeMirror typeMirror2;
            WildcardType wildcardType2;
            if (wildcardType.getKind() == TypeKind.WILDCARD && (wildcardType2 = SourceUtils.resolveCapturedType((TypeMirror)((typeMirror2 = wildcardType.getExtendsBound()) != null ? typeMirror2 : wildcardType.getSuperBound()))) != null) {
                return wildcardType2;
            }
            return wildcardType;
        }
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            LinkedList<TypeMirror> linkedList = new LinkedList<TypeMirror>();
            for (TypeMirror typeMirror3 : declaredType.getTypeArguments()) {
                linkedList.add(Utilities.resolveCapturedTypeInt(compilationInfo, typeMirror3));
            }
            TypeMirror typeMirror4 = declaredType.getEnclosingType();
            if (typeMirror4.getKind() == TypeKind.DECLARED) {
                return compilationInfo.getTypes().getDeclaredType((DeclaredType)typeMirror4, (TypeElement)declaredType.asElement(), linkedList.toArray(new TypeMirror[0]));
            }
            return compilationInfo.getTypes().getDeclaredType((TypeElement)declaredType.asElement(), linkedList.toArray(new TypeMirror[0]));
        }
        if (typeMirror.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)typeMirror;
            return compilationInfo.getTypes().getArrayType(Utilities.resolveCapturedTypeInt(compilationInfo, arrayType.getComponentType()));
        }
        return typeMirror;
    }

    public static <T extends Tree> T copyComments(WorkingCopy workingCopy, Tree tree, T t) {
        Utilities.copyComments(workingCopy, tree, t, true);
        Utilities.copyComments(workingCopy, tree, t, false);
        return t;
    }

    public static <T extends Tree> T copyComments(WorkingCopy workingCopy, Tree tree, T t, boolean bl) {
        GeneratorUtilities.get((WorkingCopy)workingCopy).copyComments(tree, t, bl);
        return t;
    }

    public static TypeMirror convertIfAnonymous(TypeMirror typeMirror) {
        Element element;
        EnumSet<ElementKind> enumSet = EnumSet.of(ElementKind.METHOD, ElementKind.FIELD);
        if (typeMirror instanceof DeclaredType && ((element = ((DeclaredType)typeMirror).asElement()).getSimpleName().length() == 0 || enumSet.contains((Object)element.getEnclosingElement().getKind()))) {
            List<? extends TypeMirror> list = ((TypeElement)element).getInterfaces();
            typeMirror = list.isEmpty() ? ((TypeElement)element).getSuperclass() : list.get(0);
        }
        return typeMirror;
    }

    public static List<List<TreePath>> splitStringConcatenationToElements(CompilationInfo compilationInfo, TreePath treePath) {
        return Utilities.sortOut(compilationInfo, Utilities.linearize(treePath));
    }

    private static List<TreePath> linearize(TreePath treePath) {
        LinkedList<TreePath> linkedList = new LinkedList<TreePath>();
        LinkedList<TreePath> linkedList2 = new LinkedList<TreePath>();
        linkedList.add(treePath);
        while (!linkedList.isEmpty()) {
            TreePath treePath2 = (TreePath)linkedList.remove(0);
            if (treePath2.getLeaf().getKind() != Tree.Kind.PLUS) {
                linkedList2.add(treePath2);
                continue;
            }
            BinaryTree binaryTree = (BinaryTree)treePath2.getLeaf();
            linkedList.add(0, new TreePath(treePath2, binaryTree.getRightOperand()));
            linkedList.add(0, new TreePath(treePath2, binaryTree.getLeftOperand()));
        }
        return linkedList2;
    }

    private static List<List<TreePath>> sortOut(CompilationInfo compilationInfo, List<TreePath> list) {
        LinkedList<List<TreePath>> linkedList = new LinkedList<List<TreePath>>();
        LinkedList<TreePath> linkedList2 = new LinkedList<TreePath>();
        for (TreePath treePath : list) {
            if (Utilities.isConstantString(compilationInfo, treePath)) {
                linkedList2.add(treePath);
                continue;
            }
            if (!linkedList2.isEmpty()) {
                linkedList.add(linkedList2);
                linkedList2 = new LinkedList();
            }
            linkedList.add(new LinkedList<TreePath>(Collections.singletonList(treePath)));
        }
        if (!linkedList2.isEmpty()) {
            linkedList.add(linkedList2);
        }
        return linkedList;
    }

    public static boolean isConstantString(CompilationInfo compilationInfo, TreePath treePath) {
        if (treePath.getLeaf().getKind() == Tree.Kind.STRING_LITERAL) {
            return true;
        }
        Element element = compilationInfo.getTrees().getElement(treePath);
        if (element != null && element.getKind() == ElementKind.FIELD && ((VariableElement)element).getConstantValue() instanceof String) {
            return true;
        }
        if (treePath.getLeaf().getKind() != Tree.Kind.PLUS) {
            return false;
        }
        List<List<TreePath>> list = Utilities.splitStringConcatenationToElements(compilationInfo, treePath);
        if (list.size() != 1) {
            return false;
        }
        List<TreePath> list2 = list.get(0);
        return !list2.isEmpty() && Utilities.isConstantString(compilationInfo, list2.get(0));
    }

    @NonNull
    public static Collection<? extends TreePath> resolveFieldGroup(@NonNull CompilationInfo compilationInfo, @NonNull TreePath treePath) {
        Collection<Tree> collection;
        Tree tree = treePath.getLeaf();
        if (tree.getKind() != Tree.Kind.VARIABLE) {
            return Collections.singleton(treePath);
        }
        TreePath treePath2 = treePath.getParentPath();
        switch (treePath2.getLeaf().getKind()) {
            case BLOCK: {
                collection = ((BlockTree)treePath2.getLeaf()).getStatements();
                break;
            }
            case CLASS: {
                collection = ((ClassTree)treePath2.getLeaf()).getMembers();
                break;
            }
            case CASE: {
                collection = ((CaseTree)treePath2.getLeaf()).getStatements();
                break;
            }
            default: {
                collection = Collections.singleton(tree);
            }
        }
        LinkedList<TreePath> linkedList = new LinkedList<TreePath>();
        ModifiersTree modifiersTree = ((VariableTree)tree).getModifiers();
        for (Tree tree2 : collection) {
            if (tree2.getKind() != Tree.Kind.VARIABLE || ((VariableTree)tree2).getModifiers() != modifiersTree) continue;
            linkedList.add(new TreePath(treePath2, tree2));
        }
        return linkedList;
    }

    public static String shortDisplayName(CompilationInfo compilationInfo, ExpressionTree expressionTree) {
        return (String)new HintDisplayNameVisitor(compilationInfo).scan(expressionTree, null);
    }

    public static TreePath findEnclosingMethodOrConstructor(HintContext hintContext, TreePath treePath) {
        while (treePath != null && treePath.getLeaf().getKind() != Tree.Kind.METHOD && treePath.getLeaf().getKind() != Tree.Kind.CLASS) {
            treePath = treePath.getParentPath();
        }
        if (treePath != null && treePath.getLeaf().getKind() == Tree.Kind.METHOD) {
            return treePath;
        }
        return null;
    }

    public static boolean isInConstructor(HintContext hintContext) {
        TreePath treePath = Utilities.findEnclosingMethodOrConstructor(hintContext, hintContext.getPath());
        if (treePath == null) {
            return false;
        }
        Element element = hintContext.getInfo().getTrees().getElement(treePath);
        return element != null && element.getKind() == ElementKind.CONSTRUCTOR;
    }

    public static Pair<List<? extends TypeMirror>, List<String>> resolveArguments(CompilationInfo compilationInfo, TreePath treePath, List<? extends ExpressionTree> list) {
        LinkedList<TypeMirror> linkedList = new LinkedList<TypeMirror>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        for (ExpressionTree expressionTree : list) {
            TypeMirror typeMirror = compilationInfo.getTrees().getTypeMirror(new TreePath(treePath, expressionTree));
            if ((typeMirror = Utilities.convertIfAnonymous(typeMirror)) == null || Utilities.containsErrorsOrTypevarsRecursively(typeMirror)) {
                return null;
            }
            if (typeMirror.getKind() == TypeKind.NULL) {
                typeMirror = compilationInfo.getElements().getTypeElement("java.lang.Object").asType();
            }
            linkedList.add(typeMirror);
            String string = Utilities.getName(expressionTree);
            if (string == null) {
                string = Utilities.getName(typeMirror);
            }
            if (string == null) {
                string = "arg";
            }
            if (hashSet.contains(string)) {
                int n = 0;
                while (hashSet.contains(string + n)) {
                    ++n;
                }
                string = string + n;
            }
            hashSet.add(string);
            linkedList2.add(string);
        }
        return new Pair<List<? extends TypeMirror>, List<String>>(linkedList, linkedList2);
    }

    public static boolean containsErrorsOrTypevarsRecursively(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case WILDCARD: 
            case TYPEVAR: 
            case ERROR: {
                return true;
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                for (TypeMirror typeMirror2 : declaredType.getTypeArguments()) {
                    if (!Utilities.containsErrorsOrTypevarsRecursively(typeMirror2)) continue;
                    return true;
                }
                return false;
            }
            case ARRAY: {
                return Utilities.containsErrorsOrTypevarsRecursively(((ArrayType)typeMirror).getComponentType());
            }
        }
        return false;
    }

    static {
        operator2DN.put(Tree.Kind.AND, "&");
        operator2DN.put(Tree.Kind.XOR, "^");
        operator2DN.put(Tree.Kind.OR, "|");
        operator2DN.put(Tree.Kind.CONDITIONAL_AND, "&&");
        operator2DN.put(Tree.Kind.CONDITIONAL_OR, "||");
        operator2DN.put(Tree.Kind.MULTIPLY_ASSIGNMENT, "*=");
        operator2DN.put(Tree.Kind.DIVIDE_ASSIGNMENT, "/=");
        operator2DN.put(Tree.Kind.REMAINDER_ASSIGNMENT, "%=");
        operator2DN.put(Tree.Kind.PLUS_ASSIGNMENT, "+=");
        operator2DN.put(Tree.Kind.MINUS_ASSIGNMENT, "-=");
        operator2DN.put(Tree.Kind.LEFT_SHIFT_ASSIGNMENT, "<<=");
        operator2DN.put(Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, ">>=");
        operator2DN.put(Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, ">>>=");
        operator2DN.put(Tree.Kind.AND_ASSIGNMENT, "&=");
        operator2DN.put(Tree.Kind.XOR_ASSIGNMENT, "^=");
        operator2DN.put(Tree.Kind.OR_ASSIGNMENT, "|=");
        operator2DN.put(Tree.Kind.BITWISE_COMPLEMENT, "~");
        operator2DN.put(Tree.Kind.LOGICAL_COMPLEMENT, "!");
        operator2DN.put(Tree.Kind.MULTIPLY, "*");
        operator2DN.put(Tree.Kind.DIVIDE, "/");
        operator2DN.put(Tree.Kind.REMAINDER, "%");
        operator2DN.put(Tree.Kind.PLUS, "+");
        operator2DN.put(Tree.Kind.MINUS, "-");
        operator2DN.put(Tree.Kind.LEFT_SHIFT, "<<");
        operator2DN.put(Tree.Kind.RIGHT_SHIFT, ">>");
        operator2DN.put(Tree.Kind.UNSIGNED_RIGHT_SHIFT, ">>>");
        operator2DN.put(Tree.Kind.LESS_THAN, "<");
        operator2DN.put(Tree.Kind.GREATER_THAN, ">");
        operator2DN.put(Tree.Kind.LESS_THAN_EQUAL, "<=");
        operator2DN.put(Tree.Kind.GREATER_THAN_EQUAL, ">=");
        operator2DN.put(Tree.Kind.EQUAL_TO, "==");
        operator2DN.put(Tree.Kind.NOT_EQUAL_TO, "!=");
    }

    private static class HintDisplayNameVisitor
    extends TreeScanner<String, Void> {
        private CompilationInfo info;

        public HintDisplayNameVisitor(CompilationInfo compilationInfo) {
            this.info = compilationInfo;
        }

        @Override
        public String visitIdentifier(IdentifierTree identifierTree, Void void_) {
            return "..." + identifierTree.getName().toString();
        }

        @Override
        public String visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void void_) {
            ExpressionTree expressionTree = methodInvocationTree.getMethodSelect();
            return "..." + this.simpleName(expressionTree) + "(...)";
        }

        @Override
        public String visitArrayAccess(ArrayAccessTree arrayAccessTree, Void void_) {
            return "..." + this.simpleName(arrayAccessTree.getExpression()) + "[]";
        }

        @Override
        public String visitNewClass(NewClassTree newClassTree, Void void_) {
            return "...new " + this.simpleName(newClassTree.getIdentifier()) + "(...)";
        }

        @Override
        public String visitBinary(BinaryTree binaryTree, Void void_) {
            String string = (String)operator2DN.get((Object)binaryTree.getKind());
            return (String)this.scan(binaryTree.getLeftOperand(), void_) + string + (String)this.scan(binaryTree.getRightOperand(), void_);
        }

        @Override
        public String visitLiteral(LiteralTree literalTree, Void void_) {
            if (literalTree.getValue() instanceof String) {
                return "...";
            }
            int n = (int)this.info.getTrees().getSourcePositions().getStartPosition(this.info.getCompilationUnit(), literalTree);
            int n2 = (int)this.info.getTrees().getSourcePositions().getEndPosition(this.info.getCompilationUnit(), literalTree);
            return this.info.getText().substring(n, n2);
        }

        private String simpleName(Tree tree) {
            if (tree.getKind() == Tree.Kind.IDENTIFIER) {
                return ((IdentifierTree)tree).getName().toString();
            }
            if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
                return ((MemberSelectTree)tree).getIdentifier().toString();
            }
            if (tree.getKind() == Tree.Kind.METHOD_INVOCATION) {
                return (String)this.scan(tree, null);
            }
            if (tree.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                return this.simpleName(((ParameterizedTypeTree)tree).getType()) + "<...>";
            }
            if (tree.getKind() == Tree.Kind.ARRAY_ACCESS) {
                return this.simpleName(((ArrayAccessTree)tree).getExpression()) + "[]";
            }
            if (tree.getKind() == Tree.Kind.PARENTHESIZED) {
                return "(" + this.simpleName(((ParenthesizedTree)tree).getExpression()) + ")";
            }
            if (tree.getKind() == Tree.Kind.TYPE_CAST) {
                return this.simpleName(((TypeCastTree)tree).getType());
            }
            if (tree.getKind() == Tree.Kind.ARRAY_TYPE) {
                return this.simpleName(((ArrayTypeTree)tree).getType());
            }
            throw new IllegalStateException("Currently unsupported kind of tree: " + (Object)((Object)tree.getKind()));
        }
    }

    private static final class VariablesFilter
    implements ElementUtilities.ElementAcceptor {
        private static final Set<ElementKind> ACCEPTABLE_KINDS = EnumSet.of(ElementKind.ENUM_CONSTANT, ElementKind.EXCEPTION_PARAMETER, ElementKind.FIELD, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);

        private VariablesFilter() {
        }

        public boolean accept(Element element, TypeMirror typeMirror) {
            return ACCEPTABLE_KINDS.contains((Object)element.getKind());
        }
    }
}

