/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.AddCastFix;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public final class AddCast
implements ErrorRule<Void> {
    private static final Set<String> ERROR_CODES = new HashSet<String>(Arrays.asList("compiler.err.prob.found.req", "compiler.err.cant.apply.symbol", "compiler.err.cant.resolve.location.args"));

    static void computeType(CompilationInfo compilationInfo, int n, TypeMirror[] typeMirrorArray, ExpressionTree[] expressionTreeArray, Tree[] treeArray) {
        for (Object object = compilationInfo.getTreeUtilities().pathFor(n + 1); object != null; object = object.getParentPath()) {
            Object object2;
            Object object3;
            Tree tree = object.getLeaf();
            TypeMirror typeMirror = null;
            TypeMirror typeMirror2 = null;
            ExpressionTree expressionTree = null;
            if (tree.getKind() == Tree.Kind.VARIABLE && ((VariableTree)tree).getInitializer() != null) {
                typeMirror = compilationInfo.getTrees().getTypeMirror((TreePath)object);
                expressionTree = ((VariableTree)tree).getInitializer();
                typeMirror2 = compilationInfo.getTrees().getTypeMirror(new TreePath((TreePath)object, expressionTree));
            }
            if (tree.getKind() == Tree.Kind.ASSIGNMENT) {
                typeMirror = compilationInfo.getTrees().getTypeMirror((TreePath)object);
                expressionTree = ((AssignmentTree)tree).getExpression();
                typeMirror2 = compilationInfo.getTrees().getTypeMirror(new TreePath((TreePath)object, expressionTree));
            }
            if (tree.getKind() == Tree.Kind.RETURN) {
                for (object3 = object; object3 != null && ((TreePath)object3).getLeaf().getKind() != Tree.Kind.METHOD; object3 = ((TreePath)object3).getParentPath()) {
                }
                if (object3 != null && (object2 = (Object)((MethodTree)((TreePath)object3).getLeaf()).getReturnType()) != null) {
                    typeMirror = compilationInfo.getTrees().getTypeMirror(new TreePath((TreePath)object3, (Tree)object2));
                    expressionTree = ((ReturnTree)tree).getExpression();
                    typeMirror2 = compilationInfo.getTrees().getTypeMirror(new TreePath((TreePath)object, expressionTree));
                }
            }
            if ((tree.getKind() == Tree.Kind.METHOD_INVOCATION || tree.getKind() == Tree.Kind.NEW_CLASS) && org.netbeans.modules.editor.java.Utilities.fuzzyResolveMethodInvocation((CompilationInfo)compilationInfo, (TreePath)object, (TypeMirror[])(object3 = new TypeMirror[1]), (int[])(object2 = new int[1])) != null) {
                typeMirror = object3[0];
                expressionTree = tree.getKind() == Tree.Kind.METHOD_INVOCATION ? ((MethodInvocationTree)tree).getArguments().get(object2[0]) : ((NewClassTree)tree).getArguments().get(object2[0]);
                typeMirror2 = compilationInfo.getTrees().getTypeMirror(new TreePath((TreePath)object, expressionTree));
            }
            if (typeMirror == null || typeMirror2 == null) continue;
            object3 = compilationInfo.getTrees().getTypeMirror(new TreePath((TreePath)object, expressionTree));
            if (object3.getKind() == TypeKind.ERROR) {
                object3 = compilationInfo.getTrees().getOriginalType((ErrorType)object3);
            }
            if (typeMirror2.getKind() == TypeKind.ERROR) {
                typeMirror2 = compilationInfo.getTrees().getOriginalType((ErrorType)typeMirror2);
            }
            if (object3.getKind() == TypeKind.EXECUTABLE || object3.getKind() == TypeKind.NONE) continue;
            if (compilationInfo.getTypeUtilities().isCastable(typeMirror2, typeMirror)) {
                if (compilationInfo.getTypes().isAssignable((TypeMirror)object3, typeMirror) || object3.getKind() == TypeKind.ERROR || typeMirror.getKind() == TypeKind.ERROR) continue;
                typeMirrorArray[0] = typeMirror;
                expressionTreeArray[0] = expressionTree;
                treeArray[0] = tree;
                continue;
            }
            typeMirrorArray[0] = null;
        }
        if (typeMirrorArray[0] != null) {
            typeMirrorArray[0] = Utilities.resolveCapturedType(compilationInfo, typeMirrorArray[0]);
        }
    }

    @Override
    public Set<String> getCodes() {
        return ERROR_CODES;
    }

    @Override
    public List<Fix> run(CompilationInfo compilationInfo, String string, int n, TreePath treePath, ErrorRule.Data<Void> data) {
        ArrayList<Fix> arrayList = new ArrayList<Fix>();
        TypeMirror[] typeMirrorArray = new TypeMirror[1];
        ExpressionTree[] expressionTreeArray = new ExpressionTree[1];
        Tree[] treeArray = new Tree[1];
        AddCast.computeType(compilationInfo, n, typeMirrorArray, expressionTreeArray, treeArray);
        if (typeMirrorArray[0] != null && typeMirrorArray[0].getKind() != TypeKind.NULL) {
            int n2 = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), expressionTreeArray[0]);
            Class<? extends Tree> clazz = expressionTreeArray[0].getKind().asInterface();
            boolean bl = clazz == BinaryTree.class || clazz == ConditionalExpressionTree.class;
            arrayList.add(new AddCastFix(compilationInfo.getJavaSource(), Utilities.shortDisplayName(compilationInfo, expressionTreeArray[0]), ((Object)org.netbeans.modules.editor.java.Utilities.getTypeName((TypeMirror)typeMirrorArray[0], (boolean)false)).toString(), n2, bl));
        }
        return arrayList;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return AddCast.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(AddCast.class, (String)"LBL_Add_Cast");
    }

    public String getDescription() {
        return NbBundle.getMessage(AddCast.class, (String)"DSC_Add_Cast");
    }
}

