/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.model;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.ruby.debugger.RubySession;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public final class SessionsTableModelFilter
implements TableModelFilter {
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public Object getValueAt(TableModel original, Object row, String columnID) throws UnknownTypeException {
        if (row instanceof Session && SessionsTableModelFilter.isRubySession((Session)row)) {
            if ("SessionState".equals(columnID)) {
                return this.getSessionState((Session)row);
            }
            if ("SessionLanguage".equals(columnID)) {
                return row;
            }
            if ("SessionHostName".equals(columnID)) {
                return ((Session)row).getLocationName();
            }
            throw new UnknownTypeException(row);
        }
        return original.getValueAt(row, columnID);
    }

    public boolean isReadOnly(TableModel original, Object row, String columnID) throws UnknownTypeException {
        return original.isReadOnly(row, columnID);
    }

    public void setValueAt(TableModel original, Object row, String columnID, Object value) throws UnknownTypeException {
        original.setValueAt(row, columnID, value);
    }

    private static boolean isRubySession(Session s) {
        DebuggerEngine e = s.getCurrentEngine();
        if (e == null) {
            return false;
        }
        return e.lookupFirst(null, RubySession.class) != null;
    }

    private String getSessionState(Session s) {
        String state;
        DebuggerEngine e = s.getCurrentEngine();
        if (e == null) {
            return SessionsTableModelFilter.getMessage("MSG_Session.State.Starting");
        }
        RubySession session = (RubySession)e.lookupFirst(null, RubySession.class);
        switch (session.getState()) {
            case RUNNING: {
                state = SessionsTableModelFilter.getMessage("MSG_Session.State.Running");
                break;
            }
            case STARTING: {
                state = SessionsTableModelFilter.getMessage("MSG_Session.State.Starting");
                break;
            }
            case STOPPED: {
                state = SessionsTableModelFilter.getMessage("MSG_Session.State.Stopped");
                break;
            }
            default: {
                state = null;
            }
        }
        return state;
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public void fireChanges() {
        for (ModelListener listener : this.listeners) {
            listener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(SessionsTableModelFilter.class, (String)key);
    }
}

