/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.beans.Customizer;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.ruby.debugger.EditorUtil;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyLineBreakpoint;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public final class BreakpointCustomizer
extends JPanel
implements Customizer,
Controller {
    private RubyLineBreakpoint bp;
    private JLabel conditionLbl;
    private JTextField conditionValue;
    private JPanel conditionsPanel;
    private JLabel fileLbl;
    private JTextField fileValue;
    private JLabel lineLbl;
    private JTextField lineValue;
    private JPanel settingsPanel;

    public BreakpointCustomizer() {
        this.initComponents();
    }

    public static void customize(RubyLineBreakpoint bp) {
        BreakpointCustomizer customizer = new BreakpointCustomizer();
        customizer.setObject((Object)bp);
        DialogDescriptor descriptor = new DialogDescriptor((Object)customizer, NbBundle.getMessage(BreakpointCustomizer.class, (String)"BreakpointCustomizer.title"));
        Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
        d.setVisible(true);
        if (descriptor.getValue() == NotifyDescriptor.OK_OPTION) {
            customizer.ok();
        }
    }

    @Override
    public void setObject(Object bean) {
        if (!(bean instanceof RubyLineBreakpoint)) {
            throw new IllegalArgumentException(bean.toString());
        }
        this.bp = (RubyLineBreakpoint)((Object)bean);
        this.fileValue.setText(this.bp.getFilePath());
        this.lineValue.setText("" + this.bp.getLineNumber());
        String condition = this.bp.getCondition();
        this.conditionValue.setText(condition == null ? "" : condition);
    }

    public boolean ok() {
        try {
            int line = Integer.valueOf(this.lineValue.getText()) - 1;
            String file = this.fileValue.getText();
            if (!new File(file).isFile()) {
                Util.notifyLocalized(BreakpointCustomizer.class, (String)"BreakpointCustomizer.file.not.found", (Object[])new Object[]{file});
                return false;
            }
            Line eLine = EditorUtil.getLine(file, line);
            if (eLine == null) {
                Util.notifyLocalized(BreakpointCustomizer.class, (String)"BreakpointCustomizer.invalid.line.number", (Object[])new Object[]{"" + (line + 1), file});
                return false;
            }
            this.bp.setLine(eLine);
            if (this.getCondition().length() > 0) {
                this.bp.setCondition(this.getCondition());
            }
            return true;
        }
        catch (NumberFormatException nfe) {
            Util.notifyLocalized(BreakpointCustomizer.class, (String)"BreakpointCustomizer.invalid.number", (Object[])new Object[]{this.lineValue.getText()});
            return false;
        }
    }

    public boolean cancel() {
        return true;
    }

    private String getCondition() {
        return this.conditionValue.getText().trim();
    }

    private void initComponents() {
        this.settingsPanel = new JPanel();
        this.lineValue = new JTextField();
        this.fileValue = new JTextField();
        this.fileLbl = new JLabel();
        this.lineLbl = new JLabel();
        this.conditionsPanel = new JPanel();
        this.conditionValue = new JTextField();
        this.conditionLbl = new JLabel();
        this.settingsPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(BreakpointCustomizer.class, (String)"BreakpointCustomizer.settingsPanel.border.title")));
        this.fileLbl.setLabelFor(this.fileValue);
        Mnemonics.setLocalizedText((JLabel)this.fileLbl, (String)NbBundle.getMessage(BreakpointCustomizer.class, (String)"BreakpointCustomizer.fileLbl.text"));
        this.lineLbl.setLabelFor(this.lineValue);
        Mnemonics.setLocalizedText((JLabel)this.lineLbl, (String)NbBundle.getMessage(BreakpointCustomizer.class, (String)"BreakpointCustomizer.lineLbl.text"));
        GroupLayout settingsPanelLayout = new GroupLayout((Container)this.settingsPanel);
        this.settingsPanel.setLayout((LayoutManager)settingsPanelLayout);
        settingsPanelLayout.setHorizontalGroup((GroupLayout.Group)settingsPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)settingsPanelLayout.createSequentialGroup().add((Component)this.fileLbl).add(16, 16, 16).add((Component)this.fileValue, -1, 360, Short.MAX_VALUE)).add(2, (GroupLayout.Group)settingsPanelLayout.createSequentialGroup().add((Component)this.lineLbl).addPreferredGap(0).add((Component)this.lineValue, -1, 360, Short.MAX_VALUE)));
        settingsPanelLayout.setVerticalGroup((GroupLayout.Group)settingsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)settingsPanelLayout.createSequentialGroup().add((GroupLayout.Group)settingsPanelLayout.createParallelGroup(3).add((Component)this.fileLbl).add((Component)this.fileValue, -2, 19, -2)).addPreferredGap(0).add((GroupLayout.Group)settingsPanelLayout.createParallelGroup(3).add((Component)this.lineLbl).add((Component)this.lineValue, -2, -1, -2))));
        this.conditionsPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(BreakpointCustomizer.class, (String)"BreakpointCustomizer.conditionsPanel.border.title")));
        this.conditionLbl.setLabelFor(this.conditionValue);
        Mnemonics.setLocalizedText((JLabel)this.conditionLbl, (String)NbBundle.getMessage(BreakpointCustomizer.class, (String)"BreakpointCustomizer.conditionLbl.text"));
        GroupLayout conditionsPanelLayout = new GroupLayout((Container)this.conditionsPanel);
        this.conditionsPanel.setLayout((LayoutManager)conditionsPanelLayout);
        conditionsPanelLayout.setHorizontalGroup((GroupLayout.Group)conditionsPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)conditionsPanelLayout.createSequentialGroup().add((Component)this.conditionLbl).add(16, 16, 16).add((Component)this.conditionValue, -1, 323, Short.MAX_VALUE)));
        conditionsPanelLayout.setVerticalGroup((GroupLayout.Group)conditionsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)conditionsPanelLayout.createParallelGroup(3).add((Component)this.conditionLbl).add((Component)this.conditionValue, -2, 19, -2)));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.conditionsPanel, -1, -1, Short.MAX_VALUE).add((Component)this.settingsPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.settingsPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.conditionsPanel, -2, -1, -2)));
    }
}

