/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger;

import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.debugger.RubyDebugInstallPanel;
import org.netbeans.modules.ruby.debugger.RubySession;
import org.netbeans.modules.ruby.platform.DebuggerPreferences;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class Util {
    public static final String RUBY_MIME_TYPE = "text/x-ruby";
    public static final String ERB_MIME_TYPE = "application/x-httpd-eruby";

    private Util() {
    }

    public static String rdebugPattern() {
        return "rdebug-ide";
    }

    public static String findRDebugExecutable(RubyPlatform platform) {
        return platform.findExecutable(Util.rdebugPattern());
    }

    public static void showMessage(String message) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message));
    }

    public static void showWarning(String warning) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)warning, 2));
    }

    public static boolean isRubySource(FileObject fo) {
        return RUBY_MIME_TYPE.equals(fo.getMIMEType()) || Util.isERBSource(fo);
    }

    public static boolean isERBSource(FileObject fo) {
        return ERB_MIME_TYPE.equals(fo.getMIMEType());
    }

    public static RubySession getCurrentSession() {
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        return currentEngine == null ? null : (RubySession)currentEngine.lookupFirst(null, RubySession.class);
    }

    static FastDebugInstallationResult offerToInstallFastDebugger(RubyPlatform platform) {
        return Util.ensureRubyDebuggerIsPresent(platform, false, "RubyDebugger.askMessage");
    }

    static FastDebugInstallationResult ensureRubyDebuggerIsPresent(RubyPlatform platform, boolean strict, String messageKey) {
        Object[] objectArray;
        if (!platform.hasRubyGemsInstalled()) {
            return FastDebugInstallationResult.FAILED;
        }
        String problems = platform.getFastDebuggerProblemsInHTML();
        if (problems == null) {
            return FastDebugInstallationResult.INSTALLED;
        }
        if (!strict && DebuggerPreferences.getInstance().isDoNotAskAgain()) {
            return FastDebugInstallationResult.USE_SLOW;
        }
        String message = NbBundle.getMessage(Util.class, (String)messageKey, (Object)problems);
        RubyDebugInstallPanel rubyDebugPanel = new RubyDebugInstallPanel(strict, message);
        DialogDescriptor descriptor = new DialogDescriptor((Object)rubyDebugPanel, NbBundle.getMessage(Util.class, (String)"Util.installation.panel.title"));
        JButton installButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)installButton, (String)Util.getMessage("Util.installation.panel.installButton"));
        JButton useSlowButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)useSlowButton, (String)Util.getMessage("Util.installation.panel.useSlowButton"));
        JButton cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)cancelButton, (String)Util.getMessage("Util.installation.panel.cancelButton"));
        if (strict) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = installButton;
            objectArray = objectArray2;
            objectArray2[1] = cancelButton;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = installButton;
            objectArray3[1] = useSlowButton;
            objectArray = objectArray3;
            objectArray3[2] = cancelButton;
        }
        Object[] options = objectArray;
        descriptor.setOptions(options);
        Object button = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        if (button == installButton) {
            if (!platform.installFastDebugger()) {
                Util.showWarning(Util.getMessage("Util.fast.debugger.install.failed"));
                return FastDebugInstallationResult.FAILED;
            }
            return FastDebugInstallationResult.INSTALLED;
        }
        if (!strict) {
            DebuggerPreferences.getInstance().setDoNotAskAgain(rubyDebugPanel.isDoNotAskAgain());
        }
        if (button == cancelButton || button == NotifyDescriptor.CLOSED_OPTION) {
            return FastDebugInstallationResult.CANCELLED;
        }
        assert (button == useSlowButton) : "is slow button";
        return FastDebugInstallationResult.USE_SLOW;
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(Util.class, (String)key);
    }

    static enum FastDebugInstallationResult {
        INSTALLED,
        CANCELLED,
        FAILED,
        USE_SLOW;

    }
}

