/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger;

import java.util.List;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.ruby.debugger.RubySession;
import org.netbeans.modules.ruby.debugger.breakpoints.BreakpointModel;
import org.netbeans.modules.ruby.debugger.model.CallStackModel;
import org.netbeans.modules.ruby.debugger.model.SessionsTableModelFilter;
import org.netbeans.modules.ruby.debugger.model.ThreadsModel;
import org.netbeans.modules.ruby.debugger.model.VariablesModel;
import org.netbeans.modules.ruby.debugger.model.WatchesModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;

public class ContextProviderWrapper {
    private ContextProvider contextProvider;
    private static BreakpointModel breakpointModel;
    private static SessionsTableModelFilter sessionsModel;
    private RubySession rubySession;
    private CallStackModel callStackModel;
    private VariablesModel variablesModel;
    private WatchesModel watchesModel;
    private ThreadsModel threadsModel;

    public ContextProviderWrapper(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    private static <T> List<? extends T> debugLookup(String folder, Class<T> clazz) {
        return DebuggerManager.getDebuggerManager().lookup(folder, clazz);
    }

    static <T> T lookupFirst(ContextProvider cp, Class<T> clazz) {
        return (T)cp.lookupFirst(null, clazz);
    }

    public void fireModelChanges() {
        this.getThreadsModel().fireChanges();
        this.getCallStackModel().fireChanges();
        this.getVariablesModel().fireChanges();
        this.getWatchesModel().fireChanges();
        ContextProviderWrapper.getBreakpointModel().fireChanges();
        ContextProviderWrapper.getSessionsModel().fireChanges();
    }

    public static SessionsTableModelFilter getSessionsModel() {
        if (sessionsModel == null) {
            List<TableModelFilter> tableModels = ContextProviderWrapper.debugLookup("SessionsView", TableModelFilter.class);
            for (TableModelFilter model : tableModels) {
                if (!(model instanceof SessionsTableModelFilter)) continue;
                sessionsModel = (SessionsTableModelFilter)model;
                break;
            }
        }
        return sessionsModel;
    }

    public static BreakpointModel getBreakpointModel() {
        if (breakpointModel == null) {
            List<NodeModel> tableModels = ContextProviderWrapper.debugLookup("BreakpointsView", NodeModel.class);
            for (NodeModel model : tableModels) {
                if (!(model instanceof BreakpointModel)) continue;
                breakpointModel = (BreakpointModel)model;
                break;
            }
        }
        return breakpointModel;
    }

    public RubySession getRubySession() {
        if (this.rubySession == null) {
            this.rubySession = ContextProviderWrapper.lookupFirst(this.contextProvider, RubySession.class);
        }
        return this.rubySession;
    }

    public ThreadsModel getThreadsModel() {
        if (this.threadsModel == null) {
            this.threadsModel = (ThreadsModel)this.contextProvider.lookupFirst("ThreadsView", TreeModel.class);
        }
        return this.threadsModel;
    }

    public CallStackModel getCallStackModel() {
        if (this.callStackModel == null) {
            this.callStackModel = (CallStackModel)this.contextProvider.lookupFirst("CallStackView", TreeModel.class);
        }
        return this.callStackModel;
    }

    public VariablesModel getVariablesModel() {
        if (this.variablesModel == null) {
            this.variablesModel = (VariablesModel)this.contextProvider.lookupFirst("LocalsView", TreeModel.class);
        }
        return this.variablesModel;
    }

    public WatchesModel getWatchesModel() {
        if (this.watchesModel == null) {
            this.watchesModel = (WatchesModel)this.contextProvider.lookupFirst("WatchesView", TreeModel.class);
        }
        return this.watchesModel;
    }
}

